/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.datastructure;

import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class DistinctIterator<T>
implements Iterator<T> {
    private final Iterator<T> it;
    private final Set<T> passed;
    private T next;

    public DistinctIterator(Iterator<T> it) {
        this(it, false);
    }

    public DistinctIterator(Iterator<T> it, boolean identity) {
        this.it = it;
        this.passed = identity ? Sets.newIdentityHashSet() : Sets.newHashSet();
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        while (this.it.hasNext()) {
            this.next = this.it.next();
            if (!this.passed.add(this.next)) continue;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T ret = this.next;
        this.next = null;
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

