/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.component;

import javax.annotation.Nullable;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.lwjgl.input.Mouse;

public class GuiScrollBar
extends Gui {
    private static final ResourceLocation SCROLLBUTTON = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static final int SCROLL_BUTTON_HEIGHT = 15;
    private static final int SCROLL_BUTTON_WIDTH = 12;
    private final int x;
    private final int y;
    private final int height;
    @Nullable
    private final IScrollCallback scrollCallback;
    private int totalRows;
    private int visibleRows;
    private float currentScroll;
    private boolean isScrolling;
    private boolean wasClicking;

    public GuiScrollBar(int x, int y, int height, @Nullable IScrollCallback scrollCallback, int visibleRows) {
        this.x = x;
        this.y = y;
        this.height = height;
        this.scrollCallback = scrollCallback;
        this.currentScroll = 0.0f;
        this.isScrolling = false;
        this.wasClicking = false;
        this.setVisibleRows(visibleRows);
    }

    public float getCurrentScroll() {
        return this.currentScroll;
    }

    public void handleMouseInput() {
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.needsScrollBars()) {
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.scrollRelative(i);
        }
    }

    public void drawCurrentScreen(int mouseX, int mouseY, float partialTicks) {
        boolean flag = Mouse.isButtonDown((int)0);
        int i1 = this.x;
        int j1 = this.y;
        int k1 = i1 + 14;
        int l1 = j1 + this.height;
        if (!this.needsScrollBars() && this.currentScroll > 0.0f) {
            this.scrollTo(0.0f);
        }
        if (!this.wasClicking && flag && mouseX >= i1 && mouseY >= j1 && mouseX < k1 && mouseY < l1) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(mouseY - j1) - 7.5f) / ((float)(l1 - j1) - 15.0f);
            this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
            this.scrollTo(this.currentScroll);
        }
    }

    public void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        int scrollX = this.x;
        int scrollMinY = this.y;
        int scrollMaxY = scrollMinY + this.height;
        RenderHelpers.bindTexture(SCROLLBUTTON);
        this.func_73729_b(scrollX, scrollMinY + (int)((float)(scrollMaxY - scrollMinY - 15 - 2) * this.currentScroll), 232 + (this.needsScrollBars() ? 0 : 12), 0, 12, 15);
    }

    protected boolean needsScrollBars() {
        return this.getTotalRows() > this.getVisibleRows();
    }

    protected int getScrollStep() {
        return this.getTotalRows() - this.getVisibleRows() + 1;
    }

    protected void scrollRelative(int step) {
        float scroll = (float)((double)this.currentScroll - (double)step / (double)this.getScrollStep());
        scroll = MathHelper.func_76131_a((float)scroll, (float)0.0f, (float)1.0f);
        this.scrollTo(scroll);
    }

    public void scrollTo(float scroll) {
        this.currentScroll = scroll;
        if (this.scrollCallback != null) {
            int firstRow = (int)((double)(scroll * (float)this.getScrollStep()) + 0.5);
            this.scrollCallback.onScroll(firstRow);
        }
    }

    public int getTotalRows() {
        return this.totalRows;
    }

    public void setTotalRows(int totalRows) {
        this.totalRows = totalRows;
    }

    public int getVisibleRows() {
        return this.visibleRows;
    }

    public void setVisibleRows(int visibleRows) {
        this.visibleRows = visibleRows;
    }

    public static interface IScrollCallback {
        public void onScroll(int var1);
    }
}

