/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.block;

import epicsquid.mysticallib.LibRegistry;
import epicsquid.mysticallib.block.CustomStateMapper;
import epicsquid.mysticallib.block.IBlock;
import epicsquid.mysticallib.model.CustomModelBlock;
import epicsquid.mysticallib.model.CustomModelLoader;
import epicsquid.mysticallib.model.ICustomModeledObject;
import epicsquid.mysticallib.model.IModeledObject;
import epicsquid.mysticallib.model.block.BakedModelBlock;
import epicsquid.mysticallib.model.block.BakedModelTrapDoor;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTrapDoorBase
extends BlockTrapDoor
implements IBlock,
IModeledObject,
ICustomModeledObject {
    @Nonnull
    private final Item itemBlock;
    public List<ItemStack> drops = null;
    private boolean isOpaque = false;
    private boolean hasCustomModel = false;
    private boolean isFlammable = false;
    private BlockRenderLayer layer = BlockRenderLayer.CUTOUT;
    private Block parent;
    public String name = "";

    public BlockTrapDoorBase(@Nonnull Block base, @Nonnull SoundType type, float hardness, @Nonnull String name) {
        super(base.func_176223_P().func_185904_a());
        this.parent = base;
        this.name = name;
        this.func_149647_a(null);
        this.func_149663_c(name);
        this.setRegistryName(LibRegistry.getActiveModid(), name);
        this.func_149672_a(type);
        this.func_149711_c(hardness);
        this.field_149787_q = false;
        this.itemBlock = (Item)new ItemBlock((Block)this).setRegistryName(LibRegistry.getActiveModid(), name);
    }

    @Override
    @Nullable
    public Item getItemBlock() {
        return this.itemBlock;
    }

    @Nonnull
    public BlockTrapDoorBase setFlammable(boolean flammable) {
        this.isFlammable = flammable;
        return this;
    }

    @Nonnull
    public BlockTrapDoorBase setResistance(float resistance) {
        super.func_149752_b(resistance);
        return this;
    }

    @Nonnull
    public BlockTrapDoorBase setModelCustom(boolean custom) {
        this.hasCustomModel = custom;
        return this;
    }

    @Nonnull
    public BlockTrapDoorBase setHarvestReqs(String tool, int level) {
        this.setHarvestLevel(tool, level);
        return this;
    }

    @Nonnull
    public BlockTrapDoorBase setOpacity(boolean isOpaque) {
        this.isOpaque = isOpaque;
        return this;
    }

    @Nonnull
    public BlockTrapDoorBase setLayer(@Nonnull BlockRenderLayer layer) {
        this.layer = layer;
        return this;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return this.isOpaque;
    }

    public boolean hasCustomModel() {
        return this.hasCustomModel;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    public boolean canPlaceTorchOnTop(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return false;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == this.func_149708_J()) {
            list.add((Object)new ItemStack((Block)this, 1));
        }
    }

    public boolean isFlammable(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return this.isFlammable || super.isFlammable(world, pos, face);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.isFlammable ? 100 : super.getFlammability(world, pos, face);
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return this.layer;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this.itemBlock);
    }

    @Nonnull
    public Block getParent() {
        return this.parent;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        if (this.hasCustomModel) {
            ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new CustomStateMapper());
        }
        if (!this.hasCustomModel) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "handlers"));
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "handlers"));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initCustomModel() {
        if (this.hasCustomModel) {
            ResourceLocation defaultTex = new ResourceLocation(this.parent.getRegistryName().func_110624_b() + ":blocks/" + this.parent.getRegistryName().func_110623_a());
            CustomModelLoader.blockmodels.put(new ResourceLocation(this.getRegistryName().func_110624_b() + ":models/block/" + this.name), new CustomModelBlock(this.getModelClass(), defaultTex, defaultTex));
            CustomModelLoader.itemmodels.put(new ResourceLocation(this.getRegistryName().func_110624_b() + ":" + this.name + "#handlers"), new CustomModelBlock(this.getModelClass(), defaultTex, defaultTex));
        }
    }

    @Nonnull
    protected Class<? extends BakedModelBlock> getModelClass() {
        return BakedModelTrapDoor.class;
    }
}

