/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.advancement;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import epicsquid.mysticallib.advancement.IGenericPredicate;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;

public class GenericTrigger<T>
implements ICriterionTrigger<Instance<T>> {
    private final ResourceLocation id;
    private final Map<PlayerAdvancements, Listeners<T>> listeners = Maps.newHashMap();
    private final IGenericPredicate<T> predicate;

    public GenericTrigger(String id, IGenericPredicate<T> predicate) {
        this(new ResourceLocation(id), predicate);
    }

    public GenericTrigger(ResourceLocation id, IGenericPredicate<T> predicate) {
        this.id = id;
        this.predicate = predicate;
    }

    @Nonnull
    public ResourceLocation func_192163_a() {
        return this.id;
    }

    public void func_192165_a(@Nonnull PlayerAdvancements advancementsIn, @Nonnull ICriterionTrigger.Listener<Instance<T>> listener) {
        Listeners<T> list = this.listeners.get(advancementsIn);
        if (list == null) {
            list = new Listeners(advancementsIn);
            this.listeners.put(advancementsIn, list);
        }
        list.add(listener);
    }

    public void func_192164_b(@Nonnull PlayerAdvancements advancementsIn, @Nonnull ICriterionTrigger.Listener<Instance<T>> listener) {
        Listeners<T> list = this.listeners.get(advancementsIn);
        if (list != null) {
            list.remove(listener);
            if (list.isEmpty()) {
                this.listeners.remove(advancementsIn);
            }
        }
    }

    public void func_192167_a(@Nonnull PlayerAdvancements advancementsIn) {
        this.listeners.remove(advancementsIn);
    }

    @Nonnull
    public Instance<T> deserializeInstance(@Nonnull JsonObject json, @Nonnull JsonDeserializationContext context) {
        return new Instance<T>(this.func_192163_a(), this.predicate.deserialize((JsonElement)json));
    }

    public void trigger(EntityPlayerMP player, T condition) {
        Listeners<T> list = this.listeners.get(player.func_192039_O());
        if (list != null) {
            list.trigger(player, condition);
        }
    }

    public static class Listeners<T> {
        PlayerAdvancements advancements;
        Set<ICriterionTrigger.Listener<Instance<T>>> listeners = Sets.newHashSet();

        Listeners(PlayerAdvancements advancementsIn) {
            this.advancements = advancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<Instance<T>> listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<Instance<T>> listener) {
            this.listeners.remove(listener);
        }

        void trigger(EntityPlayerMP player, T condition) {
            ArrayList list = Lists.newArrayList();
            for (ICriterionTrigger.Listener<Instance<T>> listener : this.listeners) {
                if (!((Instance)listener.func_192158_a()).test(player, condition)) continue;
                list.add(listener);
            }
            if (list.size() != 0) {
                for (ICriterionTrigger.Listener listener : list) {
                    listener.func_192159_a(this.advancements);
                }
            }
        }
    }

    public static class Instance<T>
    extends AbstractCriterionInstance {
        IGenericPredicate<T> predicate;

        Instance(ResourceLocation location, IGenericPredicate<T> predicate) {
            super(location);
            this.predicate = predicate;
        }

        public boolean test(EntityPlayerMP player, T event) {
            return this.predicate.test(player, event);
        }
    }
}

