/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.docmanagement;

import com.brandon3055.brandonscore.integration.ModHelperBC;
import com.brandon3055.projectintelligence.client.DisplayController;
import com.brandon3055.projectintelligence.client.PIGuiHelper;
import com.brandon3055.projectintelligence.client.gui.PIConfig;
import com.brandon3055.projectintelligence.docmanagement.ContentRelation;
import com.brandon3055.projectintelligence.docmanagement.DocumentationManager;
import com.brandon3055.projectintelligence.docmanagement.LanguageManager;
import com.brandon3055.projectintelligence.docmanagement.ModStructurePage;
import com.google.common.base.Objects;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.JsonUtils;

public class DocumentationPage {
    public static Random random = new Random();
    protected LinkedList<DocumentationPage> subPages = new LinkedList();
    protected DocumentationPage parent = null;
    protected LinkedList<JsonObject> icons = new LinkedList();
    protected LinkedList<ContentRelation> relations = new LinkedList();
    protected int sortingWeight;
    protected String modid;
    protected String pageId;
    protected String pageURI;
    protected boolean isPackDoc;
    protected String modVersion;
    protected String markdownFile = "";
    protected String rawMarkdownString;
    protected boolean hidden;
    protected boolean cycle_icons;
    public final int treeDepth;
    private LinkedList<String> mdLineCache = null;
    private File lastFile = null;

    public DocumentationPage(DocumentationPage parent, String modid, String modVersion, boolean isPackDoc) {
        this.parent = parent;
        this.modid = modid;
        this.modVersion = modVersion;
        this.isPackDoc = isPackDoc;
        this.treeDepth = parent == null ? 0 : parent.treeDepth + 1;
    }

    public LinkedList<DocumentationPage> getSubPages() {
        return this.subPages;
    }

    public void generatePageURIs(String parentURI, Map<String, DocumentationPage> URIPageMap) {
        this.pageURI = (parentURI.endsWith(":") ? parentURI : parentURI + "/") + this.pageId;
        if (URIPageMap.containsKey(this.pageURI)) {
            PIGuiHelper.displayError("Detected duplicate page! " + this.modid + ":" + this.pageURI);
            return;
        }
        URIPageMap.put(this.pageURI, this);
        this.subPages.forEach(documentationPage -> documentationPage.generatePageURIs(this.pageURI, URIPageMap));
    }

    public String getModid() {
        return this.modid;
    }

    public String getModName() {
        return ModHelperBC.getModName((String)this.modid);
    }

    public String getModPageName() {
        return LanguageManager.getPageName(this.getModid() + ":", this.getLocalizationLang());
    }

    public String getPageId() {
        return this.pageId;
    }

    public String getLocalizationLang() {
        return LanguageManager.getPageLanguage(this.getPageURI());
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public LinkedList<JsonObject> getIcons() {
        return this.icons;
    }

    public boolean cycle_icons() {
        return this.cycle_icons;
    }

    public LinkedList<ContentRelation> getRelations() {
        return this.relations;
    }

    public String getDisplayName() {
        return LanguageManager.getPageName(this.pageURI, this.getLocalizationLang());
    }

    public File getMarkdownFile() {
        if (this.isPackDoc) {
            return new File(DocumentationManager.getPackDocDirectory(), this.modid + "/" + this.getLocalizationLang() + "/" + this.markdownFile);
        }
        return new File(DocumentationManager.getDocDirectory(), this.modid + "/" + this.modVersion + "/" + this.getLocalizationLang() + "/" + this.markdownFile);
    }

    public boolean isPackDoc() {
        return this.isPackDoc;
    }

    public LinkedList<String> getMarkdownLines() {
        if (PIConfig.editMode() || this.mdLineCache == null || !Objects.equal((Object)this.lastFile, (Object)this.getMarkdownFile())) {
            this.mdLineCache = new LinkedList();
            File mdFile = this.getMarkdownFile();
            LanguageManager.PageLangData data = LanguageManager.getLangData(this.pageURI, this.getLocalizationLang());
            if (data == null && !PIConfig.editMode()) {
                this.mdLineCache.add("This page has not yet been translated to your language!");
                this.mdLineCache.add("Click the \"Broken Language\" icon on the page button to select an alternate language.");
                this.mdLineCache.add("Or change your selected language in PI settings (PI language can be set independently from Minecraft language)");
            } else if (!mdFile.exists() || this.markdownFile.isEmpty()) {
                this.mdLineCache.add("Error Loading Page!");
                if (this.markdownFile.isEmpty()) {
                    this.mdLineCache.add("There is no document file listed for this page. This most likely means the documentation for this page has not been written yet.");
                } else {
                    this.mdLineCache.add("Could not find page md file: " + mdFile);
                }
            } else {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(mdFile), StandardCharsets.UTF_8));){
                    String s;
                    while ((s = reader.readLine()) != null) {
                        this.mdLineCache.add(s);
                    }
                }
                catch (IOException e) {
                    this.mdLineCache.add("Error Loading Page!");
                    this.mdLineCache.add("An error occurred while reading the md file! ");
                    this.mdLineCache.add("File: " + mdFile);
                    for (StackTraceElement el : e.getStackTrace()) {
                        this.mdLineCache.add(el.toString());
                    }
                }
            }
        }
        return this.mdLineCache;
    }

    public DocumentationPage getParent() {
        return this.parent;
    }

    public int getSortingWeight() {
        return this.sortingWeight;
    }

    protected String getPageFilePath() {
        return this.parent == null || this.parent.getClass() != DocumentationPage.class ? this.getPageId() : this.parent.getPageId() + "/" + this.getPageId();
    }

    public String getPageURI() {
        return this.pageURI;
    }

    public String getModVersion() {
        return this.modVersion;
    }

    public void setRawMarkdown(String rawMarkdownString) throws MDException {
        File mdFile;
        File mdParent;
        if (this.getPageId().isEmpty()) {
            throw new MDException("Please set page id before writing content. Page id is used to save content to disk.");
        }
        this.rawMarkdownString = rawMarkdownString;
        this.mdLineCache = null;
        if (this.markdownFile.isEmpty()) {
            do {
                this.markdownFile = this.getPageFilePath() + "_" + DocumentationPage.genHex() + ".md";
            } while (this.getMarkdownFile().exists());
        }
        if (!(mdParent = (mdFile = this.getMarkdownFile()).getParentFile()).exists() && !mdParent.mkdirs()) {
            throw new MDException("Was unable to create parent folder for markdown file!. \nParent Folder: " + mdParent.getAbsolutePath());
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(mdFile), StandardCharsets.UTF_8);){
            writer.write(rawMarkdownString);
            this.saveToDisk();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MDException("An error occurred while saving markdown to disk. " + e.getMessage() + " See console for full stack trace");
        }
        DisplayController.MASTER_CONTROLLER.getActiveTab().reloadTab();
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
        this.saveToDisk();
    }

    public void setSortingWeight(int sortingWeight) {
        this.sortingWeight = sortingWeight;
        this.saveToDisk();
    }

    public void setRevision(int revision) {
        LanguageManager.PageLangData data = LanguageManager.getLangData(this.pageURI, LanguageManager.getUserLanguage());
        if (data != null) {
            data.pageRev = revision;
        }
        this.saveToDisk();
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
        this.saveToDisk();
    }

    public void setCycle_icons(boolean cycle_icons) {
        this.cycle_icons = cycle_icons;
        this.saveToDisk();
    }

    public void loadFromJson(JsonObject jObj) {
        this.pageId = JsonUtils.func_151219_a((JsonObject)jObj, (String)"id", (String)"<invalid-id>");
        this.markdownFile = JsonUtils.func_151219_a((JsonObject)jObj, (String)"file", (String)"");
        this.sortingWeight = JsonUtils.func_151208_a((JsonObject)jObj, (String)"sorting_weight", (int)0);
        this.cycle_icons = JsonUtils.func_151209_a((JsonObject)jObj, (String)"cycle_icons", (boolean)false);
        this.hidden = JsonUtils.func_151209_a((JsonObject)jObj, (String)"hidden", (boolean)false);
        if (JsonUtils.func_151202_d((JsonObject)jObj, (String)"relations")) {
            this.relations.clear();
            for (JsonElement element : JsonUtils.func_151214_t((JsonObject)jObj, (String)"relations")) {
                ContentRelation relation;
                if (!element.isJsonObject() || (relation = ContentRelation.fromJson(element.getAsJsonObject())) == null) continue;
                this.relations.add(relation);
            }
        }
        if (JsonUtils.func_151202_d((JsonObject)jObj, (String)"icons")) {
            this.icons.clear();
            for (JsonElement element : JsonUtils.func_151214_t((JsonObject)jObj, (String)"icons")) {
                if (!element.isJsonObject()) continue;
                this.icons.add(element.getAsJsonObject());
            }
        }
        if (JsonUtils.func_151202_d((JsonObject)jObj, (String)"pages")) {
            this.loadSubPages(JsonUtils.func_151214_t((JsonObject)jObj, (String)"pages"));
        }
    }

    public void loadSubPages(JsonArray pageArray) {
        this.subPages.clear();
        for (JsonElement element : pageArray) {
            if (!element.isJsonObject()) continue;
            DocumentationPage subPage = new DocumentationPage(this, this.modid, this.modVersion, this.isPackDoc);
            subPage.loadFromJson(element.getAsJsonObject());
            this.subPages.add(subPage);
        }
    }

    public JsonObject writeToJson() {
        JsonArray array;
        JsonObject jObj = new JsonObject();
        jObj.addProperty("id", this.pageId);
        jObj.addProperty("file", this.markdownFile);
        jObj.addProperty("cycle_icons", Boolean.valueOf(this.cycle_icons));
        jObj.addProperty("hidden", Boolean.valueOf(this.hidden));
        if (this.sortingWeight > 0) {
            jObj.addProperty("sorting_weight", (Number)this.sortingWeight);
        }
        if (this.relations.size() > 0) {
            array = new JsonArray();
            for (ContentRelation relation : this.relations) {
                array.add((JsonElement)relation.toJson());
            }
            jObj.add("relations", (JsonElement)array);
        }
        if (this.icons.size() > 0) {
            array = new JsonArray();
            for (JsonObject icon : this.icons) {
                array.add((JsonElement)icon);
            }
            jObj.add("icons", (JsonElement)array);
        }
        if (this.getSubPages().size() > 0) {
            JsonArray subPages = new JsonArray();
            this.writeSubPages(subPages);
            jObj.add("pages", (JsonElement)subPages);
        }
        return jObj;
    }

    public void writeSubPages(JsonArray pageArray) {
        for (DocumentationPage page : this.getSubPages()) {
            pageArray.add((JsonElement)page.writeToJson());
        }
    }

    public void saveToDisk() {
        if (!(this instanceof ModStructurePage) && this.parent != null) {
            this.parent.saveToDisk();
        } else if (this instanceof ModStructurePage) {
            DocumentationManager.saveDocToDisk((ModStructurePage)this);
        }
    }

    public String toString() {
        return this.getDisplayName();
    }

    private static String genHex() {
        StringBuffer sb = new StringBuffer();
        while (sb.length() < 5) {
            sb.append(Integer.toHexString(random.nextInt()));
        }
        return sb.toString().substring(0, 5);
    }

    public void deletePage() {
        this.getSubPages().forEach(DocumentationPage::deletePage);
        if (this.getMarkdownFile().exists()) {
            this.getMarkdownFile().delete();
        }
        if (this.parent != null) {
            this.parent.getSubPages().remove(this);
            this.parent.saveToDisk();
        }
    }

    public static class MDException
    extends Exception {
        public MDException(String message) {
            super(message);
        }
    }
}

