/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.events;

import ca.wescook.nutrition.Nutrition;
import ca.wescook.nutrition.utility.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButtonImage;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EventNutritionButton {
    private int NUTRITION_ID = 800;
    private ResourceLocation NUTRITION_ICON = new ResourceLocation("nutrition", "textures/gui/gui.png");
    private GuiButtonImage buttonNutrition;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void guiOpen(GuiScreenEvent.InitGuiEvent.Post event) {
        GuiScreen gui = event.getGui();
        if (!(gui instanceof GuiInventory)) {
            return;
        }
        int[] pos = this.calculateButtonPosition(gui);
        int x = pos[0];
        int y = pos[1];
        this.buttonNutrition = new GuiButtonImage(this.NUTRITION_ID, x, y, 20, 18, 14, 0, 19, this.NUTRITION_ICON);
        event.getButtonList().add(this.buttonNutrition);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void guiButtonClick(GuiScreenEvent.ActionPerformedEvent.Post event) {
        if (!(event.getGui() instanceof GuiInventory)) {
            return;
        }
        if (event.getButton().equals(this.buttonNutrition)) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            player.openGui((Object)Nutrition.instance, 0, (World)world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        } else {
            int[] pos = this.calculateButtonPosition(event.getGui());
            int xPosition = pos[0];
            int yPosition = pos[1];
            this.buttonNutrition.func_191746_c(xPosition, yPosition);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private int[] calculateButtonPosition(GuiScreen gui) {
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        if (Config.buttonOrigin.equals("screen")) {
            ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
            width = scaledResolution.func_78326_a();
            height = scaledResolution.func_78328_b();
        } else if (Config.buttonOrigin.equals("gui")) {
            width = ((GuiInventory)gui).getXSize();
            height = ((GuiInventory)gui).getYSize();
        }
        switch (Config.buttonAnchor) {
            case "top": {
                x = width / 2;
                y = 0;
                break;
            }
            case "right": {
                x = width;
                y = height / 2;
                break;
            }
            case "bottom": {
                x = width / 2;
                y = height;
                break;
            }
            case "left": {
                x = 0;
                y = height / 2;
                break;
            }
            case "top-left": {
                x = 0;
                y = 0;
                break;
            }
            case "top-right": {
                x = width;
                y = 0;
                break;
            }
            case "bottom-right": {
                x = width;
                y = height;
                break;
            }
            case "bottom-left": {
                x = 0;
                y = height;
                break;
            }
            case "center": {
                x = width / 2;
                y = height / 2;
            }
        }
        if (Config.buttonOrigin.equals("gui")) {
            x += ((GuiInventory)gui).getGuiLeft();
            y += ((GuiInventory)gui).getGuiTop();
        }
        return new int[]{x += Config.buttonXPosition, y += Config.buttonYPosition};
    }
}

