/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.coremod.commands.MinecoloniesCommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.jetbrains.annotations.NotNull;

public final class TeleportToColony {
    private static final String CANT_FIND_COLONY = "No Colony found for teleport, please define one.";
    private static final String CANT_FIND_PLAYER = "No player found for teleport, please define one.";
    private static final String NO_TOWNHALL = "Target colony has no town hall, can't teleport.";
    private static final int SOUND_TYPE = 1032;
    private static final int MIN_COLONY_ID = 1;

    private TeleportToColony() {
    }

    @NotNull
    public static void colonyTeleport(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) {
        int colonyId;
        EntityPlayer playerToTeleport;
        Entity senderEntity = sender.func_174793_f();
        if (senderEntity instanceof EntityPlayer) {
            if (args.length == 0) {
                playerToTeleport = (EntityPlayer)sender;
                IColony colony = ColonyManager.getIColonyByOwner(((EntityPlayer)sender).field_70170_p, (EntityPlayer)sender);
                if (colony == null) {
                    return;
                }
                colonyId = colony.getID();
            } else {
                playerToTeleport = (EntityPlayer)sender;
                colonyId = Integer.valueOf(args[0]);
            }
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString(CANT_FIND_PLAYER));
            return;
        }
        if (MinecoloniesCommand.canExecuteCommand((EntityPlayer)sender)) {
            TeleportToColony.teleportPlayer(playerToTeleport, colonyId, sender);
            return;
        }
        sender.func_145747_a((ITextComponent)new TextComponentString("Please wait at least " + Configurations.gameplay.teleportBuffer + " seconds to teleport again"));
    }

    private static void teleportPlayer(EntityPlayer playerToTeleport, int colID, ICommandSender sender) {
        Colony colony = ColonyManager.getColonyByWorld(colID, (World)FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0));
        BuildingTownHall townHall = colony.getBuildingManager().getTownHall();
        if (townHall == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(NO_TOWNHALL));
            return;
        }
        BlockPos position = townHall.getLocation();
        int dimension = playerToTeleport.func_130014_f_().field_73011_w.getDimension();
        int colonyDimension = townHall.getColony().getDimension();
        if (colID < 1) {
            sender.func_145747_a((ITextComponent)new TextComponentString(CANT_FIND_COLONY));
            return;
        }
        EntityPlayerMP entityPlayerMP = (EntityPlayerMP)sender;
        if (dimension != colonyDimension) {
            playerToTeleport.func_145747_a((ITextComponent)new TextComponentString("We got places to go, kid..."));
            playerToTeleport.func_145747_a((ITextComponent)new TextComponentString("Buckle up buttercup, this ain't no joy ride!!!"));
            MinecraftServer server = sender.func_130014_f_().func_73046_m();
            WorldServer worldServer = server.func_71218_a(colonyDimension);
            entityPlayerMP.field_71135_a.func_147359_a((Packet)new SPacketEffect(1032, BlockPos.field_177992_a, 0, false));
            entityPlayerMP.func_71023_q(0);
            entityPlayerMP.func_71118_n();
            playerToTeleport.func_145747_a((ITextComponent)new TextComponentString("Hold onto your pants, we're going Inter-Dimensional!"));
            worldServer.func_73046_m().func_184103_al().transferPlayerToDimension(entityPlayerMP, colonyDimension, new Teleporter(worldServer));
            if (dimension == 1) {
                worldServer.func_72838_d((Entity)playerToTeleport);
                worldServer.func_72866_a((Entity)playerToTeleport, false);
            }
        }
        entityPlayerMP.field_71135_a.func_147364_a((double)position.func_177958_n(), (double)position.func_177956_o() + 2.0, (double)position.func_177952_p(), entityPlayerMP.field_70177_z, entityPlayerMP.field_70125_A);
    }
}

