/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class ToggleJobMessage
extends AbstractMessage<ToggleJobMessage, IMessage> {
    private int colonyId;
    private boolean toggle;
    private int dimension;

    public ToggleJobMessage() {
    }

    public ToggleJobMessage(@NotNull ColonyView colony, boolean toggle) {
        this.colonyId = colony.getID();
        this.toggle = toggle;
        this.dimension = colony.getDimension();
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.toggle = buf.readBoolean();
        this.dimension = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeBoolean(this.toggle);
        buf.writeInt(this.dimension);
    }

    @Override
    public void messageOnServerThread(ToggleJobMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColonyByDimension(message.colonyId, message.dimension);
        if (colony != null) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
                return;
            }
            colony.setManualHiring(message.toggle);
        }
    }
}

