/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import com.minecolonies.coremod.util.TeleportHelper;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class RecallSingleCitizenMessage
extends AbstractMessage<RecallSingleCitizenMessage, IMessage> {
    private int colonyId;
    private BlockPos buildingId;
    private int citizenId;
    private int dimension;

    public RecallSingleCitizenMessage() {
    }

    public RecallSingleCitizenMessage(AbstractBuildingView building, int citizenid) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.citizenId = citizenid;
        this.dimension = building.getColony().getDimension();
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.citizenId = buf.readInt();
        this.dimension = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        buf.writeInt(this.citizenId);
        buf.writeInt(this.dimension);
    }

    @Override
    public void messageOnServerThread(RecallSingleCitizenMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColonyByDimension(message.colonyId, message.dimension);
        if (colony != null) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
                return;
            }
            CitizenData citizenData = colony.getCitizenManager().getCitizen(message.citizenId);
            Optional<EntityCitizen> optionalEntityCitizen = citizenData.getCitizenEntity();
            if (!optionalEntityCitizen.isPresent()) {
                citizenData.updateCitizenEntityIfNecessary();
                optionalEntityCitizen = citizenData.getCitizenEntity();
            }
            if (optionalEntityCitizen.isPresent() && optionalEntityCitizen.get().field_70173_aa == 0) {
                citizenData.updateCitizenEntityIfNecessary();
            }
            BlockPos loc = message.buildingId;
            if (optionalEntityCitizen.isPresent() && !TeleportHelper.teleportCitizen(optionalEntityCitizen.get(), colony.getWorld(), loc)) {
                LanguageHandler.sendPlayerMessage((EntityPlayer)player, "com.minecolonies.coremod.workerHuts.recallFail", new Object[0]);
            }
        }
    }
}

