/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.views.MobEntryView;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class GuardMobAttackListMessage
extends AbstractMessage<GuardMobAttackListMessage, IMessage> {
    private BlockPos buildingId;
    private int colonyId;
    private List<MobEntryView> mobsToAttack = new ArrayList<MobEntryView>();

    public GuardMobAttackListMessage() {
    }

    public GuardMobAttackListMessage(int colonyId, BlockPos buildingId, List<MobEntryView> mobsToAttack) {
        this.colonyId = colonyId;
        this.buildingId = buildingId;
        this.mobsToAttack = new ArrayList<MobEntryView>(mobsToAttack);
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.colonyId = byteBuf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(byteBuf);
        int mobSize = byteBuf.readInt();
        for (int i = 0; i < mobSize; ++i) {
            MobEntryView mobEntry = MobEntryView.readFromByteBuf(byteBuf);
            this.mobsToAttack.add(mobEntry);
        }
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(byteBuf, this.buildingId);
        byteBuf.writeInt(this.mobsToAttack.size());
        for (MobEntryView entry : this.mobsToAttack) {
            MobEntryView.writeToByteBuf(byteBuf, entry);
        }
    }

    @Override
    protected void messageOnClientThread(GuardMobAttackListMessage message, MessageContext ctx) {
        AbstractBuildingGuards.View buildingView;
        ColonyView colonyView = ColonyManager.getColonyView(message.colonyId, Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension());
        if (colonyView != null && (buildingView = (AbstractBuildingGuards.View)colonyView.getBuilding(message.buildingId)) != null) {
            buildingView.setMobsToAttack(message.mobsToAttack);
        }
    }
}

