/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.blocks.BlockDecorationController;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import com.minecolonies.coremod.tileentities.TileEntityDecorationController;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class DecorationBuildRequestMessage
extends AbstractMessage<DecorationBuildRequestMessage, IMessage> {
    private BlockPos pos;
    private String name;
    private int level;
    private int dimension;

    public DecorationBuildRequestMessage() {
    }

    public DecorationBuildRequestMessage(@NotNull BlockPos pos, String name, int level, int dimension) {
        this.pos = pos;
        this.name = name;
        this.level = level;
        this.dimension = dimension;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.pos = BlockPosUtil.readFromByteBuf(buf);
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.level = buf.readInt();
        this.dimension = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        BlockPosUtil.writeToByteBuf(buf, this.pos);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        buf.writeInt(this.level);
        buf.writeInt(this.dimension);
    }

    @Override
    public void messageOnServerThread(DecorationBuildRequestMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColonyByPosFromDim(message.dimension, message.pos);
        if (colony == null) {
            return;
        }
        if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
            return;
        }
        TileEntity entity = player.func_71121_q().func_175625_s(message.pos);
        if (entity instanceof TileEntityDecorationController) {
            Optional<Map.Entry> wo = colony.getWorkManager().getWorkOrders().entrySet().stream().filter(entry -> entry.getValue() instanceof WorkOrderBuildDecoration).filter(entry -> ((WorkOrderBuildDecoration)entry.getValue()).getBuildingLocation().equals((Object)message.pos)).findFirst();
            if (wo.isPresent()) {
                colony.getWorkManager().removeWorkOrder((Integer)wo.get().getKey());
                return;
            }
            IBlockState state = player.func_71121_q().func_180495_p(message.pos);
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockDecorationController.field_185512_D);
            EnumFacing basic = ((TileEntityDecorationController)entity).getBasicFacing();
            int difference = facing.func_176736_b() - basic.func_176736_b();
            if (difference < 0) {
                difference += 4;
            }
            WorkOrderBuildDecoration order = new WorkOrderBuildDecoration(message.name + message.level, message.name + message.level, difference, message.pos, (Boolean)state.func_177229_b((IProperty)BlockDecorationController.MIRROR));
            if (message.level != ((TileEntityDecorationController)entity).getLevel()) {
                order.setLevelUp();
            }
            colony.getWorkManager().addWorkOrder(order, false);
        }
    }
}

