/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;

public class ColonyViewBuildingViewMessage
extends AbstractMessage<ColonyViewBuildingViewMessage, IMessage> {
    private int colonyId;
    private BlockPos buildingId;
    private ByteBuf buildingData;
    private int dimension;

    public ColonyViewBuildingViewMessage() {
    }

    public ColonyViewBuildingViewMessage(@NotNull AbstractBuilding building) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.buildingData = Unpooled.buffer();
        building.serializeToView(this.buildingData);
        this.dimension = building.getColony().getDimension();
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.buildingData = Unpooled.buffer((int)buf.readableBytes());
        this.dimension = buf.readInt();
        buf.readBytes(this.buildingData, buf.readableBytes());
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        buf.writeInt(this.dimension);
        buf.writeBytes(this.buildingData);
    }

    @Override
    protected void messageOnClientThread(ColonyViewBuildingViewMessage message, MessageContext ctx) {
        ColonyManager.handleColonyBuildingViewMessage(message.colonyId, message.buildingId, message.buildingData, message.dimension);
    }
}

