/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.management.Structures;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.blocks.huts.BlockHutTownHall;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBaker;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingDeliveryman;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingHome;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingWareHouse;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildBuilding;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildRemoval;
import com.minecolonies.coremod.entity.ai.citizen.baker.BakingProduct;
import com.minecolonies.coremod.entity.ai.citizen.baker.ProductState;
import com.minecolonies.coremod.event.EventHandler;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingMoveMessage
extends AbstractMessage<BuildingMoveMessage, IMessage> {
    private BlockPos buildingId;
    private IBlockState state;
    private String structureName;
    private String workOrderName;
    private int rotation;
    private BlockPos pos;
    private boolean mirror;

    public BuildingMoveMessage() {
    }

    public BuildingMoveMessage(String structureName, String workOrderName, BlockPos pos, int rotation, Mirror mirror, AbstractBuildingView building, IBlockState state) {
        this.structureName = structureName;
        this.workOrderName = workOrderName;
        this.pos = pos;
        this.rotation = rotation;
        this.mirror = mirror == Mirror.FRONT_BACK;
        this.buildingId = building.getID();
        this.state = state;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.structureName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.workOrderName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.pos = BlockPosUtil.readFromByteBuf(buf);
        this.rotation = buf.readInt();
        this.mirror = buf.readBoolean();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.state = NBTUtil.func_190008_d((NBTTagCompound)ByteBufUtils.readTag((ByteBuf)buf));
    }

    public void toBytes(@NotNull ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.structureName);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.workOrderName);
        BlockPosUtil.writeToByteBuf(buf, this.pos);
        buf.writeInt(this.rotation);
        buf.writeBoolean(this.mirror);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)this.state));
    }

    @Override
    public void messageOnServerThread(BuildingMoveMessage message, EntityPlayerMP player) {
        StructureName sn = new StructureName(message.structureName);
        if (!Structures.hasMD5((StructureName)sn)) {
            player.func_145747_a((ITextComponent)new TextComponentString("Can not build " + message.workOrderName + ": schematic missing!"));
            return;
        }
        BuildingMoveMessage.handleHut(CompatibilityUtils.getWorld((Entity)player), (EntityPlayer)player, sn, message.rotation, message.pos, message.mirror, message.buildingId, message.state);
    }

    private static void handleHut(@NotNull World world, @NotNull EntityPlayer player, StructureName sn, int rotation, @NotNull BlockPos buildPos, boolean mirror, BlockPos oldBuildingId, IBlockState state) {
        String hut = sn.getSection();
        Block block = Block.func_149684_b((String)("minecolonies:blockHut" + hut));
        Colony tempColony = ColonyManager.getClosestColony(world, buildPos);
        if (!(tempColony == null || tempColony.getPermissions().hasPermission(player, Action.MANAGE_HUTS) || block instanceof BlockHutTownHall && !ColonyManager.isTooCloseToColony(world, buildPos))) {
            return;
        }
        AbstractBuilding oldBuilding = ColonyManager.getBuilding(world, oldBuildingId);
        if (oldBuilding instanceof BuildingTownHall) {
            if (tempColony != null) {
                tempColony.getBuildingManager().setTownHall(null);
            }
            world.func_175655_b(oldBuildingId, false);
        } else if (oldBuilding instanceof BuildingWareHouse && tempColony != null) {
            tempColony.getBuildingManager().setWareHouse(null);
        }
        if (block != null && EventHandler.onBlockHutPlaced(world, player, block, buildPos)) {
            world.func_175655_b(oldBuildingId, false);
            world.func_175655_b(buildPos, true);
            world.func_175656_a(buildPos, state.func_185907_a(BlockPosUtil.getRotationFromRotations(rotation)));
            ((AbstractBlockHut)block).onBlockPlacedByBuildTool(world, buildPos, world.func_180495_p(buildPos), (EntityLivingBase)player, null, mirror, sn.getStyle());
            BuildingMoveMessage.setupBuilding(world, player, sn, rotation, buildPos, mirror, oldBuilding);
        }
    }

    private static void setupBuilding(@NotNull World world, @NotNull EntityPlayer player, StructureName sn, int rotation, @NotNull BlockPos buildPos, boolean mirror, @Nullable AbstractBuilding oldBuilding) {
        AbstractBuilding building = ColonyManager.getBuilding(world, buildPos);
        if (building == null) {
            Log.getLogger().error("BuildTool: building is null!");
        } else {
            Colony colony = ColonyManager.getColonyByPosFromWorld(world, buildPos);
            if (colony == null) {
                Log.getLogger().info("No colony for " + player.func_70005_c_());
                return;
            }
            if (building.getTileEntity() != null) {
                building.getTileEntity().setColony(colony);
            }
            building.setStyle(sn.getStyle());
            building.setRotation(rotation);
            if (mirror) {
                building.invertMirror();
            }
            building.setBuildingLevel(oldBuilding.getBuildingLevel());
            if (oldBuilding instanceof AbstractBuildingWorker) {
                List<CitizenData> workers = oldBuilding.getAssignedCitizen();
                Iterator<CitizenData> iterator = workers.iterator();
                while (iterator.hasNext()) {
                    CitizenData citizenData = iterator.next();
                    citizenData.setWorkBuilding(null);
                    citizenData.setWorkBuilding((AbstractBuildingWorker)building);
                    building.assignCitizen(citizenData);
                }
            }
            if (oldBuilding instanceof BuildingBaker) {
                for (Map.Entry entry : ((BuildingBaker)oldBuilding).getTasks().entrySet()) {
                    for (BakingProduct product : (List)entry.getValue()) {
                        ((BuildingBaker)building).addToTasks((ProductState)((Object)entry.getKey()), product);
                    }
                }
            } else if (oldBuilding instanceof BuildingDeliveryman) {
                ((BuildingDeliveryman)building).setBuildingToDeliver(((BuildingDeliveryman)oldBuilding).getBuildingToDeliver());
            }
            if (oldBuilding instanceof BuildingHome) {
                List<CitizenData> residents = oldBuilding.getAssignedCitizen();
                for (CitizenData citizenData : residents) {
                    citizenData.setHomeBuilding(building);
                    building.assignCitizen(citizenData);
                }
            }
            if (building instanceof BuildingTownHall) {
                colony.getBuildingManager().setTownHall((BuildingTownHall)building);
            }
            colony.getWorkManager().addWorkOrder(new WorkOrderBuildRemoval(oldBuilding, oldBuilding.getBuildingLevel()), false);
            colony.getWorkManager().addWorkOrder(new WorkOrderBuildBuilding(building, building.getBuildingLevel()), false);
            LanguageHandler.sendPlayersMessage(colony.getMessageEntityPlayers(), "com.minecolonies.coremod.workOrderAdded", new Object[0]);
        }
    }
}

