/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizenhandlers;

import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.entity.AbstractEntityCitizen;
import com.minecolonies.coremod.entity.EntityCitizen;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CitizenSleepHandler {
    private final EntityCitizen citizen;

    public CitizenSleepHandler(EntityCitizen citizen) {
        this.citizen = citizen;
    }

    public boolean isAsleep() {
        return (Boolean)this.citizen.func_184212_Q().func_187225_a(AbstractEntityCitizen.DATA_IS_ASLEEP);
    }

    private void setIsAsleep(boolean isAsleep) {
        if (this.citizen.getCitizenData() != null) {
            this.citizen.getCitizenData().setAsleep(isAsleep);
        }
        this.citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_IS_ASLEEP, (Object)isAsleep);
    }

    @SideOnly(value=Side.CLIENT)
    public float getBedOrientationInDegrees() {
        IBlockState state;
        IBlockState iBlockState = state = this.getBedLocation() == null ? null : this.citizen.field_70170_p.func_180495_p(this.getBedLocation());
        if (state != null && state.func_177230_c().isBed(state, (IBlockAccess)this.citizen.field_70170_p, this.getBedLocation(), (Entity)this.citizen)) {
            EnumFacing enumfacing = state.func_177230_c().getBedDirection(state, (IBlockAccess)this.citizen.field_70170_p, this.getBedLocation());
            switch (enumfacing) {
                case SOUTH: {
                    return 90.0f;
                }
                case WEST: {
                    return 0.0f;
                }
                case NORTH: {
                    return 270.0f;
                }
                case EAST: {
                    return 180.0f;
                }
            }
            return 0.0f;
        }
        return 0.0f;
    }

    public void trySleep(BlockPos bedLocation) {
        boolean isBed;
        IBlockState state = this.citizen.field_70170_p.func_175667_e(bedLocation) ? this.citizen.field_70170_p.func_180495_p(bedLocation) : null;
        boolean bl = isBed = state != null && state.func_177230_c().isBed(state, (IBlockAccess)this.citizen.field_70170_p, bedLocation, (Entity)this.citizen);
        if (!isBed) {
            return;
        }
        this.citizen.func_70107_b((double)bedLocation.func_177958_n() + 0.5, bedLocation.func_177956_o(), (double)bedLocation.func_177952_p() + 0.5);
        this.citizen.field_70159_w = 0.0;
        this.citizen.field_70181_x = 0.0;
        this.citizen.field_70179_y = 0.0;
        this.citizen.getCitizenItemHandler().removeHeldItem();
        this.setIsAsleep(true);
        if (this.citizen.getCitizenData() != null) {
            this.citizen.getCitizenData().setBedPos(bedLocation);
        }
        this.citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_BED_POS, (Object)bedLocation);
    }

    public void onWakeUp() {
        AbstractBuilding homeBuilding;
        if (this.citizen.getCitizenColonyHandler().getWorkBuilding() != null) {
            this.citizen.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.working", new Object[0])});
            this.citizen.getCitizenColonyHandler().getWorkBuilding().onWakeUp();
        }
        if (this.citizen.getCitizenJobHandler().getColonyJob() != null) {
            this.citizen.getCitizenJobHandler().getColonyJob().onWakeUp();
        }
        if ((homeBuilding = this.citizen.getCitizenColonyHandler().getHomeBuilding()) != null) {
            homeBuilding.onWakeUp();
        }
        if (!this.isAsleep()) {
            return;
        }
        BlockPos spawn = !this.getBedLocation().equals((Object)BlockPos.field_177992_a) && this.citizen.field_70170_p.func_180495_p(this.getBedLocation()).func_177230_c() == Blocks.field_150324_C ? BlockBed.func_176468_a((World)this.citizen.field_70170_p, (BlockPos)this.getBedLocation(), (int)0) : this.citizen.func_180425_c();
        if (spawn != null && !spawn.equals((Object)BlockPos.field_177992_a)) {
            this.citizen.func_70107_b((double)spawn.func_177958_n() + 0.5, (double)spawn.func_177956_o() + 0.5, (double)spawn.func_177952_p() + 0.5);
        }
        this.setIsAsleep(false);
        if (this.citizen.getCitizenData() != null) {
            this.citizen.getCitizenData().setBedPos(new BlockPos(0, 0, 0));
        }
        this.citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_BED_POS, (Object)new BlockPos(0, 0, 0));
    }

    public BlockPos getBedLocation() {
        return (BlockPos)this.citizen.func_184212_Q().func_187225_a(AbstractEntityCitizen.DATA_BED_POS);
    }

    public float getRenderOffsetX() {
        EnumFacing enumfacing;
        if (!this.isAsleep()) {
            return 0.0f;
        }
        IBlockState state = this.citizen.field_70170_p.func_175667_e(this.getBedLocation()) ? this.citizen.field_70170_p.func_180495_p(this.getBedLocation()) : null;
        boolean isBed = state != null && state.func_177230_c().isBed(state, (IBlockAccess)this.citizen.field_70170_p, this.getBedLocation(), (Entity)this.citizen);
        EnumFacing enumFacing = enumfacing = isBed && state.func_177230_c() instanceof BlockHorizontal ? (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D) : null;
        if (enumfacing == null) {
            return 0.0f;
        }
        return -1.5f * (float)enumfacing.func_82601_c();
    }

    public float getRenderOffsetZ() {
        EnumFacing enumfacing;
        if (!this.isAsleep()) {
            return 0.0f;
        }
        IBlockState state = this.citizen.field_70170_p.func_175667_e(this.getBedLocation()) ? this.citizen.field_70170_p.func_180495_p(this.getBedLocation()) : null;
        boolean isBed = state != null && state.func_177230_c().isBed(state, (IBlockAccess)this.citizen.field_70170_p, this.getBedLocation(), (Entity)this.citizen);
        EnumFacing enumFacing = enumfacing = isBed && state.func_177230_c() instanceof BlockHorizontal ? (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D) : null;
        if (enumfacing == null) {
            return 0.0f;
        }
        return -1.5f * (float)enumfacing.func_82599_e();
    }
}

