/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizenhandlers;

import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.util.ServerUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import org.jetbrains.annotations.NotNull;

public class CitizenChatHandler {
    private final EntityCitizen citizen;
    @NotNull
    private final Map<String, Integer> statusMessages = new HashMap<String, Integer>();

    public CitizenChatHandler(EntityCitizen citizen) {
        this.citizen = citizen;
    }

    public void sendLocalizedChat(String key, Object ... args) {
        this.sendChat(key, args);
    }

    private void sendChat(String key, Object ... msg) {
        TextComponentTranslation requiredItem;
        if (msg == null || this.statusMessages.containsKey(key)) {
            return;
        }
        if (msg.length == 0) {
            requiredItem = new TextComponentTranslation(key, new Object[0]);
        } else {
            this.statusMessages.put(key + msg[0], this.citizen.field_70173_aa);
            requiredItem = new TextComponentTranslation(key, msg);
        }
        TextComponentString citizenDescription = new TextComponentString(" ");
        citizenDescription.func_150258_a(this.citizen.func_95999_t()).func_150258_a(": ");
        if (this.citizen.getCitizenColonyHandler().getColony() != null) {
            TextComponentString colonyDescription = new TextComponentString(" at " + this.citizen.getCitizenColonyHandler().getColony().getName() + ":");
            ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>(this.citizen.getCitizenColonyHandler().getColony().getMessageEntityPlayers());
            EntityPlayer owner = ServerUtils.getPlayerFromUUID(CompatibilityUtils.getWorld((Entity)this.citizen), this.citizen.getCitizenColonyHandler().getColony().getPermissions().getOwner());
            if (owner != null) {
                players.remove(owner);
                LanguageHandler.sendPlayerMessage(owner, this.citizen.getCitizenJobHandler().getColonyJob() == null ? "" : this.citizen.getCitizenJobHandler().getColonyJob().getName(), citizenDescription, requiredItem);
            }
            LanguageHandler.sendPlayersMessage(players, this.citizen.getCitizenJobHandler().getColonyJob() == null ? "" : this.citizen.getCitizenJobHandler().getColonyJob().getName(), colonyDescription, citizenDescription, requiredItem);
        }
    }

    public void cleanupChatMessages() {
        if (this.statusMessages.size() > 0 && this.citizen.field_70173_aa % 20 == 0) {
            this.statusMessages.entrySet().removeIf(stringIntegerEntry -> this.citizen.field_70173_aa - (Integer)stringIntegerEntry.getValue() > 20 * Configurations.gameplay.chatFrequency);
        }
    }

    public void notifyDeath(DamageSource damageSource) {
        if (this.citizen.getCitizenColonyHandler().getColony() != null && this.citizen.getCitizenData() != null) {
            AbstractJob job = this.citizen.getCitizenJobHandler().getColonyJob();
            if (job != null) {
                TextComponentTranslation component = new TextComponentTranslation("tile.blockHutTownHall.messageWorkerDead", new Object[]{new TextComponentTranslation(job.getName(), new Object[0]), this.citizen.getCitizenData().getName(), (int)this.citizen.field_70165_t, (int)this.citizen.field_70163_u, (int)this.citizen.field_70161_v, damageSource.field_76373_n});
                LanguageHandler.sendPlayersMessage(this.citizen.getCitizenColonyHandler().getColony().getMessageEntityPlayers(), (ITextComponent)component);
            } else {
                LanguageHandler.sendPlayersMessage(this.citizen.getCitizenColonyHandler().getColony().getMessageEntityPlayers(), "tile.blockHutTownHall.messageColonistDead", this.citizen.getCitizenData().getName(), (int)this.citizen.field_70165_t, (int)this.citizen.field_70163_u, (int)this.citizen.field_70161_v, damageSource.field_76373_n);
            }
        }
    }
}

