/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.mobs.util;

import com.ldtteam.structures.helpers.Structure;
import com.ldtteam.structurize.items.ItemScanTool;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.constant.ColonyConstants;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.util.InstantStructurePlacer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public final class PirateEventUtils {
    public static final String PIRATESHIP_FOLDER = "/Ships/";
    private static final int SPAWNER_DISTANCE_DIVIDER = 4;

    private PirateEventUtils() {
    }

    public static void pirateEvent(BlockPos targetSpawnPoint, World world, Colony colony, String shipSize, int raidNumber) {
        Structure structure = new Structure(world, "schematics/Ships/" + shipSize, new PlacementSettings());
        structure.rotate(BlockPosUtil.getRotationFromRotations(0), world, targetSpawnPoint, Mirror.NONE);
        if (!ItemScanTool.saveStructureOnServer((World)world, (BlockPos)targetSpawnPoint.func_177982_a(structure.getWidth() - 1, structure.getHeight(), structure.getLength() - 1).func_177973_b((Vec3i)structure.getOffset()), (BlockPos)targetSpawnPoint.func_177979_c(3).func_177973_b((Vec3i)structure.getOffset()), (String)("schematics/Ships/" + shipSize + colony.getID() + colony.getDimension() + targetSpawnPoint.func_177979_c(3)))) {
            Log.getLogger().info("Failed to save schematics for Pirate ship spawn");
            return;
        }
        colony.getRaiderManager().registerRaiderOriginSchematic("schematics/Ships/" + shipSize, targetSpawnPoint.func_177979_c(3), world.func_72820_D());
        InstantStructurePlacer.loadAndPlaceStructureWithRotation(world, "schematics/Ships/" + shipSize, targetSpawnPoint.func_177979_c(3), 0, Mirror.NONE, false);
        PirateEventUtils.loadSpawners(world, targetSpawnPoint, shipSize);
        LanguageHandler.sendPlayersMessage(colony.getMessageEntityPlayers(), "event.minecolonies.raidMessage_p" + raidNumber, colony.getName());
    }

    private static void loadSpawners(World world, BlockPos targetSpawnPoint, String shipSize) {
        switch (shipSize) {
            case "small_pirate_ship": {
                PirateEventUtils.setupSpawner(targetSpawnPoint.func_177981_b(2).func_177978_c(), world, ColonyConstants.PIRATE);
                break;
            }
            case "medium_pirate_ship": {
                PirateEventUtils.setupSpawner(targetSpawnPoint.func_177981_b(3).func_177964_d(10), world, ColonyConstants.PIRATE_CHIEF);
                PirateEventUtils.setupSpawner(targetSpawnPoint.func_177981_b(1), world, ColonyConstants.PIRATE);
                PirateEventUtils.setupSpawner(targetSpawnPoint.func_177981_b(5).func_177970_e(6), world, ColonyConstants.PIRATE_ARCHER);
                break;
            }
            case "big_pirate_ship": {
                PirateEventUtils.setupSpawner(targetSpawnPoint.func_177981_b(3).func_177968_d(), world, ColonyConstants.PIRATE);
                PirateEventUtils.setupSpawner(targetSpawnPoint.func_177981_b(3).func_177978_c(), world, ColonyConstants.PIRATE);
                PirateEventUtils.setupSpawner(targetSpawnPoint.func_177979_c(1).func_177970_e(5), world, ColonyConstants.PIRATE);
                PirateEventUtils.setupSpawner(targetSpawnPoint.func_177979_c(1).func_177964_d(5).func_177965_g(2), world, ColonyConstants.PIRATE);
                PirateEventUtils.setupSpawner(targetSpawnPoint.func_177979_c(1).func_177964_d(8), world, ColonyConstants.PIRATE);
                PirateEventUtils.setupSpawner(targetSpawnPoint.func_177981_b(2).func_177970_e(12), world, ColonyConstants.PIRATE);
                PirateEventUtils.setupSpawner(targetSpawnPoint.func_177981_b(3).func_177964_d(10), world, ColonyConstants.PIRATE_CHIEF);
                PirateEventUtils.setupSpawner(targetSpawnPoint.func_177981_b(6).func_177964_d(12), world, ColonyConstants.PIRATE_CHIEF);
                PirateEventUtils.setupSpawner(targetSpawnPoint.func_177981_b(9).func_177964_d(13), world, ColonyConstants.PIRATE_ARCHER);
                PirateEventUtils.setupSpawner(targetSpawnPoint.func_177981_b(22).func_177968_d(), world, ColonyConstants.PIRATE_ARCHER);
                PirateEventUtils.setupSpawner(targetSpawnPoint.func_177981_b(6).func_177970_e(11), world, ColonyConstants.PIRATE_ARCHER);
                break;
            }
            default: {
                Log.getLogger().warn("Invalid ship size detected!");
            }
        }
    }

    private static void setupSpawner(BlockPos location, World world, ResourceLocation mob) {
        world.func_175656_a(location, Blocks.field_150474_ac.func_176223_P());
        TileEntityMobSpawner spawner = new TileEntityMobSpawner();
        spawner.func_145881_a().field_98289_l = Configurations.gameplay.workingRangeTownHallChunks / 4 * 16;
        spawner.func_145881_a().func_190894_a(mob);
        world.func_175690_a(location, (TileEntity)spawner);
    }
}

