/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.mobs;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.Log;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.entity.ai.mobs.EntityMercenary;
import com.minecolonies.coremod.entity.ai.statemachine.states.IAIState;
import com.minecolonies.coremod.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.coremod.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.coremod.entity.pathfinding.PathResult;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;

public class EntityMercenaryAI
extends EntityAIBase {
    private static final int MAX_BLOCK_CHASE_DISTANCE = 50;
    private static final int MAX_STUCK_TIME = 10;
    private final TickRateStateMachine stateMachine;
    private final EntityMercenary entity;
    private final List<BlockPos> patrolPoints;
    private BlockPos currentPatrolPos;
    private boolean movingToBuilding = false;
    private BlockPos lastWorkerPos;
    private PathResult attackPath;
    private int attacktimer = 0;
    private static final int ATTACK_DELAY = 5;
    private static final int MELEE_ATTACK_DIST = 2;
    private int stuckTimer = 0;
    private final Random rand = new Random();

    public EntityMercenaryAI(EntityMercenary entityMercenary) {
        this.entity = entityMercenary;
        this.patrolPoints = new LinkedList<BlockPos>();
        this.stateMachine = new TickRateStateMachine(State.INIT, this::handleAIException);
        this.stateMachine.addTransition(new TickingTransition(State.INIT, this::initialize, () -> State.PATROLLING, 10));
        this.stateMachine.addTransition(new TickingTransition(State.PATROLLING, this::hasTarget, () -> State.FIGHTING, 5));
        this.stateMachine.addTransition(new TickingTransition(State.PATROLLING, this::patrol, () -> State.PATROLLING, 10));
        this.stateMachine.addTransition(new TickingTransition(State.FIGHTING, this::fighting, () -> State.PATROLLING, 5));
    }

    private boolean initialize() {
        if (this.entity.getColony() == null) {
            return false;
        }
        this.patrolPoints.addAll(this.entity.getColony().getBuildingManager().getBuildings().keySet());
        return true;
    }

    private boolean hasTarget() {
        if (this.entity.func_70638_az() != null && !this.entity.func_70638_az().field_70128_L) {
            this.entity.func_70638_az().func_70604_c((EntityLivingBase)this.entity);
            return true;
        }
        return false;
    }

    private boolean patrol() {
        if (this.currentPatrolPos == null || this.entity.getProxy().walkToBlock(this.currentPatrolPos, 3, true)) {
            ArrayList<IItemHandler> handlers;
            IItemHandler handler;
            ItemStack stack;
            AbstractBuilding building;
            if (this.currentPatrolPos != null && this.movingToBuilding && (building = this.entity.getColony().getBuildingManager().getBuilding(this.currentPatrolPos)) != null && !ItemStackUtils.isEmpty(stack = (handler = (IItemHandler)(handlers = new ArrayList<IItemHandler>(InventoryUtils.getItemHandlersFromProvider((ICapabilityProvider)building.getTileEntity()))).get(this.rand.nextInt(handlers.size()))).extractItem(this.rand.nextInt(handler.getSlots()), 5, false)).booleanValue()) {
                this.entity.func_184609_a(EnumHand.OFF_HAND);
                LanguageHandler.sendPlayersMessage(this.entity.getColony().getMessageEntityPlayers(), "com.minecolonies.coremod.mercenary.stealBuilding", stack.func_82833_r());
            }
            if (this.rand.nextInt(4) == 0) {
                this.movingToBuilding = true;
                this.currentPatrolPos = this.patrolPoints.get(this.rand.nextInt(this.patrolPoints.size()));
            } else {
                this.movingToBuilding = false;
                this.currentPatrolPos = BlockPosUtil.getRandomPosition(this.entity.func_130014_f_(), this.entity.func_180425_c(), this.entity.func_180425_c());
            }
        }
        this.stuckTimer = this.entity.func_180425_c().equals((Object)this.lastWorkerPos) ? ++this.stuckTimer : 0;
        if (this.stuckTimer > 10) {
            this.stuckTimer = 0;
            this.currentPatrolPos = null;
            this.entity.getNavigator().func_75499_g();
        }
        this.lastWorkerPos = this.entity.func_180425_c();
        return true;
    }

    private boolean fighting() {
        int distance;
        if (this.entity.func_70638_az() == null || this.entity.func_70638_az().field_70128_L) {
            this.entity.getNavigator().func_75499_g();
            this.attackPath = null;
            return true;
        }
        if (this.attacktimer > 0) {
            --this.attacktimer;
        }
        if (this.attackPath == null || !this.attackPath.isInProgress()) {
            this.entity.getNavigator().moveToEntityLiving((Entity)this.entity.func_70638_az(), 1.0);
            this.entity.func_70671_ap().func_75651_a((Entity)this.entity.func_70638_az(), 180.0f, 180.0f);
        }
        if ((distance = BlockPosUtil.getMaxDistance2D(this.entity.func_180425_c(), this.entity.func_70638_az().func_180425_c())) < 2 && this.attacktimer == 0) {
            this.entity.func_184609_a(EnumHand.MAIN_HAND);
            this.entity.func_184185_a(SoundEvents.field_187730_dW, 0.55f, 1.0f);
            this.entity.func_70638_az().func_70097_a((DamageSource)new EntityDamageSource(this.entity.func_70005_c_(), (Entity)this.entity), 15.0f);
            this.entity.func_70638_az().func_70015_d(3);
            this.attacktimer = 5;
        } else if (distance > 50) {
            this.entity.func_70624_b(null);
            this.entity.getNavigator().func_75499_g();
            this.attackPath = null;
            return true;
        }
        return false;
    }

    private void handleAIException(RuntimeException e) {
        Log.getLogger().error("MercenaryAI threw an exception:", (Throwable)e);
    }

    public boolean func_75250_a() {
        return this.entity != null && !this.entity.field_70128_L && !this.entity.func_82150_aj() && this.entity.getColony() != null && this.entity.getState() == State.ALIVE;
    }

    public boolean func_75253_b() {
        this.stateMachine.tick();
        return this.entity != null && !this.entity.field_70128_L && !this.entity.func_82150_aj() && this.entity.getColony() != null && this.entity.getState() == State.ALIVE;
    }

    public static enum State implements IAIState
    {
        INIT,
        SPAWN_EVENT,
        PATROLLING,
        FIGHTING,
        ALIVE,
        DEAD;


        @Override
        public boolean isOkayToEat() {
            return false;
        }
    }
}

