/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.entity.ai.Status;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.entity.EntityCitizen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class EntityAIMournCitizen
extends EntityAIBase {
    private final EntityCitizen citizen;
    private final double speed;
    private double xPosition = 0.0;
    private double yPosition = 0.0;
    private double zPosition = 0.0;
    private boolean reachedFinalDestination = false;
    private boolean goingToMourn = false;
    private static final int maxDistanceForPlayer = 1;
    private Entity closestEntity;
    private int mourningTime;
    private boolean continueLooking = false;
    private Vec3d homeLocation;
    private static final int MIN_DESTINATION_TO_LOCATION = 15;
    private static final int MIN_MOURN_TIME = 2000;
    private static final int MIN_MOURN_RANDOM_TIME = 1000;

    public EntityAIMournCitizen(EntityCitizen citizen, double speed) {
        this.citizen = citizen;
        this.speed = speed;
        this.func_75248_a(1);
        this.mourningTime = citizen.func_70681_au().nextInt(1000) + 2000;
    }

    public boolean func_75250_a() {
        if (this.citizen.getDesiredActivity() != DesiredActivity.MOURN) {
            return false;
        }
        if (this.citizen.getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard || this.reachedFinalDestination && this.checkForRandom()) {
            this.closestEntity = this.citizen.field_70170_p.func_72857_a(EntityCitizen.class, this.citizen.func_174813_aQ().func_72314_b(1.0, 3.0, 1.0), (Entity)this.citizen);
            if (this.closestEntity == null) {
                this.continueLooking = false;
            }
            return false;
        }
        this.citizen.getCitizenStatusHandler().setStatus(Status.MOURN);
        return true;
    }

    private boolean checkForRandom() {
        return this.citizen.func_70681_au().nextInt(100) != 0;
    }

    public boolean func_75253_b() {
        return !this.citizen.getNavigator().func_75500_f() || this.citizen.getDesiredActivity() == DesiredActivity.MOURN;
    }

    public void func_75249_e() {
        this.citizen.getCitizenItemHandler().removeHeldItem();
        this.citizen.getNavigator().func_75492_a(this.xPosition, this.yPosition, this.zPosition, this.speed);
    }

    protected Vec3d getMournLocation() {
        Vec3d vec3d = null;
        Colony colony = this.citizen.getCitizenColonyHandler().getColony();
        if (colony == null || !colony.getBuildingManager().hasTownHall()) {
            return new Vec3d((Vec3i)this.citizen.func_180486_cf());
        }
        BlockPos pos = colony.getBuildingManager().getTownHall().getLocation();
        if (pos != null) {
            vec3d = new Vec3d((Vec3i)pos);
        }
        return vec3d;
    }

    public void func_75251_c() {
        if (this.citizen.getDesiredActivity() != DesiredActivity.MOURN || !this.citizen.isMourning()) {
            this.reachedFinalDestination = false;
            this.goingToMourn = false;
            this.continueLooking = false;
            this.mourningTime = this.citizen.func_70681_au().nextInt(1000) + 2000;
            this.xPosition = 0.0;
            this.yPosition = 0.0;
            this.zPosition = 0.0;
        }
        super.func_75251_c();
    }

    public void func_75246_d() {
        if (this.mourningTime > 0) {
            --this.mourningTime;
        }
        if (this.goingToMourn || this.closestEntity == null || this.closestEntity != null && this.citizen.func_70068_e(this.closestEntity) > 1.0) {
            this.continueLooking = false;
        } else if (this.closestEntity != null) {
            this.continueLooking = true;
        }
        if (this.goingToMourn && this.citizen.func_70011_f(this.homeLocation.field_72450_a, this.homeLocation.field_72448_b, this.homeLocation.field_72449_c) < 15.0) {
            this.reachedFinalDestination = true;
            this.goingToMourn = false;
        }
        if (this.mourningTime <= 0) {
            this.citizen.setMourning(false);
        }
        Vec3d vec3d = null;
        if (!this.reachedFinalDestination) {
            this.goingToMourn = true;
            if (this.homeLocation == null) {
                this.homeLocation = vec3d = this.getMournLocation();
            } else {
                vec3d = this.homeLocation;
            }
        } else if (this.citizen.func_70011_f(this.homeLocation.field_72450_a, this.homeLocation.field_72448_b, this.homeLocation.field_72449_c) < 15.0) {
            vec3d = RandomPositionGenerator.func_191377_b((EntityCreature)this.citizen, (int)10, (int)10);
            if (vec3d != null) {
                vec3d = new Vec3d(vec3d.field_72450_a, BlockPosUtil.getValidHeight(vec3d, CompatibilityUtils.getWorld((Entity)this.citizen)), vec3d.field_72449_c);
            }
        } else {
            vec3d = this.getMournLocation();
            this.reachedFinalDestination = false;
            this.goingToMourn = true;
            this.continueLooking = false;
        }
        if (vec3d != null) {
            this.xPosition = vec3d.field_72450_a;
            this.yPosition = vec3d.field_72448_b;
            this.zPosition = vec3d.field_72449_c;
        }
        if (this.continueLooking && this.closestEntity != null) {
            this.citizen.func_70671_ap().func_75650_a(this.closestEntity.field_70165_t, this.closestEntity.field_70163_u + (double)this.closestEntity.func_70047_e(), this.closestEntity.field_70161_v, (float)this.citizen.func_184649_cE(), (float)this.citizen.func_70646_bf());
        } else {
            this.citizen.func_70671_ap().func_75650_a(this.citizen.field_70165_t, this.citizen.field_70163_u - 10.0, this.citizen.field_70161_v, (float)this.citizen.func_184649_cE(), (float)this.citizen.func_70646_bf());
        }
        super.func_75246_d();
    }
}

