/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.herders;

import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.AbstractSchematicProvider;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.coremod.entity.ai.statemachine.AITarget;
import com.minecolonies.coremod.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.coremod.entity.ai.statemachine.states.IAIState;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityAIHerder<J extends AbstractJob, T extends EntityAnimal>
extends AbstractEntityAIInteract<J> {
    private static final int ANIMAL_MULTIPLIER = 2;
    private static final int NUM_OF_ANIMALS_TO_BREED = 2;
    private static final int BUTCHERING_ATTACK_DAMAGE = 5;
    private static final int DISTANCE_TO_BREED = 10;
    private static final int BUTCHER_DELAY = 20;
    private static final int DECIDING_DELAY = 40;
    private static final int BREEDING_DELAY = 40;
    private static final int NO_ANIMALS_DELAY = 100;
    private static final int ACTIONS_FOR_DUMP = 10;
    private AxisAlignedBB targetArea = null;

    public AbstractEntityAIHerder(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING), new AITarget((IAIState)AIWorkerState.START_WORKING, this::startWorkingAtOwnBuilding), new AITarget((IAIState)AIWorkerState.PREPARING, this::prepareForHerding), new AITarget((IAIState)AIWorkerState.DECIDE, this::decideWhatToDo), new AITarget((IAIState)AIWorkerState.HERDER_BREED, this::breedAnimals), new AITarget((IAIState)AIWorkerState.HERDER_BUTCHER, this::butcherAnimals), new AITarget((IAIState)AIWorkerState.HERDER_PICKUP, this::pickupItems));
        this.worker.func_98053_h(true);
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 10;
    }

    @Override
    @NotNull
    protected List<ItemStack> itemsNiceToHave() {
        List<ItemStack> list = super.itemsNiceToHave();
        list.add(this.getRequestBreedingItems());
        return list;
    }

    @NotNull
    public List<ToolType> getExtraToolsNeeded() {
        ArrayList<ToolType> toolsNeeded = new ArrayList<ToolType>();
        toolsNeeded.add(ToolType.AXE);
        return toolsNeeded;
    }

    @NotNull
    public List<ItemStack> getExtraItemsNeeded() {
        ArrayList<ItemStack> itemsNeeded = new ArrayList<ItemStack>();
        itemsNeeded.add(this.getRequestBreedingItems());
        return itemsNeeded;
    }

    public IAIState decideWhatToDo() {
        this.setDelay(40);
        ArrayList<T> animals = new ArrayList<T>(this.searchForAnimals());
        if (animals.isEmpty()) {
            this.setDelay(100);
            return AIWorkerState.DECIDE;
        }
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.deciding", new Object[0])});
        int numOfBreedableAnimals = (int)animals.stream().filter(animal -> animal.func_70874_b() == 0).count();
        boolean hasBreedingItem = InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.getBreedingItem()));
        if (!this.searchForItemsInArea().isEmpty()) {
            return AIWorkerState.HERDER_PICKUP;
        }
        if (this.maxAnimals(animals)) {
            return AIWorkerState.HERDER_BUTCHER;
        }
        if (numOfBreedableAnimals >= 2 && hasBreedingItem) {
            return AIWorkerState.HERDER_BREED;
        }
        return AIWorkerState.START_WORKING;
    }

    private IAIState startWorkingAtOwnBuilding() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.worker.goingToHut", new Object[0])});
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIWorkerState.PREPARING;
    }

    private IAIState prepareForHerding() {
        this.setDelay(40);
        for (ToolType tool : this.getExtraToolsNeeded()) {
            if (!this.checkForToolOrWeapon(tool)) continue;
            return this.getState();
        }
        for (ItemStack item : this.getExtraItemsNeeded()) {
            this.checkIfRequestForItemExistOrCreateAsynch(item);
        }
        return AIWorkerState.DECIDE;
    }

    private IAIState butcherAnimals() {
        this.setDelay(20);
        ArrayList<T> animals = new ArrayList<T>(this.searchForAnimals());
        if (!this.maxAnimals(animals)) {
            return AIWorkerState.DECIDE;
        }
        if (!this.equipTool(EnumHand.MAIN_HAND, ToolType.AXE)) {
            return AIWorkerState.START_WORKING;
        }
        EntityAnimal animal = animals.stream().filter(animalToButcher -> !animalToButcher.func_70631_g_()).findFirst().orElse(null);
        if (animal == null) {
            return AIWorkerState.DECIDE;
        }
        this.butcherAnimal(animal);
        if (!animal.func_70089_S()) {
            this.worker.getCitizenExperienceHandler().addExperience(1.0);
            this.worker.decreaseSaturationForAction();
        }
        return AIWorkerState.HERDER_BUTCHER;
    }

    private IAIState breedAnimals() {
        this.setDelay(40);
        List<T> animals = this.searchForAnimals();
        EntityAnimal animalOne = animals.stream().filter(animal -> !animal.func_70631_g_()).findAny().orElse(null);
        if (animalOne == null) {
            return AIWorkerState.DECIDE;
        }
        EntityAnimal animalTwo = animals.stream().filter(animal -> {
            float range = animal.func_70032_d((Entity)animalOne);
            boolean isAnimalOne = animalOne.equals(animal);
            return animal.func_70874_b() == 0 && range <= 10.0f && !isAnimalOne;
        }).findAny().orElse(null);
        if (animalTwo == null) {
            return AIWorkerState.DECIDE;
        }
        if (!this.equipItem(EnumHand.MAIN_HAND, this.getBreedingItem())) {
            return AIWorkerState.START_WORKING;
        }
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.herder.breeding", new Object[0])});
        this.breedTwoAnimals(animalOne, animalTwo);
        this.incrementActionsDoneAndDecSaturation();
        this.worker.getCitizenExperienceHandler().addExperience(1.0);
        return AIWorkerState.DECIDE;
    }

    private IAIState pickupItems() {
        ArrayList<EntityItem> items = new ArrayList<EntityItem>(this.searchForItemsInArea());
        for (EntityItem item : items) {
            this.walkToBlock(item.func_180425_c());
        }
        this.incrementActionsDoneAndDecSaturation();
        return AIWorkerState.DECIDE;
    }

    public List<T> searchForAnimals() {
        if (this.getTargetableArea() != null) {
            return new ArrayList(this.world.func_72872_a(this.getAnimalClass(), this.getTargetableArea()));
        }
        return new ArrayList();
    }

    public int getMaxAnimalMultiplier() {
        return 2;
    }

    public List<EntityItem> searchForItemsInArea() {
        if (this.getTargetableArea() != null) {
            return new ArrayList<EntityItem>(this.world.func_72872_a(EntityItem.class, this.getTargetableArea()));
        }
        return new ArrayList<EntityItem>();
    }

    public abstract Class<T> getAnimalClass();

    private AxisAlignedBB getTargetableArea() {
        if (this.getOwnBuilding() == null) {
            return null;
        }
        if (this.targetArea == null) {
            this.targetArea = ((AbstractSchematicProvider)this.getOwnBuilding()).getTargetableArea(this.world);
        }
        return this.targetArea;
    }

    public boolean walkingToAnimal(EntityAnimal animal) {
        if (animal != null) {
            this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.herder.goingToAnimal", new Object[0])});
            return this.walkToBlock(animal.func_180425_c());
        }
        return false;
    }

    private void breedTwoAnimals(EntityAnimal animalOne, EntityAnimal animalTwo) {
        ArrayList<EntityAnimal> animalsToBreed = new ArrayList<EntityAnimal>();
        animalsToBreed.add(animalOne);
        animalsToBreed.add(animalTwo);
        for (EntityAnimal animal : animalsToBreed) {
            if (animal.func_70880_s() || this.walkingToAnimal(animal)) continue;
            animal.func_146082_f(null);
            this.worker.func_184609_a(EnumHand.MAIN_HAND);
            InventoryUtils.reduceStackInItemHandler(new InvWrapper((IInventory)this.worker.getInventoryCitizen()), this.getBreedingItem());
            this.worker.decreaseSaturationForAction();
        }
    }

    public boolean maxAnimals(List<T> allAnimals) {
        if (this.getOwnBuilding() != null) {
            int maxAnimals;
            List animals = allAnimals.stream().filter(animalToButcher -> !animalToButcher.func_70631_g_()).collect(Collectors.toList());
            if (animals.isEmpty()) {
                return false;
            }
            int numOfAnimals = allAnimals.size();
            return numOfAnimals > (maxAnimals = ((AbstractSchematicProvider)this.getOwnBuilding()).getBuildingLevel() * this.getMaxAnimalMultiplier());
        }
        return true;
    }

    public boolean equipTool(EnumHand hand, ToolType toolType) {
        if (this.getToolSlot(toolType) != -1) {
            this.worker.getCitizenItemHandler().setHeldItem(hand, this.getToolSlot(toolType));
            return true;
        }
        return false;
    }

    private int getToolSlot(ToolType toolType) {
        if (this.getOwnBuilding() != null) {
            int slot = InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)new InvWrapper((IInventory)this.getInventory()), toolType, 0, ((AbstractBuildingWorker)this.getOwnBuilding()).getMaxToolLevel());
            if (slot == -1) {
                this.checkForToolOrWeapon(toolType);
            }
            return slot;
        }
        return -1;
    }

    public boolean equipItem(EnumHand hand, ItemStack itemStack) {
        if (this.checkIfRequestForItemExistOrCreateAsynch(itemStack)) {
            this.worker.getCitizenItemHandler().setHeldItem(hand, this.getItemSlot(itemStack.func_77973_b()));
            return true;
        }
        return false;
    }

    public int getItemSlot(Item item) {
        return InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)this.getInventory()), item, 0);
    }

    private void butcherAnimal(@Nullable EntityAnimal animal) {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.herder.butchering", new Object[0])});
        if (animal != null && !this.walkingToAnimal(animal) && !ItemStackUtils.isEmpty(this.worker.func_184614_ca()).booleanValue()) {
            this.worker.func_184609_a(EnumHand.MAIN_HAND);
            animal.func_70097_a((DamageSource)new EntityDamageSource(this.worker.func_70005_c_(), (Entity)this.worker), 5.0f);
            this.worker.func_184614_ca().func_77972_a(1, (EntityLivingBase)animal);
            this.worker.decreaseSaturationForAction();
        }
    }

    public ItemStack getRequestBreedingItems() {
        ItemStack breedingItem = this.getBreedingItem().func_77946_l();
        ItemStackUtils.setSize(breedingItem, breedingItem.func_190916_E() * 8);
        return breedingItem;
    }

    public abstract ItemStack getBreedingItem();
}

