/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.deliveryman;

import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.Delivery;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.InventoryFunctions;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.blockout.Log;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingContainer;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.AbstractCitizenAssignable;
import com.minecolonies.coremod.colony.buildings.AbstractSchematicProvider;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCook;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingDeliveryman;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingWareHouse;
import com.minecolonies.coremod.colony.jobs.JobDeliveryman;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.coremod.entity.ai.statemachine.AIEventTarget;
import com.minecolonies.coremod.entity.ai.statemachine.AITarget;
import com.minecolonies.coremod.entity.ai.statemachine.states.AIBlockingEventType;
import com.minecolonies.coremod.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.coremod.entity.ai.statemachine.states.IAIState;
import com.minecolonies.coremod.tileentities.TileEntityColonyBuilding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkDeliveryman
extends AbstractEntityAIInteract<JobDeliveryman> {
    private static final int MIN_DISTANCE_TO_WAREHOUSE = 5;
    private static final double BONUS_SPEED_PER_LEVEL = 0.003;
    private static final int DUMP_AND_GATHER_DELAY = 3;
    private static final int WAIT_DELAY = 200;
    private static final int SLOT_HAND = 0;
    private static final int TRIES_TO_GET_RANDOM_BUILDING = 3;
    private BlockPos gatherTarget = null;
    private int gatherCount = 0;
    private int maximalGatherCount = -1;
    private int currentSlot = 0;
    private List<ItemStorage> alreadyKept = new ArrayList<ItemStorage>();
    private boolean hasGathered = false;
    private ILocation lastDelivery = null;

    public EntityAIWorkDeliveryman(@NotNull JobDeliveryman deliveryman) {
        super(deliveryman);
        super.registerTargets(new AIEventTarget(AIBlockingEventType.STATE_BLOCKING, this::checkIfExecute, AIWorkerState.IDLE), new AITarget((IAIState)AIWorkerState.IDLE, () -> AIWorkerState.START_WORKING), new AITarget((IAIState)AIWorkerState.START_WORKING, this::checkWareHouse), new AITarget((IAIState)AIWorkerState.PREPARE_DELIVERY, this::prepareDelivery), new AITarget((IAIState)AIWorkerState.DELIVERY, this::deliver), new AITarget((IAIState)AIWorkerState.GATHERING, this::gather), new AITarget((IAIState)AIWorkerState.DUMPING, this::dump));
        this.worker.getCitizenExperienceHandler().setSkillModifier(2 * this.worker.getCitizenData().getEndurance() + this.worker.getCitizenData().getCharisma());
        this.worker.func_98053_h(true);
    }

    @Override
    public Class getExpectedBuildingClass() {
        return BuildingDeliveryman.class;
    }

    public IAIState gather() {
        if (((JobDeliveryman)this.job).getCurrentTask() != null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.maximalGatherCount < 0) {
            this.maximalGatherCount = Configurations.requestSystem.minimalBuildingsToGather + this.worker.getRandom().nextInt(Math.max(1, Configurations.requestSystem.maximalBuildingsToGather - Configurations.requestSystem.minimalBuildingsToGather));
        }
        if (this.gatherTarget == null) {
            if (this.gatherCount == this.maximalGatherCount) {
                this.maximalGatherCount = Configurations.requestSystem.minimalBuildingsToGather + this.worker.getRandom().nextInt(Math.max(1, Configurations.requestSystem.maximalBuildingsToGather - Configurations.requestSystem.minimalBuildingsToGather));
                this.gatherCount = 0;
                return AIWorkerState.DUMPING;
            }
            this.gatherTarget = this.getRandomBuilding();
        }
        if (this.gatherTarget == null) {
            return AIWorkerState.START_WORKING;
        }
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.gathering", new Object[0])});
        if (!this.worker.isWorkerAtSiteWithMove(this.gatherTarget, 5)) {
            return AIWorkerState.GATHERING;
        }
        Colony colony = ((AbstractCitizenAssignable)this.getOwnBuilding()).getColony();
        if (colony != null) {
            AbstractBuilding building = colony.getBuildingManager().getBuilding(this.gatherTarget);
            if (building == null) {
                this.gatherTarget = null;
                return AIWorkerState.START_WORKING;
            }
            if (this.gatherFromBuilding(building) || this.cannotHoldMoreItems()) {
                this.alreadyKept = new ArrayList<ItemStorage>();
                this.currentSlot = 0;
                building.setBeingGathered(false);
                ++this.gatherCount;
                if (this.hasGathered) {
                    ((JobDeliveryman)this.job).setReturning(true);
                    this.hasGathered = false;
                } else {
                    if (!building.isPriorityStatic()) {
                        building.alterPickUpPriority(-10);
                    }
                    if (((JobDeliveryman)this.job).getCurrentTask() == null) {
                        this.gatherTarget = null;
                        return AIWorkerState.GATHERING;
                    }
                }
                this.gatherCount = 0;
                return AIWorkerState.DUMPING;
            }
            ++this.currentSlot;
            return AIWorkerState.GATHERING;
        }
        return AIWorkerState.START_WORKING;
    }

    @Nullable
    private BlockPos getRandomBuilding() {
        if (this.worker.getCitizenColonyHandler().getColony() == null || this.getOwnBuilding() == null) {
            return null;
        }
        BlockPos pos = this.getWeightedRandom();
        if (pos != null) {
            return pos;
        }
        AbstractBuilding theBuilding = this.returnRandomBuilding();
        for (int i = 0; i < 3; ++i) {
            if (!(theBuilding == null || this.lastDelivery != null && theBuilding.getDeliveryLocation().equals(this.lastDelivery))) {
                this.lastDelivery = null;
                return theBuilding.getLocation();
            }
            theBuilding = this.returnRandomBuilding();
        }
        this.lastDelivery = null;
        return theBuilding == null ? null : theBuilding.getLocation();
    }

    private AbstractBuilding returnRandomBuilding() {
        int random;
        Collection<AbstractBuilding> buildingList = this.worker.getCitizenColonyHandler().getColony().getBuildingManager().getBuildings().values();
        Object[] buildingArray = buildingList.toArray();
        AbstractBuilding building = (AbstractBuilding)buildingArray[random = this.worker.getRandom().nextInt(buildingArray.length)];
        if (!building.canBeGathered()) {
            return null;
        }
        return building;
    }

    private boolean gatherFromBuilding(@NotNull AbstractBuilding building) {
        IItemHandler handler = (IItemHandler)building.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (handler == null) {
            return false;
        }
        if (this.currentSlot >= handler.getSlots()) {
            return true;
        }
        ItemStack stack = handler.getStackInSlot(this.currentSlot);
        if (stack.func_190926_b()) {
            return false;
        }
        int amount = EntityAIWorkDeliveryman.workerRequiresItem(building, stack, this.alreadyKept);
        if (amount <= 0 || building instanceof BuildingCook && stack.func_77973_b() instanceof ItemFood) {
            return false;
        }
        if (ItemStackUtils.isEmpty(handler.getStackInSlot(this.currentSlot)).booleanValue()) {
            return false;
        }
        this.hasGathered = true;
        ItemStack activeStack = handler.extractItem(this.currentSlot, amount, false);
        InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler(activeStack, (IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()));
        building.markDirty();
        this.setDelay(3);
        this.worker.decreaseSaturationForContinuousAction();
        this.worker.getCitizenItemHandler().setHeldItem(EnumHand.MAIN_HAND, 0);
        return false;
    }

    private boolean cannotHoldMoreItems() {
        if (((AbstractSchematicProvider)this.getOwnBuilding()).getBuildingLevel() >= ((AbstractSchematicProvider)this.getOwnBuilding()).getMaxBuildingLevel()) {
            return false;
        }
        return (double)InventoryUtils.getAmountOfStacksInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen())) >= Math.pow(2.0, (double)((AbstractSchematicProvider)this.getOwnBuilding()).getBuildingLevel() - 1.0) + 1.0;
    }

    private BlockPos getWeightedRandom() {
        double completeWeight = 0.0;
        for (AbstractBuilding building2 : this.worker.getCitizenColonyHandler().getColony().getBuildingManager().getBuildings().values()) {
            if (building2.isBeingGathered()) continue;
            completeWeight += (double)building2.getPickUpPriority();
        }
        double r = Math.random() * completeWeight;
        double countWeight = 0.0;
        List buildings = this.worker.getCitizenColonyHandler().getColony().getBuildingManager().getBuildings().values().stream().filter(building -> building.canBeGathered() && !building.isBeingGathered()).collect(Collectors.toList());
        Collections.shuffle(buildings);
        for (AbstractBuilding building3 : buildings) {
            if ((countWeight += (double)building3.getPickUpPriority()) >= r) {
                building3.setBeingGathered(true);
                return building3.getID();
            }
            if (building3.isPriorityStatic() || this.worker.getRandom().nextInt(100) > 1) continue;
            building3.alterPickUpPriority(1);
        }
        return null;
    }

    public static int workerRequiresItem(AbstractBuilding building, ItemStack stack, List<ItemStorage> localAlreadyKept) {
        return building.buildingRequiresCertainAmountOfItem(stack, localAlreadyKept, false);
    }

    public IAIState dump() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.dumping", new Object[0])});
        if (!this.worker.isWorkerAtSiteWithMove(this.getWareHouse().getLocation(), 5)) {
            return AIWorkerState.DUMPING;
        }
        this.getWareHouse().getTileEntity().dumpInventoryIntoWareHouse(this.worker.getInventoryCitizen());
        this.gatherTarget = null;
        this.worker.getCitizenItemHandler().setHeldItem(EnumHand.MAIN_HAND, 0);
        if (((JobDeliveryman)this.job).isReturning()) {
            ((JobDeliveryman)this.job).setReturning(false);
        }
        return AIWorkerState.START_WORKING;
    }

    public BuildingWareHouse getWareHouse() {
        Map<BlockPos, AbstractBuilding> buildings = ((JobDeliveryman)this.job).getColony().getBuildingManager().getBuildings();
        for (AbstractBuilding building : buildings.values()) {
            if (building == null) continue;
            Colony buildingColony = building.getColony();
            Colony ownColony = this.worker.getCitizenColonyHandler().getColony();
            if (!(building instanceof BuildingWareHouse) || ownColony == null || buildingColony == null || buildingColony.getID() != ownColony.getID() || !((BuildingWareHouse)building).registerWithWareHouse((BuildingDeliveryman)this.getOwnBuilding())) continue;
            return (BuildingWareHouse)building;
        }
        return null;
    }

    private IAIState deliver() {
        ILocation buildingToDeliver;
        if (((JobDeliveryman)this.job).isReturning()) {
            return AIWorkerState.DUMPING;
        }
        BuildingDeliveryman deliveryHut = this.getOwnBuilding() instanceof BuildingDeliveryman ? (BuildingDeliveryman)this.getOwnBuilding() : null;
        ILocation iLocation = buildingToDeliver = deliveryHut == null ? null : deliveryHut.getBuildingToDeliver();
        if (deliveryHut == null) {
            return AIWorkerState.START_WORKING;
        }
        if (buildingToDeliver == null) {
            if (((JobDeliveryman)this.job).getCurrentTask() != null && deliveryHut != null) {
                IRequest<Delivery> request = ((JobDeliveryman)this.job).getCurrentTask();
                deliveryHut.setBuildingToDeliver(request.getRequest().getTarget());
                return this.getState();
            }
            return AIWorkerState.START_WORKING;
        }
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.delivering", new Object[0])});
        if (!buildingToDeliver.isReachableFromLocation(this.worker.getLocation())) {
            Log.getLogger().info(this.worker.getCitizenColonyHandler().getColony().getName() + ": " + this.worker.func_70005_c_() + ": Can't inter dimension yet: ");
            return AIWorkerState.START_WORKING;
        }
        if (!this.worker.isWorkerAtSiteWithMove(buildingToDeliver.getInDimensionLocation(), 5)) {
            return AIWorkerState.DELIVERY;
        }
        TileEntity tileEntity = this.world.func_175625_s(buildingToDeliver.getInDimensionLocation());
        if (!(tileEntity instanceof TileEntityColonyBuilding)) {
            ((JobDeliveryman)this.job).finishRequest(true);
            return AIWorkerState.START_WORKING;
        }
        TileEntityColonyBuilding tileEntityColonyBuilding = (TileEntityColonyBuilding)tileEntity;
        AbstractBuildingContainer building = tileEntityColonyBuilding.getBuilding();
        boolean success = true;
        InvWrapper workerInventory = new InvWrapper((IInventory)this.worker.getInventoryCitizen());
        for (int i = 0; i < new InvWrapper((IInventory)this.worker.getInventoryCitizen()).getSlots(); ++i) {
            ItemStack stack = workerInventory.extractItem(i, Integer.MAX_VALUE, false);
            if (ItemStackUtils.isEmpty(stack).booleanValue()) continue;
            ItemStack insertionResultStack = tileEntityColonyBuilding.getBuilding() instanceof AbstractBuildingWorker ? InventoryUtils.forceItemStackToItemHandler((IItemHandler)tileEntityColonyBuilding.getBuilding().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), stack, ((AbstractBuildingWorker)building)::isItemStackInRequest) : InventoryUtils.forceItemStackToItemHandler((IItemHandler)tileEntityColonyBuilding.getBuilding().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), stack, itemStack -> false);
            if (ItemStackUtils.isEmpty(insertionResultStack).booleanValue()) continue;
            success = false;
            if (ItemStack.func_77989_b((ItemStack)insertionResultStack, (ItemStack)stack)) {
                if (building instanceof AbstractBuildingWorker) {
                    this.chatSpamFilter.talkWithoutSpam("com.minecolonies.coremod.job.deliveryman.namedWorkerChestFull", building.getMainCitizen().getName());
                } else if (buildingToDeliver instanceof TileEntityColonyBuilding) {
                    this.chatSpamFilter.talkWithoutSpam("com.minecolonies.coremod.job.deliveryman.workerChestFull", new TextComponentString(" :" + building.getSchematicName()));
                }
            }
            workerInventory.insertItem(i, insertionResultStack, false);
        }
        this.lastDelivery = deliveryHut.getBuildingToDeliver();
        this.worker.getCitizenExperienceHandler().addExperience(1.0);
        this.worker.decreaseSaturationForContinuousAction();
        this.worker.getCitizenItemHandler().setHeldItem(EnumHand.MAIN_HAND, 0);
        deliveryHut.setBuildingToDeliver(null);
        ((JobDeliveryman)this.job).finishRequest(true);
        this.setDelay(200);
        return success ? AIWorkerState.START_WORKING : AIWorkerState.DUMPING;
    }

    private IAIState prepareDelivery() {
        IRequest<Delivery> request;
        Object ownBuilding = this.getOwnBuilding();
        if (ownBuilding instanceof BuildingDeliveryman && (request = ((JobDeliveryman)this.job).getCurrentTask()) != null) {
            if (((JobDeliveryman)this.job).isReturning()) {
                return AIWorkerState.DUMPING;
            }
            ((BuildingDeliveryman)ownBuilding).setBuildingToDeliver(request.getRequest().getTarget());
            if (InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), itemStack -> ((Delivery)request.getRequest()).getStack().func_185136_b(itemStack))) {
                return AIWorkerState.DELIVERY;
            }
            return this.gatherItems(request);
        }
        return AIWorkerState.START_WORKING;
    }

    private IAIState gatherItems(@NotNull IRequest<? extends Delivery> request) {
        ILocation location = request.getRequest().getStart();
        if (!location.isReachableFromLocation(this.worker.getLocation())) {
            ((BuildingDeliveryman)this.getOwnBuilding()).setBuildingToDeliver(null);
            ((JobDeliveryman)this.job).finishRequest(false);
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(location.getInDimensionLocation())) {
            return this.getState();
        }
        TileEntity tileEntity = this.world.func_175625_s(location.getInDimensionLocation());
        if (tileEntity instanceof TileEntityChest && !(tileEntity instanceof TileEntityColonyBuilding)) {
            if (((TileEntityChest)tileEntity).field_145987_o == 0) {
                this.world.func_175641_c(tileEntity.func_174877_v(), tileEntity.func_145838_q(), 1, 1);
                this.world.func_175685_c(tileEntity.func_174877_v(), tileEntity.func_145838_q(), true);
                this.world.func_175685_c(tileEntity.func_174877_v().func_177977_b(), tileEntity.func_145838_q(), true);
                this.setDelay(3);
                return this.getState();
            }
            this.world.func_175641_c(tileEntity.func_174877_v(), tileEntity.func_145838_q(), 1, 0);
            this.world.func_175685_c(tileEntity.func_174877_v(), tileEntity.func_145838_q(), true);
            this.world.func_175685_c(tileEntity.func_174877_v().func_177977_b(), tileEntity.func_145838_q(), true);
        }
        if (this.gatherIfInTileEntity(tileEntity, request.getRequest().getStack())) {
            this.setDelay(3);
            return AIWorkerState.DELIVERY;
        }
        ((BuildingDeliveryman)this.getOwnBuilding()).setBuildingToDeliver(null);
        ((JobDeliveryman)this.job).finishRequest(false);
        return AIWorkerState.START_WORKING;
    }

    public boolean gatherIfInTileEntity(TileEntity entity, ItemStack is) {
        return is != null && InventoryFunctions.matchFirstInProviderWithAction((ICapabilityProvider)entity, stack -> ItemStackUtils.isEmpty(stack) == false && ItemStackUtils.compareItemStacksIgnoreStackSize(is, stack, true, true) != false, (provider, index) -> InventoryUtils.transferXOfItemStackIntoNextFreeSlotFromProvider(provider, index, is.func_190916_E() == 1 ? is.func_77976_d() : is.func_190916_E(), (IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen())));
    }

    private IAIState checkWareHouse() {
        if (!this.worker.isWorkerAtSiteWithMove(this.getWareHouse().getLocation(), 5)) {
            return AIWorkerState.START_WORKING;
        }
        this.worker.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3 + (double)(this.worker.getCitizenExperienceHandler().getLevel() > 50 ? 50 : this.worker.getCitizenExperienceHandler().getLevel()) * 0.003);
        Object ownBuilding = this.getOwnBuilding();
        if (((JobDeliveryman)this.job).getCurrentTask() == null) {
            ((BuildingDeliveryman)ownBuilding).setBuildingToDeliver(null);
            return AIWorkerState.GATHERING;
        }
        if (((JobDeliveryman)this.job).isReturning()) {
            ((BuildingDeliveryman)ownBuilding).setBuildingToDeliver(null);
            return AIWorkerState.DUMPING;
        }
        ((BuildingDeliveryman)ownBuilding).setBuildingToDeliver(((JobDeliveryman)this.job).getCurrentTask().getRequest().getTarget());
        return AIWorkerState.PREPARE_DELIVERY;
    }

    private boolean checkIfExecute() {
        if (this.getWareHouse() != null && this.getWareHouse().getTileEntity() != null) {
            return false;
        }
        Map<BlockPos, AbstractBuilding> buildings = ((JobDeliveryman)this.job).getColony().getBuildingManager().getBuildings();
        for (AbstractBuilding building : buildings.values()) {
            if (building == null) continue;
            Colony buildingColony = building.getColony();
            Colony ownColony = this.worker.getCitizenColonyHandler().getColony();
            if (!(building instanceof BuildingWareHouse) || ownColony == null || buildingColony == null || buildingColony.getID() != ownColony.getID() || !((BuildingWareHouse)building).registerWithWareHouse((BuildingDeliveryman)this.getOwnBuilding())) continue;
            return false;
        }
        this.chatSpamFilter.talkWithoutSpam("com.minecolonies.coremod.job.deliveryman.noWarehouse", new Object[0]);
        return true;
    }
}

