/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.Player;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.entity.ai.Status;
import com.minecolonies.api.entity.ai.pathfinding.IWalkToProxy;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.CitizenDataView;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.colony.jobs.JobStudent;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.entity.AbstractEntityCitizen;
import com.minecolonies.coremod.entity.ai.citizen.guard.AbstractEntityAIGuard;
import com.minecolonies.coremod.entity.ai.minimal.EntityAICitizenAvoidEntity;
import com.minecolonies.coremod.entity.ai.minimal.EntityAICitizenChild;
import com.minecolonies.coremod.entity.ai.minimal.EntityAICitizenWander;
import com.minecolonies.coremod.entity.ai.minimal.EntityAIEatTask;
import com.minecolonies.coremod.entity.ai.minimal.EntityAIGoHome;
import com.minecolonies.coremod.entity.ai.minimal.EntityAIMournCitizen;
import com.minecolonies.coremod.entity.ai.minimal.EntityAIOpenFenceGate;
import com.minecolonies.coremod.entity.ai.minimal.EntityAISleep;
import com.minecolonies.coremod.entity.ai.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.coremod.entity.citizenhandlers.CitizenChatHandler;
import com.minecolonies.coremod.entity.citizenhandlers.CitizenColonyHandler;
import com.minecolonies.coremod.entity.citizenhandlers.CitizenExperienceHandler;
import com.minecolonies.coremod.entity.citizenhandlers.CitizenInventoryHandler;
import com.minecolonies.coremod.entity.citizenhandlers.CitizenItemHandler;
import com.minecolonies.coremod.entity.citizenhandlers.CitizenJobHandler;
import com.minecolonies.coremod.entity.citizenhandlers.CitizenSleepHandler;
import com.minecolonies.coremod.entity.citizenhandlers.CitizenStatusHandler;
import com.minecolonies.coremod.entity.citizenhandlers.CitizenStuckHandler;
import com.minecolonies.coremod.entity.pathfinding.EntityCitizenWalkToProxy;
import com.minecolonies.coremod.entity.pathfinding.PathNavigate;
import com.minecolonies.coremod.entity.pathfinding.PathResult;
import com.minecolonies.coremod.inventory.InventoryCitizen;
import com.minecolonies.coremod.items.ModItems;
import com.minecolonies.coremod.network.messages.OpenInventoryMessage;
import com.minecolonies.coremod.util.PermissionUtils;
import com.minecolonies.coremod.util.SoundUtils;
import com.minecolonies.coremod.util.TeleportHelper;
import java.time.Clock;
import java.time.LocalDate;
import java.time.Month;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemNameTag;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityCitizen
extends AbstractEntityCitizen {
    private final PathNavigate newNavigator;
    private PathResult moveAwayPath;
    private int citizenId = 0;
    private IWalkToProxy proxy;
    @Nullable
    private CitizenData citizenData;
    private BlockPos currentPosition = null;
    private boolean isDay = true;
    private NBTTagCompound dataBackup = null;
    private final CitizenExperienceHandler citizenExperienceHandler = new CitizenExperienceHandler(this);
    private final CitizenChatHandler citizenChatHandler = new CitizenChatHandler(this);
    private final CitizenStatusHandler citizenStatusHandler = new CitizenStatusHandler(this);
    private final CitizenItemHandler citizenItemHandler = new CitizenItemHandler(this);
    private final CitizenInventoryHandler citizenInventoryHandler = new CitizenInventoryHandler(this);
    private final CitizenColonyHandler citizenColonyHandler = new CitizenColonyHandler(this);
    private final CitizenJobHandler citizenJobHandler = new CitizenJobHandler(this);
    private final CitizenSleepHandler citizenSleepHandler = new CitizenSleepHandler(this);
    private final CitizenStuckHandler citizenStuckHandler = new CitizenStuckHandler(this);
    private boolean mourning = false;
    private boolean hidingFromRain = false;
    private boolean isChild = false;
    private boolean currentlyFleeing = false;
    private int callForHelpCooldown = 0;
    private static final int CALL_HELP_CD = 100;
    private IItemHandler invWrapper;

    public EntityCitizen(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
        this.func_110163_bv();
        this.func_174805_g(Configurations.gameplay.alwaysRenderNameTag);
        this.newNavigator = new PathNavigate((EntityLiving)this, world);
        this.field_70699_by = this.newNavigator;
        if (CompatibilityUtils.getWorld((Entity)this).field_72995_K) {
            EntityCitizen.func_184227_b((double)2.0);
        }
        this.newNavigator.func_179693_d(true);
        this.newNavigator.func_179691_c(true);
        this.initTasks();
    }

    private void initTasks() {
        int priority = 0;
        this.field_70714_bg.func_75776_a(priority, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        if (this.citizenJobHandler.getColonyJob() == null || !"com.minecolonies.coremod.job.Guard".equals(this.citizenJobHandler.getColonyJob().getName())) {
            this.field_70714_bg.func_75776_a(++priority, (EntityAIBase)new EntityAICitizenAvoidEntity(this, EntityMob.class, 5.0f, 0.8, 1.1));
        }
        this.field_70714_bg.func_75776_a(++priority, (EntityAIBase)new EntityAIEatTask(this));
        this.field_70714_bg.func_75776_a(++priority, (EntityAIBase)new EntityAISleep(this));
        this.field_70714_bg.func_75776_a(++priority, (EntityAIBase)new EntityAIGoHome(this));
        this.field_70714_bg.func_75776_a(++priority, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(priority, (EntityAIBase)new EntityAIOpenFenceGate((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(++priority, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(++priority, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityCitizen.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(++priority, (EntityAIBase)new EntityAICitizenWander(this, 0.6, 1.0));
        this.field_70714_bg.func_75776_a(++priority, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 6.0f));
        this.field_70714_bg.func_75776_a(++priority, (EntityAIBase)new EntityAIMournCitizen(this, 0.6));
        this.citizenJobHandler.onJobChanged(this.citizenJobHandler.getColonyJob());
    }

    @Override
    public void setRenderMetadata(String metadata) {
        super.setRenderMetadata(metadata);
        this.field_70180_af.func_187227_b(DATA_RENDER_METADATA, (Object)this.getRenderMetadata());
        if (this.citizenData != null) {
            if (this.citizenJobHandler.getColonyJob() != null && Configurations.gameplay.enableInDevelopmentFeatures) {
                this.func_96094_a(this.citizenData.getName() + " (" + (Object)((Object)this.citizenStatusHandler.getStatus()) + ")[" + this.citizenJobHandler.getColonyJob().getNameTagDescription() + "]");
            } else {
                this.func_96094_a(this.citizenData.getName());
            }
        }
    }

    public ILocation getLocation() {
        return StandardFactoryController.getInstance().getNewInstance(TypeConstants.ILOCATION, this, new Object[0]);
    }

    public boolean isWorkerAtSiteWithMove(@NotNull BlockPos site, int range) {
        if (this.proxy == null) {
            this.proxy = new EntityCitizenWalkToProxy(this);
        }
        return this.proxy.walkToBlock(site, range, true);
    }

    public Team func_96124_cp() {
        return this.field_70170_p.func_96441_U().func_96508_e("teamcolony" + this.getCitizenColonyHandler().getColonyId());
    }

    public boolean func_70097_a(@NotNull DamageSource damageSource, float damage) {
        float damageInc;
        if (damageSource.func_76355_l().equals(DamageSource.field_76368_d.func_76355_l())) {
            TeleportHelper.teleportCitizen(this, this.field_70170_p, this.func_180425_c().func_177982_a(0, 1, 0));
            return false;
        }
        if (damageSource.func_76355_l().equals(DamageSource.field_76368_d.func_76355_l()) && this.citizenSleepHandler.isAsleep() || Compatibility.isDynTreePresent() && damageSource.field_76373_n.equals(Compatibility.getDynamicTreeDamage()) || this.func_190530_aW()) {
            return false;
        }
        Entity sourceEntity = damageSource.func_76346_g();
        if (sourceEntity instanceof EntityCitizen) {
            if (((EntityCitizen)sourceEntity).citizenColonyHandler.getColonyId() == this.citizenColonyHandler.getColonyId()) {
                return false;
            }
            Colony attackerColony = ((EntityCitizen)sourceEntity).citizenColonyHandler.getColony();
            if (attackerColony != null && this.citizenColonyHandler.getColony() != null) {
                Permissions permission = attackerColony.getPermissions();
                this.citizenColonyHandler.getColony().getPermissions().addPlayer(permission.getOwner(), permission.getOwnerName(), Rank.HOSTILE);
            }
        }
        if (sourceEntity instanceof EntityPlayer && this.getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard && !AbstractBuildingGuards.checkIfGuardShouldTakeDamage(this, (EntityPlayer)sourceEntity)) {
            return false;
        }
        float f = damageInc = damage > this.func_110138_aP() * 0.2f ? this.func_110138_aP() * 0.2f : damage;
        if (!this.field_70170_p.field_72995_K) {
            this.performMoveAway(sourceEntity);
        }
        this.func_130011_c(damageSource.func_76346_g());
        boolean result = super.func_70097_a(damageSource, damageInc);
        if (damageSource.func_82725_o() || damageSource.func_76347_k()) {
            return result;
        }
        this.citizenItemHandler.updateArmorDamage(damageInc);
        if (this.citizenData != null) {
            this.getCitizenData().getCitizenHappinessHandler().setDamageModifier();
        }
        return result;
    }

    private void performMoveAway(@Nullable Entity attacker) {
        this.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.avoiding", new Object[0])});
        if (!(attacker instanceof EntityLivingBase)) {
            this.moveAwayPath = this.getNavigator().moveAwayFromEntityLiving((Entity)this, 5.0, 1.1);
            return;
        }
        this.currentlyFleeing = true;
        if (this.getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard) {
            this.callForHelp(attacker, 900);
            return;
        }
        this.callForHelp(attacker, 10000);
        this.moveAwayPath = this.getNavigator().moveAwayFromEntityLiving(attacker, 15.0, 1.1);
    }

    public void callForHelp(Entity attacker, int guardHelpRange) {
        if (!(attacker instanceof EntityLivingBase) || !Configurations.gameplay.citizenCallForHelp || this.callForHelpCooldown != 0) {
            return;
        }
        this.callForHelpCooldown = 100;
        long guardDistance = guardHelpRange;
        EntityCitizen guard = null;
        for (CitizenData entry : this.getCitizenColonyHandler().getColony().getCitizenManager().getCitizens()) {
            if (!entry.getCitizenEntity().isPresent()) continue;
            long tdist = BlockPosUtil.getDistanceSquared(entry.getCitizenEntity().get().func_180425_c(), this.func_180425_c());
            if (!(entry.getJob() instanceof AbstractJobGuard) || tdist >= guardDistance || !((AbstractEntityAIGuard)entry.getJob().getWorkerAI()).canHelp()) continue;
            guardDistance = tdist;
            guard = entry.getCitizenEntity().get();
        }
        if (guard != null) {
            ((AbstractEntityAIGuard)guard.getCitizenData().getJob().getWorkerAI()).startHelpCitizen(this, (EntityLivingBase)attacker);
        }
    }

    public <T> T getCapability(@NotNull Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            CitizenData data = this.getCitizenData();
            if (data == null) {
                return (T)super.getCapability(capability, facing);
            }
            InventoryCitizen inv = data.getInventory();
            if (this.invWrapper == null) {
                this.invWrapper = new InvWrapper((IInventory)inv);
            }
            return (T)this.invWrapper;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(@NotNull Capability<?> capability, EnumFacing facing) {
        if (this.getCitizenData() == null) {
            return super.hasCapability(capability, facing);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    protected void func_184590_k(float damage) {
        if (this.func_184586_b(this.func_184600_cs()).func_77973_b() instanceof ItemShield) {
            this.citizenItemHandler.damageItemInHand(this.func_184600_cs(), (int)damage);
        }
        super.func_184590_k(damage);
    }

    public void func_70645_a(@NotNull DamageSource damageSource) {
        this.currentlyFleeing = false;
        double penalty = 0.2;
        if (this.citizenColonyHandler.getColony() != null && this.getCitizenData() != null) {
            if (damageSource.func_76346_g() instanceof EntityPlayer && !this.field_70170_p.field_72995_K) {
                boolean isBarbarianClose = false;
                for (AbstractEntityMinecoloniesMob barbarian : this.getCitizenColonyHandler().getColony().getRaiderManager().getHorde((WorldServer)this.field_70170_p)) {
                    if (!(MathUtils.twoDimDistance(barbarian.func_180425_c(), this.func_180425_c()) < 21.0)) continue;
                    isBarbarianClose = true;
                    break;
                }
                for (Player player : PermissionUtils.getPlayersWithAtLeastRank(this.citizenColonyHandler.getColony(), Rank.OFFICER)) {
                    if (!player.getID().equals(damageSource.func_76346_g().func_110124_au()) || isBarbarianClose) continue;
                    penalty = 9.0;
                    break;
                }
            }
            this.citizenExperienceHandler.dropExperience();
            this.func_70106_y();
            this.citizenColonyHandler.getColony().getHappinessData().setDeathModifier(penalty, this.citizenJobHandler.getColonyJob() instanceof AbstractJobGuard);
            this.triggerDeathAchievement(damageSource, this.citizenJobHandler.getColonyJob());
            this.citizenChatHandler.notifyDeath(damageSource);
            if (!(this.citizenJobHandler.getColonyJob() instanceof AbstractJobGuard) && damageSource != DamageSource.field_76368_d) {
                this.citizenColonyHandler.getColony().setNeedToMourn(true, this.citizenData.getName());
            }
            this.citizenColonyHandler.getColony().getCitizenManager().removeCitizen(this.getCitizenData());
        }
        super.func_70645_a(damageSource);
    }

    private void triggerDeathAchievement(DamageSource source, AbstractJob job) {
        if (job != null) {
            job.triggerDeathAchievement(source, this);
        }
    }

    @Nullable
    public CitizenData getCitizenData() {
        CitizenData data;
        if (this.citizenData == null && this.citizenColonyHandler != null && this.citizenColonyHandler.getColony() != null && (data = this.citizenColonyHandler.getColony().getCitizenManager().getCitizen(this.citizenId)) != null) {
            this.citizenData = data;
        }
        return this.citizenData;
    }

    public boolean func_184645_a(EntityPlayer player, @NotNull EnumHand hand) {
        ColonyView colonyView = ColonyManager.getColonyView(this.citizenColonyHandler.getColonyId(), player.field_70170_p.field_73011_w.getDimension());
        if (colonyView != null && !colonyView.getPermissions().hasPermission(player, Action.ACCESS_HUTS)) {
            return false;
        }
        if (!ItemStackUtils.isEmpty(player.func_184586_b(hand)).booleanValue() && player.func_184586_b(hand).func_77973_b() instanceof ItemNameTag) {
            return super.func_184645_a(player, hand);
        }
        if (CompatibilityUtils.getWorld((Entity)this).field_72995_K) {
            if (player.func_70093_af()) {
                MineColonies.getNetwork().sendToServer((IMessage)new OpenInventoryMessage(this.func_70005_c_(), this.func_145782_y()));
            } else {
                CitizenDataView citizenDataView = this.getCitizenDataView();
                if (citizenDataView != null) {
                    MineColonies.proxy.showCitizenWindow(citizenDataView);
                }
            }
        }
        return true;
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_COLONY_ID, (Object)(this.citizenColonyHandler == null ? 0 : this.citizenColonyHandler.getColonyId()));
        this.field_70180_af.func_187214_a(DATA_CITIZEN_ID, (Object)this.citizenId);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("status", this.citizenStatusHandler.getStatus().ordinal());
        if (this.citizenColonyHandler.getColony() != null && this.citizenData != null) {
            compound.func_74768_a("colony", this.citizenColonyHandler.getColony().getID());
            compound.func_74768_a("citizen", this.citizenData.getId());
        }
        compound.func_74757_a("day", this.isDay);
        compound.func_74757_a("child", this.isChild);
        compound.func_74757_a("mourning", this.mourning);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.citizenStatusHandler.setStatus(Status.values()[compound.func_74762_e("status")]);
        this.citizenColonyHandler.setColonyId(compound.func_74762_e("colony"));
        this.citizenId = compound.func_74762_e("citizen");
        if (this.func_70613_aW()) {
            this.citizenColonyHandler.updateColonyServer();
        }
        this.isDay = compound.func_74767_n("day");
        this.setIsChild(compound.func_74767_n("child"));
        if (compound.func_74764_b("mourning")) {
            this.mourning = compound.func_74767_n("mourning");
        }
        if (compound.func_74764_b("HeldItemSlot") || compound.func_74764_b("OffhandHeldItemSlot")) {
            this.dataBackup = compound;
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.callForHelpCooldown > 0) {
            --this.callForHelpCooldown;
        }
        if (this.field_70718_bc > 0) {
            this.markDirty();
        }
        if (CompatibilityUtils.getWorld((Entity)this).field_72995_K) {
            this.citizenColonyHandler.updateColonyClient();
        } else {
            if (this.getOffsetTicks() % 20 == 0) {
                ItemStack hat = this.func_184582_a(EntityEquipmentSlot.HEAD);
                if (LocalDate.now(Clock.systemDefaultZone()).getMonth() == Month.DECEMBER && Configurations.gameplay.holidayFeatures && !(this.getCitizenJobHandler().getColonyJob() instanceof JobStudent)) {
                    if (hat.func_190926_b()) {
                        this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(ModItems.santaHat));
                    }
                } else if (!hat.func_190926_b() && hat.func_77973_b() == ModItems.santaHat) {
                    this.func_184201_a(EntityEquipmentSlot.HEAD, ItemStackUtils.EMPTY);
                }
                this.func_174805_g(Configurations.gameplay.alwaysRenderNameTag);
                this.citizenItemHandler.pickupItems();
                this.citizenChatHandler.cleanupChatMessages();
                this.citizenColonyHandler.updateColonyServer();
                if (this.citizenData != null) {
                    this.citizenData.setLastPosition(this.func_180425_c());
                }
            }
            if (this.citizenJobHandler.getColonyJob() != null || !CompatibilityUtils.getWorld((Entity)this).func_72935_r()) {
                this.citizenStuckHandler.onUpdate();
            } else if (this.isMourning()) {
                this.citizenStatusHandler.setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.mourning", new Object[0])});
            } else {
                this.citizenStatusHandler.setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.waitingForWork", new Object[0])});
            }
            if (CompatibilityUtils.getWorld((Entity)this).func_72935_r() && !CompatibilityUtils.getWorld((Entity)this).func_72896_J() && this.citizenData != null) {
                SoundUtils.playRandomSound(CompatibilityUtils.getWorld((Entity)this), this, this.citizenData.getSaturation());
            } else if (this.citizenStatusHandler.getStatus() != Status.SLEEPING && CompatibilityUtils.getWorld((Entity)this).func_72896_J() && 1 >= this.field_70146_Z.nextInt(6000) && this.citizenJobHandler.getColonyJob() != null) {
                SoundUtils.playSoundAtCitizenWithChance(CompatibilityUtils.getWorld((Entity)this), this.func_180425_c(), this.citizenJobHandler.getColonyJob().getBadWeatherSound(), 1);
            }
        }
        if (!(!this.func_70094_T() && !this.func_70055_a(Material.field_151584_j) || this.moveAwayPath != null && this.moveAwayPath.isInProgress())) {
            this.moveAwayPath = this.getNavigator().moveAwayFromXYZ(this.func_180425_c(), 6.0, 2.0);
        }
        this.citizenExperienceHandler.gatherXp();
        if (this.citizenData != null) {
            if (this.citizenData.getSaturation() <= 0.0) {
                this.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"slowness")));
            } else {
                this.func_184596_c(Potion.func_180142_b((String)"slowness"));
            }
            if (this.citizenData.getSaturation() >= 7.0) {
                this.citizenData.getCitizenHappinessHandler().setSaturated();
            }
            if (((double)this.field_70140_Q + 1.0) % 25.0 == 0.0) {
                this.decreaseSaturationForAction();
            }
        }
        if (this.dataBackup != null) {
            NBTTagList nbttaglist = this.dataBackup.func_150295_c("Inventory", 10);
            this.getCitizenData().getInventory().readFromNBT(nbttaglist);
            if (this.dataBackup.func_74764_b("HeldItemSlot")) {
                this.getCitizenData().getInventory().setHeldItem(EnumHand.MAIN_HAND, this.dataBackup.func_74762_e("HeldItemSlot"));
            }
            if (this.dataBackup.func_74764_b("OffhandHeldItemSlot")) {
                this.getCitizenData().getInventory().setHeldItem(EnumHand.OFF_HAND, this.dataBackup.func_74762_e("OffhandHeldItemSlot"));
            }
            this.dataBackup = null;
        }
        this.checkHeal();
    }

    public void func_96094_a(@NotNull String name) {
        if (this.citizenData != null && this.citizenColonyHandler.getColony() != null) {
            if (!name.contains(this.citizenData.getName()) && Configurations.gameplay.allowGlobalNameChanges >= 0) {
                if (Configurations.gameplay.allowGlobalNameChanges == 0 && Arrays.stream(Configurations.gameplay.specialPermGroup).noneMatch(owner -> owner.equals(this.citizenColonyHandler.getColony().getPermissions().getOwnerName()))) {
                    LanguageHandler.sendPlayersMessage(this.citizenColonyHandler.getColony().getMessageEntityPlayers(), "com.minecolonies.coremod.citizen.rename.notAllowed", new Object[0]);
                    return;
                }
                if (this.citizenColonyHandler.getColony() != null) {
                    for (CitizenData citizen : this.citizenColonyHandler.getColony().getCitizenManager().getCitizens()) {
                        if (!citizen.getName().equals(name)) continue;
                        LanguageHandler.sendPlayersMessage(this.citizenColonyHandler.getColony().getMessageEntityPlayers(), "com.minecolonies.coremod.citizen.rename.same", new Object[0]);
                        return;
                    }
                    this.citizenData.setName(name);
                    this.citizenData.markDirty();
                    super.func_96094_a(name);
                }
                return;
            }
            super.func_96094_a(name);
        }
    }

    private void checkHeal() {
        if (this.citizenData != null && this.getOffsetTicks() % 100 == 0 && this.func_110143_aJ() < this.func_110138_aP()) {
            int healAmount = 1;
            if (this.citizenData.getSaturation() >= 10.0) {
                ++healAmount;
            } else if (this.citizenData.getSaturation() < 3.0) {
                healAmount = 0;
            }
            this.func_70691_i(healAmount);
            this.citizenData.markDirty();
        }
    }

    public void increaseHPForGuards() {
        if (this.getCitizenData() != null) {
            this.removeHealthModifier("MinecoloniesGuardLevelHealth");
            AttributeModifier healthModLevel = new AttributeModifier("MinecoloniesGuardLevelHealth", (double)((int)((double)this.getCitizenData().getLevel() / (5.0 + (double)this.getCitizenData().getLevel() / 20.0) * 2.0)), 0);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(healthModLevel);
        }
    }

    public void removeAllHealthModifiers() {
        for (AttributeModifier mod : this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111122_c()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111124_b(mod);
        }
        if (this.func_110143_aJ() > this.func_110138_aP()) {
            this.func_70606_j(this.func_110138_aP());
        }
    }

    public void removeHealthModifier(String modifierName) {
        for (AttributeModifier mod : this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111122_c()) {
            if (!mod.func_111166_b().equals(modifierName)) continue;
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111124_b(mod);
        }
        if (this.func_110143_aJ() > this.func_110138_aP()) {
            this.func_70606_j(this.func_110138_aP());
        }
    }

    private CitizenDataView getCitizenDataView() {
        ColonyView colonyView;
        if (this.citizenColonyHandler.getColonyId() != 0 && this.citizenId != 0 && (colonyView = ColonyManager.getColonyView(this.citizenColonyHandler.getColonyId(), this.field_70170_p.field_73011_w.getDimension())) != null) {
            return colonyView.getCitizen(this.citizenId);
        }
        return null;
    }

    @NotNull
    public PathNavigate getNavigator() {
        return this.newNavigator;
    }

    protected void func_82160_b(boolean par1, int par2) {
        for (int i = 0; i < new InvWrapper((IInventory)this.getInventoryCitizen()).getSlots(); ++i) {
            ItemStack itemstack = this.getCitizenData().getInventory().func_70301_a(i);
            if (ItemStackUtils.getSize(itemstack) <= 0) continue;
            this.citizenItemHandler.entityDropItem(itemstack);
        }
    }

    @NotNull
    public InventoryCitizen getInventoryCitizen() {
        return this.getCitizenData().getInventory();
    }

    @NotNull
    public IItemHandler getItemHandlerCitizen() {
        return new InvWrapper((IInventory)this.getInventoryCitizen());
    }

    @NotNull
    public BlockPos func_180486_cf() {
        AbstractBuilding homeBuilding = this.citizenColonyHandler.getHomeBuilding();
        if (homeBuilding != null) {
            return homeBuilding.getLocation();
        }
        if (this.citizenColonyHandler.getColony() != null && this.citizenColonyHandler.getColony().getBuildingManager().getTownHall() != null) {
            return this.citizenColonyHandler.getColony().getBuildingManager().getTownHall().getLocation();
        }
        return super.func_180486_cf();
    }

    public void markDirty() {
        if (this.citizenData != null) {
            this.citizenData.markDirty();
        }
    }

    @NotNull
    public DesiredActivity getDesiredActivity() {
        if (this.citizenJobHandler.getColonyJob() instanceof AbstractJobGuard) {
            return DesiredActivity.WORK;
        }
        if (this.getCitizenColonyHandler().getColony() != null && this.getCitizenColonyHandler().getColony().isMourning() && this.mourning) {
            return DesiredActivity.MOURN;
        }
        if (this.getCitizenColonyHandler().getColony() != null && !this.field_70170_p.field_72995_K && !this.getCitizenColonyHandler().getColony().getRaiderManager().getHorde((WorldServer)this.field_70170_p).isEmpty()) {
            this.isDay = false;
            return DesiredActivity.SLEEP;
        }
        if (Colony.shallUpdate(this.field_70170_p, 1200)) {
            if (!CompatibilityUtils.getWorld((Entity)this).func_72935_r()) {
                if (this.isDay && this.citizenData != null) {
                    this.isDay = false;
                    double decreaseBy = this.citizenColonyHandler.getPerBuildingFoodCost() * 2.0;
                    this.citizenData.decreaseSaturation(decreaseBy);
                    this.citizenData.markDirty();
                }
                this.citizenStatusHandler.setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.sleeping", new Object[0])});
                return DesiredActivity.SLEEP;
            }
            if (this.citizenSleepHandler.isAsleep()) {
                this.citizenSleepHandler.onWakeUp();
            }
            this.isDay = true;
            if (CompatibilityUtils.getWorld((Entity)this).func_72896_J() && !this.shouldWorkWhileRaining()) {
                this.hidingFromRain = true;
                this.citizenStatusHandler.setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.waiting", new Object[0]), new TextComponentTranslation("com.minecolonies.coremod.status.rainStop", new Object[0])});
                return DesiredActivity.IDLE;
            }
            this.hidingFromRain = false;
            if (this.getNavigator().func_75505_d() != null && this.getNavigator().func_75505_d().func_75874_d() == 0) {
                this.getNavigator().func_75499_g();
            }
            return DesiredActivity.WORK;
        }
        return this.isDay ? (this.hidingFromRain ? DesiredActivity.IDLE : DesiredActivity.WORK) : DesiredActivity.SLEEP;
    }

    private boolean shouldWorkWhileRaining() {
        return Configurations.gameplay.workersAlwaysWorkInRain || this.citizenColonyHandler.getWorkBuilding() != null && this.citizenColonyHandler.getWorkBuilding().canWorkDuringTheRain();
    }

    public void setCitizensize(@NotNull float width, @NotNull float height) {
        this.field_70130_N = width;
        this.field_70131_O = height;
    }

    public boolean func_70631_g_() {
        return this.isChild;
    }

    public void setIsChild(boolean isChild) {
        if (isChild && !this.isChild) {
            this.field_70714_bg.func_75776_a(50, (EntityAIBase)new EntityAICitizenChild(this));
            this.setCitizensize(0.3f, 0.9f);
        } else {
            this.setCitizensize(0.6f, 1.8f);
        }
        this.isChild = isChild;
        this.func_184212_Q().func_187227_b(DATA_IS_CHILD, (Object)isChild);
        this.markDirty();
    }

    public void playMoveAwaySound() {
        if (this.citizenJobHandler.getColonyJob() != null) {
            SoundUtils.playSoundAtCitizenWithChance(CompatibilityUtils.getWorld((Entity)this), this.func_180425_c(), this.citizenJobHandler.getColonyJob().getMoveAwaySound(), 1);
        }
    }

    public IWalkToProxy getProxy() {
        return this.proxy;
    }

    public void decreaseSaturationForAction() {
        if (this.citizenData != null) {
            this.citizenData.decreaseSaturation(this.citizenColonyHandler.getPerBuildingFoodCost());
            this.citizenData.markDirty();
        }
    }

    public void decreaseSaturationForContinuousAction() {
        if (this.citizenData != null) {
            this.citizenData.decreaseSaturation(this.citizenColonyHandler.getPerBuildingFoodCost() / 100.0);
            this.citizenData.markDirty();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof EntityCitizen) {
            EntityCitizen citizen = (EntityCitizen)((Object)obj);
            return citizen.citizenColonyHandler.getColonyId() == this.citizenColonyHandler.getColonyId() && citizen.citizenId == this.citizenId;
        }
        return false;
    }

    public int hashCode() {
        if (this.citizenColonyHandler == null) {
            return super.hashCode();
        }
        return Objects.hash(this.citizenId, this.citizenColonyHandler.getColonyId());
    }

    public int getCitizenId() {
        return this.citizenId;
    }

    public void setCitizenId(int id) {
        this.citizenId = id;
    }

    public void setCitizenData(@Nullable CitizenData data) {
        this.citizenData = data;
    }

    public BlockPos getCurrentPosition() {
        return this.currentPosition;
    }

    public void setCurrentPosition(BlockPos currentPosition) {
        this.currentPosition = currentPosition;
    }

    public void spawnEatingParticle() {
        this.func_184584_a(this.func_184614_ca(), 5);
    }

    public CitizenExperienceHandler getCitizenExperienceHandler() {
        return this.citizenExperienceHandler;
    }

    public CitizenChatHandler getCitizenChatHandler() {
        return this.citizenChatHandler;
    }

    public CitizenStatusHandler getCitizenStatusHandler() {
        return this.citizenStatusHandler;
    }

    public CitizenItemHandler getCitizenItemHandler() {
        return this.citizenItemHandler;
    }

    public CitizenInventoryHandler getCitizenInventoryHandler() {
        return this.citizenInventoryHandler;
    }

    public CitizenColonyHandler getCitizenColonyHandler() {
        return this.citizenColonyHandler;
    }

    public CitizenJobHandler getCitizenJobHandler() {
        return this.citizenJobHandler;
    }

    public CitizenSleepHandler getCitizenSleepHandler() {
        return this.citizenSleepHandler;
    }

    public CitizenStuckHandler getCitizenStuckHandler() {
        return this.citizenStuckHandler;
    }

    public boolean isOkayToEat() {
        return !this.getCitizenSleepHandler().isAsleep() && this.getDesiredActivity() != DesiredActivity.SLEEP && (this.citizenJobHandler.getColonyJob() == null || this.citizenJobHandler.getColonyJob().isOkayToEat());
    }

    public boolean shouldBeFed() {
        return this.getCitizenData() != null && this.getCitizenData().getSaturation() <= 5.0 && !this.getCitizenData().justAte();
    }

    public boolean isIdlingAtJob() {
        return this.isOkayToEat() && (this.citizenJobHandler.getColonyJob() == null || this.citizenJobHandler.getColonyJob().isIdling());
    }

    public void setMourning(boolean mourning) {
        this.mourning = mourning;
    }

    public boolean isMourning() {
        return this.mourning;
    }

    public boolean isCurrentlyFleeing() {
        return this.currentlyFleeing;
    }

    public void setFleeingState(boolean fleeing) {
        this.currentlyFleeing = fleeing;
    }

    protected boolean func_70692_ba() {
        return false;
    }
}

