/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands.requestsystem;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.minecolonies.coremod.commands.ActionMenuState;
import com.minecolonies.coremod.commands.IActionCommand;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.jetbrains.annotations.NotNull;

public class RSResetAllCommand
extends AbstractSingleCommand
implements IActionCommand {
    public static final String DESC = "rsResetAll";
    private static final String SUCCESS_MESSAGE = "After 1.618 Seconds it reinstantiated all colonies completely new.";

    public RSResetAllCommand() {
        super(new String[0]);
    }

    public RSResetAllCommand(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "<ColonyId> <(Optional)Player>";
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull ActionMenuState actionMenuState) throws CommandException {
        this.executeShared(server, sender);
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        this.executeShared(server, sender);
    }

    private void executeShared(@NotNull MinecraftServer server, @NotNull ICommandSender sender) throws CommandException {
        EntityPlayer player;
        if (sender instanceof EntityPlayer && !RSResetAllCommand.isPlayerOpped((ICommandSender)(player = (EntityPlayer)sender))) {
            sender.func_145747_a((ITextComponent)new TextComponentString("You are not allowed to do that!"));
            return;
        }
        for (Colony colony : ColonyManager.getAllColonies()) {
            colony.getRequestManager().reset();
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format(SUCCESS_MESSAGE, new Object[0])));
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return false;
    }
}

