/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.minecolonies.coremod.commands.ActionMenuState;
import com.minecolonies.coremod.commands.IActionCommand;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import org.jetbrains.annotations.NotNull;

public class ListColoniesCommand
extends AbstractSingleCommand
implements IActionCommand {
    public static final String DESC = "list";
    private static final String ID_AND_NAME_TEXT = "\u00a72ID: \u00a7f%s \u00a72 Name: \u00a7f%s";
    private static final String COORDINATES_TEXT = "\u00a72Coordinates: \u00a7f";
    private static final String COORDINATES_XYZ = "\u00a74x=\u00a7f%s \u00a74y=\u00a7f%s \u00a74z=\u00a7f%s";
    private static final String LIST_COMMAND_SUGGESTED = "/mc colonies list page: ";
    public static final String TELEPORT_COMMAND = "/mc colony teleport colony: ";
    private static final String PAGE_TOP_LEFT = "\u00a72   ------------------ page ";
    private static final String PAGE_TOP_RIGHT = " ------------------";
    private static final String PAGE_TOP_MIDDLE = " of ";
    private static final String PREV_PAGE = " <- prev";
    private static final String NEXT_PAGE = "next -> ";
    private static final String PAGE_LINE = "\u00a72 ----------------";
    private static final String PAGE_LINE_DIVIDER = "\u00a72 | ";
    private static final String COMMAND_COLONY_INFO = "/mc colony info colony: %d";
    private static final int COLONIES_ON_PAGE = 9;

    public ListColoniesCommand() {
        super(new String[0]);
    }

    public ListColoniesCommand(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender);
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull ActionMenuState actionMenuState) throws CommandException {
        Integer page = actionMenuState.getIntegerForArgument("page");
        Integer abandonedSinceTimeInHours = actionMenuState.getIntegerForArgument("abandonedSinceTimeInHours");
        this.executeShared(server, sender, page, abandonedSinceTimeInHours);
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        int page = ListColoniesCommand.getIthArgument(args, 0, 1);
        int abandonedSinceTimeInHours = ListColoniesCommand.getIthArgument(args, 1, 0);
        this.executeShared(server, sender, page, abandonedSinceTimeInHours);
    }

    private void executeShared(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @Nullable Integer pageProvided, @Nullable Integer abandonedSinceTimeInHoursProvided) throws CommandException {
        int page = null != pageProvided ? pageProvided : 1;
        int abandonedSinceTimeInHours = null != abandonedSinceTimeInHoursProvided ? abandonedSinceTimeInHoursProvided : 0;
        List<Colony> colonies = abandonedSinceTimeInHours > 0 ? ColonyManager.getColoniesAbandonedSince(abandonedSinceTimeInHours) : ColonyManager.getAllColonies();
        int colonyCount = colonies.size();
        int halfPage = colonyCount % 9 == 0 ? 0 : 1;
        int pageCount = colonyCount / 9 + halfPage;
        if (page < 1 || page > pageCount) {
            page = 1;
        }
        int pageStartIndex = 9 * (page - 1);
        int pageStopIndex = Math.min(9 * page, colonyCount);
        int prevPage = Math.max(0, page - 1);
        int nextPage = Math.min(page + 1, colonyCount / 9 + halfPage);
        List<Object> coloniesPage = pageStartIndex < 0 || pageStartIndex >= colonyCount ? new ArrayList() : colonies.subList(pageStartIndex, pageStopIndex);
        TextComponentString headerLine = new TextComponentString(PAGE_TOP_LEFT + page + PAGE_TOP_MIDDLE + pageCount + PAGE_TOP_RIGHT);
        sender.func_145747_a((ITextComponent)headerLine);
        for (Colony colony : coloniesPage) {
            sender.func_145747_a(new TextComponentString(String.format(ID_AND_NAME_TEXT, colony.getID(), colony.getName())).func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format(COMMAND_COLONY_INFO, colony.getID())))));
            BlockPos center = colony.getCenter();
            TextComponentString teleport = new TextComponentString(COORDINATES_TEXT + String.format(COORDINATES_XYZ, center.func_177958_n(), center.func_177956_o(), center.func_177952_p()));
            if (ListColoniesCommand.isPlayerOpped(sender)) {
                teleport.func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)).func_150238_a(TextFormatting.GOLD).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, TELEPORT_COMMAND + colony.getID())));
            }
            sender.func_145747_a((ITextComponent)teleport);
        }
        ITextComponent prevButton = new TextComponentString(PREV_PAGE).func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)).func_150238_a(TextFormatting.GOLD).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, LIST_COMMAND_SUGGESTED + prevPage)));
        ITextComponent iTextComponent = new TextComponentString(NEXT_PAGE).func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)).func_150238_a(TextFormatting.GOLD).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, LIST_COMMAND_SUGGESTED + nextPage)));
        TextComponentString beginLine = new TextComponentString(PAGE_LINE);
        TextComponentString endLine = new TextComponentString(PAGE_LINE);
        sender.func_145747_a(beginLine.func_150257_a(prevButton).func_150257_a((ITextComponent)new TextComponentString(PAGE_LINE_DIVIDER)).func_150257_a(iTextComponent).func_150257_a((ITextComponent)endLine));
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return new ArrayList<String>();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return false;
    }
}

