/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.minecolonies.coremod.commands.ActionMenuState;
import com.minecolonies.coremod.commands.IActionCommand;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.jetbrains.annotations.NotNull;

public class AddOfficerCommand
extends AbstractSingleCommand
implements IActionCommand {
    public static final String DESC = "addOfficer";

    public AddOfficerCommand() {
        super(new String[0]);
    }

    public AddOfficerCommand(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "<ColonyId> <(Optional)Player>";
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull ActionMenuState actionMenuState) throws CommandException {
        Colony colony = actionMenuState.getColonyForArgument("colony");
        EntityPlayerMP player = actionMenuState.getPlayerForArgument("player");
        this.executeShared(server, sender, colony, player.func_70005_c_());
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        IColony colony;
        if (args.length == 0) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Please define a colony or player"));
            return;
        }
        Entity senderEntity = sender.func_174793_f();
        int colonyId = AddOfficerCommand.getIthArgument(args, 0, -1);
        if (colonyId == -1 && senderEntity instanceof EntityPlayer) {
            colony = ColonyManager.getIColonyByOwner(sender.func_130014_f_(), ((EntityPlayer)sender).func_110124_au());
            if (colony == null) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Couldn't find colony %d."));
                return;
            }
            colonyId = colony.getID();
        }
        if ((colony = ColonyManager.getColonyByWorld(colonyId, sender.func_130014_f_())) == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format("Couldn't find colony %d.", colonyId)));
            return;
        }
        String playerName = null;
        if (args.length >= 2) {
            playerName = args[1];
        }
        if (playerName == null || playerName.isEmpty()) {
            playerName = sender.func_70005_c_();
        }
        this.executeShared(server, sender, (Colony)colony, playerName);
    }

    private void executeShared(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull Colony colony, String playerName) throws CommandException {
        EntityPlayer senderPlayer;
        Entity senderEntity = sender.func_174793_f();
        if (senderEntity instanceof EntityPlayer && !this.canPlayerUseCommand(senderPlayer = (EntityPlayer)sender, AbstractSingleCommand.Commands.ADDOFFICER, colony.getID())) {
            sender.func_145747_a((ITextComponent)new TextComponentString("You are not allowed to do that!"));
            return;
        }
        colony.getPermissions().addPlayer(playerName, Rank.OFFICER, colony.getWorld());
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format("Successfully added Player %s to colony %d", playerName, colony.getID())));
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return false;
    }
}

