/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers.core;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.requestsystem.requesters.IBuildingBasedRequester;
import com.minecolonies.coremod.colony.requestsystem.resolvers.core.AbstractRequestResolver;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCraftingRequestResolver
extends AbstractRequestResolver<IDeliverable>
implements IBuildingBasedRequester {
    public final boolean isPublicCrafter;

    public AbstractCraftingRequestResolver(@NotNull ILocation location, @NotNull IToken<?> token, boolean isPublicCrafter) {
        super(location, token);
        this.isPublicCrafter = isPublicCrafter;
    }

    @Override
    public TypeToken<? extends IDeliverable> getRequestType() {
        return TypeToken.of(IDeliverable.class);
    }

    @Override
    public Optional<IRequester> getBuilding(@NotNull IRequestManager manager, @NotNull IToken<?> token) {
        if (!manager.getColony().getWorld().field_72995_K) {
            return Optional.ofNullable(manager.getColony().getRequesterBuildingForPosition(this.getRequesterLocation().getInDimensionLocation()));
        }
        return Optional.empty();
    }

    @Override
    @NotNull
    public void onRequestComplete(@NotNull IRequestManager manager, @NotNull IToken<?> token) {
    }

    @Override
    public boolean canResolve(@NotNull IRequestManager manager, IRequest<? extends IDeliverable> requestToCheck) {
        if (!manager.getColony().getWorld().field_72995_K) {
            ILocation requesterLocation = requestToCheck.getRequester().getRequesterLocation();
            if (this.isPublicCrafter || requesterLocation.equals(this.getRequesterLocation())) {
                Optional<AbstractBuilding> building = this.getBuilding(manager, (IToken<?>)requestToCheck.getToken()).map(r -> (AbstractBuilding)r);
                return building.map(b -> this.canResolveForBuilding(manager, requestToCheck, (AbstractBuilding)b)).orElse(false);
            }
        }
        return false;
    }

    public boolean canResolveForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request, @NotNull AbstractBuilding building) {
        if (this.createsCraftingCycle(manager, request, request)) {
            return false;
        }
        return building instanceof AbstractBuildingWorker && this.canBuildingCraftStack((AbstractBuildingWorker)building, itemStack -> ((IDeliverable)request.getRequest()).matches((ItemStack)itemStack));
    }

    protected boolean createsCraftingCycle(@NotNull IRequestManager manager, @NotNull IRequest<?> request, @NotNull IRequest<? extends IDeliverable> target) {
        return this.createsCraftingCycle(manager, request, target, 0);
    }

    protected boolean createsCraftingCycle(@NotNull IRequestManager manager, @NotNull IRequest<?> request, @NotNull IRequest<? extends IDeliverable> target, int count) {
        if (count > 20) {
            return false;
        }
        if (!request.equals(target) && request.getRequest().equals(target.getRequest())) {
            return true;
        }
        if (!request.hasParent()) {
            return false;
        }
        return this.createsCraftingCycle(manager, manager.getRequestForToken((IToken<?>)request.getParent()), target, count + 1);
    }

    public abstract boolean canBuildingCraftStack(@NotNull AbstractBuildingWorker var1, Predicate<ItemStack> var2);

    @Override
    @Nullable
    public List<IToken<?>> attemptResolve(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
        AbstractBuilding building = this.getBuilding(manager, (IToken<?>)request.getToken()).map(r -> (AbstractBuilding)r).get();
        return this.attemptResolveForBuilding(manager, request, building);
    }

    @Nullable
    public List<IToken<?>> attemptResolveForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request, @NotNull AbstractBuilding building) {
        AbstractBuildingWorker buildingWorker = (AbstractBuildingWorker)building;
        return this.attemptResolveForBuildingAndStack(manager, buildingWorker, itemStack -> ((IDeliverable)request.getRequest()).matches((ItemStack)itemStack), request.getRequest().getCount());
    }

    @Nullable
    protected List<IToken<?>> attemptResolveForBuildingAndStack(@NotNull IRequestManager manager, @NotNull AbstractBuildingWorker building, @NotNull Predicate<ItemStack> stackPrecicate, int count) {
        IRecipeStorage craftableCrafting = building.getFirstRecipe(stackPrecicate);
        if (craftableCrafting == null) {
            return null;
        }
        return this.createRequestsForRecipe(manager, craftableCrafting.getPrimaryOutput(), count);
    }

    @Nullable
    protected List<IToken<?>> createRequestsForRecipe(@NotNull IRequestManager manager, ItemStack requestStack, int count) {
        return ImmutableList.of(manager.createRequest(this, this.createNewRequestableForStack(requestStack, count)));
    }

    protected abstract IRequestable createNewRequestableForStack(ItemStack var1, int var2);

    @Override
    public void resolve(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
        AbstractBuilding building = this.getBuilding(manager, (IToken<?>)request.getToken()).map(r -> (AbstractBuilding)r).get();
        this.resolveForBuilding(manager, request, building);
    }

    public void resolveForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request, @NotNull AbstractBuilding building) {
        manager.updateRequestState((IToken<?>)request.getToken(), RequestState.COMPLETED);
    }
}

