/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers;

import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PrivateCrafting;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.requestsystem.resolvers.core.AbstractCraftingRequestResolver;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrivateWorkerCraftingRequestResolver
extends AbstractCraftingRequestResolver {
    public PrivateWorkerCraftingRequestResolver(@NotNull ILocation location, @NotNull IToken<?> token) {
        super(location, token, false);
    }

    @Override
    @Nullable
    public List<IRequest<?>> getFollowupRequestForCompletion(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> completedRequest) {
        return null;
    }

    @Override
    @Nullable
    public IRequest<?> onRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
        return null;
    }

    @Override
    public void onRequestBeingOverruled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
    }

    @Override
    public void onRequestComplete(@NotNull IRequestManager manager, @NotNull IToken<?> token) {
    }

    @Override
    public void onRequestCancelled(@NotNull IRequestManager manager, @NotNull IToken<?> token) {
    }

    @Override
    @NotNull
    public ITextComponent getDisplayName(@NotNull IRequestManager manager, @NotNull IToken<?> token) {
        IRequest<?> request = manager.getRequestForToken(token);
        if (request == null) {
            return new TextComponentString("<UNKNOWN>");
        }
        if (!request.hasParent()) {
            return new TextComponentTranslation("com.minecolonies.coremod.resolvers.crafter.private", new Object[0]);
        }
        request = manager.getRequestForToken((IToken<?>)request.getParent());
        if (request == null) {
            return new TextComponentTranslation("com.minecolonies.coremod.resolvers.crafter.private", new Object[0]);
        }
        return request.getRequester().getDisplayName(manager, (IToken<?>)request.getToken()).func_150257_a((ITextComponent)new TextComponentString(" (")).func_150257_a((ITextComponent)new TextComponentTranslation("com.minecolonies.coremod.resolvers.crafter.private", new Object[0])).func_150257_a((ITextComponent)new TextComponentString(")"));
    }

    @Override
    public int getPriority() {
        return 125;
    }

    @Override
    public boolean canBuildingCraftStack(@NotNull AbstractBuildingWorker building, Predicate<ItemStack> stackPredicate) {
        return building.getFirstRecipe(stackPredicate) != null;
    }

    @Override
    protected IRequestable createNewRequestableForStack(ItemStack stack, int count) {
        return new PrivateCrafting(stack, count);
    }
}

