/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.data.IRequestSystemCrafterJobDataStore;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.client.render.RenderBipedCitizen;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractJobCrafter
extends AbstractJob {
    private IToken<?> rsDataStoreToken;

    public AbstractJobCrafter(CitizenData entity) {
        super(entity);
        this.setupRsDataStore();
    }

    private void setupRsDataStore() {
        this.rsDataStoreToken = this.getCitizen().getColony().getRequestManager().getDataStoreManager().get(StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), TypeConstants.REQUEST_SYSTEM_CRAFTER_JOB_DATA_STORE).getId();
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (compound.func_74764_b("DataStoreToken")) {
            this.rsDataStoreToken = (IToken)StandardFactoryController.getInstance().deserialize(compound.func_74775_l("DataStoreToken"));
        } else {
            this.setupRsDataStore();
        }
    }

    @Override
    @NotNull
    public RenderBipedCitizen.Model getModel() {
        return RenderBipedCitizen.Model.CRAFTER;
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74782_a("DataStoreToken", (NBTBase)StandardFactoryController.getInstance().serialize(this.rsDataStoreToken));
    }

    private IRequestSystemCrafterJobDataStore getDataStore() {
        return this.getCitizen().getColony().getRequestManager().getDataStoreManager().get(this.rsDataStoreToken, TypeConstants.REQUEST_SYSTEM_CRAFTER_JOB_DATA_STORE);
    }

    private LinkedList<IToken<?>> getTaskQueueFromDataStore() {
        return this.getDataStore().getQueue();
    }

    public List<IToken<?>> getAssignedTasksFromDataStore() {
        return this.getDataStore().getAssignedTasks();
    }

    public boolean hasTask() {
        return !this.getTaskQueueFromDataStore().isEmpty();
    }

    public IRequest<? extends PublicCrafting> getCurrentTask() {
        if (this.getTaskQueueFromDataStore().isEmpty()) {
            return null;
        }
        return this.getColony().getRequestManager().getRequestForToken(this.getTaskQueueFromDataStore().peekFirst());
    }

    public void addRequest(@NotNull IToken<?> token) {
        this.getTaskQueueFromDataStore().add(token);
    }

    public void finishRequest(@NotNull boolean successful) {
        if (this.getTaskQueueFromDataStore().isEmpty()) {
            return;
        }
        IToken<?> current = this.getTaskQueueFromDataStore().getFirst();
        this.getColony().getRequestManager().updateRequestState(current, successful ? RequestState.COMPLETED : RequestState.CANCELLED);
        if (!this.getTaskQueueFromDataStore().isEmpty() && current == this.getTaskQueueFromDataStore().getFirst()) {
            this.getTaskQueueFromDataStore().removeFirst();
        }
    }

    public void onTaskDeletion(@NotNull IToken<?> token) {
        if (this.getTaskQueueFromDataStore().contains(token)) {
            this.getTaskQueueFromDataStore().remove(token);
        } else if (this.getAssignedTasksFromDataStore().contains(token)) {
            this.getAssignedTasksFromDataStore().remove(token);
        }
    }

    public void onTaskBeingScheduled(@NotNull IToken<?> token) {
        this.getAssignedTasksFromDataStore().add(token);
    }

    public void onTaskBeingResolved(@NotNull IToken<?> token) {
        this.onTaskDeletion(token);
        this.addRequest(token);
    }

    public List<IToken<?>> getTaskQueue() {
        return ImmutableList.copyOf(this.getTaskQueueFromDataStore());
    }

    public List<IToken<?>> getAssignedTasks() {
        return ImmutableList.copyOf(this.getAssignedTasksFromDataStore());
    }
}

