/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.WindowHutSifter;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingCrafter;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobSifter;
import com.minecolonies.coremod.network.messages.SifterSettingsMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class BuildingSifter
extends AbstractBuildingWorker {
    private static final double BUILDING_LEVEL_MULTIPLIER = 64.0;
    private static final String SIFTER_DESC = "Sifter";
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final String TAG_MESH = "mesh";
    private static final String TAG_MESH_PROB = "meshProb";
    private int dailyQuantity = 0;
    private int currentDailyQuantity = 0;
    private ItemStorage sievableBlock = null;
    private Tuple<ItemStorage, Double> sifterMesh = null;

    public BuildingSifter(Colony c, BlockPos l) {
        super(c, l);
        if (!ColonyManager.getCompatibilityManager().getSievableBlock().isEmpty()) {
            this.sievableBlock = ColonyManager.getCompatibilityManager().getSievableBlock().get(0);
        }
        if (!ColonyManager.getCompatibilityManager().getMeshes().isEmpty()) {
            this.sifterMesh = ColonyManager.getCompatibilityManager().getMeshes().get(0);
        }
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return SIFTER_DESC;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public AbstractJob createJob(CitizenData citizen) {
        return new JobSifter(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return SIFTER_DESC;
    }

    @Override
    public boolean canCraftComplexRecipes() {
        return false;
    }

    public int getDailyQuantity() {
        return this.dailyQuantity;
    }

    public ItemStorage getSievableBlock() {
        return this.sievableBlock;
    }

    public Tuple<ItemStorage, Double> getMesh() {
        return this.sifterMesh;
    }

    public void setCurrentDailyQuantity(int currentDailyQuantity) {
        this.currentDailyQuantity = currentDailyQuantity;
    }

    public int getMaxDailyQuantity() {
        if (this.getBuildingLevel() >= 5) {
            return Integer.MAX_VALUE;
        }
        return (int)(Math.pow(this.getBuildingLevel(), 2.0) * 64.0);
    }

    public void resetMesh() {
        if (!ColonyManager.getCompatibilityManager().getMeshes().isEmpty()) {
            this.sifterMesh = ColonyManager.getCompatibilityManager().getMeshes().get(0);
        }
    }

    public void setup(ItemStorage block, ItemStorage mesh, int quantity) {
        this.sievableBlock = block;
        for (Tuple<ItemStorage, Double> tuple : ColonyManager.getCompatibilityManager().getMeshes()) {
            if (!((ItemStorage)tuple.func_76341_a()).equals(mesh)) continue;
            this.sifterMesh = new Tuple((Object)mesh, tuple.func_76340_b());
            break;
        }
        this.dailyQuantity = quantity;
        this.markDirty();
    }

    @Override
    public void onWakeUp() {
        super.onWakeUp();
        this.currentDailyQuantity = 0;
    }

    public int getCurrentDailyQuantity() {
        return this.currentDailyQuantity;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.dailyQuantity = compound.func_74762_e("daily");
        this.currentDailyQuantity = compound.func_74762_e("currentDaily");
        this.sievableBlock = new ItemStorage(new ItemStack(compound.func_74775_l("block")));
        ItemStorage mesh = new ItemStorage(new ItemStack(compound.func_74775_l(TAG_MESH)));
        double prob = compound.func_74769_h(TAG_MESH_PROB);
        this.sifterMesh = new Tuple((Object)mesh, (Object)prob);
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74768_a("daily", this.dailyQuantity);
        compound.func_74768_a("currentDaily", this.currentDailyQuantity);
        NBTTagCompound sievableBlockTAG = new NBTTagCompound();
        this.sievableBlock.getItemStack().func_77955_b(sievableBlockTAG);
        compound.func_74782_a("block", (NBTBase)sievableBlockTAG);
        NBTTagCompound meshTAG = new NBTTagCompound();
        ((ItemStorage)this.sifterMesh.func_76341_a()).getItemStack().func_77955_b(meshTAG);
        compound.func_74782_a(TAG_MESH, (NBTBase)meshTAG);
        compound.func_74780_a(TAG_MESH_PROB, ((Double)this.sifterMesh.func_76340_b()).doubleValue());
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeInt(this.dailyQuantity);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.sievableBlock.getItemStack());
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)((ItemStorage)this.sifterMesh.func_76341_a()).getItemStack());
        buf.writeInt(ColonyManager.getCompatibilityManager().getSievableBlock().size());
        for (ItemStorage itemStorage : ColonyManager.getCompatibilityManager().getSievableBlock()) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)itemStorage.getItemStack());
        }
        buf.writeInt(ColonyManager.getCompatibilityManager().getMeshes().size());
        for (Tuple tuple : ColonyManager.getCompatibilityManager().getMeshes()) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)((ItemStorage)tuple.func_76341_a()).getItemStack());
        }
    }

    public static class View
    extends AbstractBuildingCrafter.View {
        private int dailyQuantity = 0;
        private ItemStorage sifterBlock;
        private ItemStorage mesh;
        private List<ItemStorage> sievableBlocks = new ArrayList<ItemStorage>();
        private List<ItemStorage> meshes = new ArrayList<ItemStorage>();

        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
            this.dailyQuantity = buf.readInt();
            this.sifterBlock = new ItemStorage(ByteBufUtils.readItemStack((ByteBuf)buf));
            this.mesh = new ItemStorage(ByteBufUtils.readItemStack((ByteBuf)buf));
            this.sievableBlocks.clear();
            this.meshes.clear();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                this.sievableBlocks.add(new ItemStorage(ByteBufUtils.readItemStack((ByteBuf)buf)));
            }
            int size2 = buf.readInt();
            for (int i = 0; i < size2; ++i) {
                this.meshes.add(new ItemStorage(ByteBufUtils.readItemStack((ByteBuf)buf)));
            }
        }

        public int getDailyQuantity() {
            return this.dailyQuantity;
        }

        public ItemStorage getSifterBlock() {
            return this.sifterBlock;
        }

        public ItemStorage getMesh() {
            return this.mesh;
        }

        public List<ItemStorage> getSievableBlocks() {
            return this.sievableBlocks;
        }

        public List<ItemStorage> getMeshes() {
            return this.meshes;
        }

        public void save(ItemStorage sifterBlock, ItemStorage mesh, int dailyQuantity, boolean buy) {
            this.sifterBlock = sifterBlock;
            this.mesh = mesh;
            MineColonies.getNetwork().sendToServer((IMessage)new SifterSettingsMessage(this, sifterBlock, mesh, dailyQuantity, buy));
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutSifter(this);
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getPrimarySkill() {
            return AbstractBuildingWorker.Skill.STRENGTH;
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getSecondarySkill() {
            return AbstractBuildingWorker.Skill.ENDURANCE;
        }
    }
}

