/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.client.gui.WindowHutCitizen;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.entity.EntityCitizen;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.BlockBed;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;

public class BuildingHome
extends AbstractBuilding {
    private static final String CITIZEN = "Citizen";
    @NotNull
    private final List<BlockPos> bedList = new ArrayList<BlockPos>();
    private boolean femalePresent = false;
    private boolean malePresent = false;
    private static final int MIN_TIME_BEFORE_SPAWNTRY = 300;
    private int childCreationInterval = 600;
    private int childCreationTimer;
    private static final int CHILD_STATS_VARIANCE = 3;

    public BuildingHome(Colony c, BlockPos l) {
        super(c, l);
        Random rand = new Random();
        this.childCreationTimer = rand.nextInt(this.childCreationInterval) + 300;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (compound.func_74764_b("residents")) {
            int[] residentIds;
            for (int citizenId : residentIds = compound.func_74759_k("residents")) {
                CitizenData citizen = this.getColony().getCitizenManager().getCitizen(citizenId);
                if (citizen == null) continue;
                this.assignCitizen(citizen);
            }
        }
        NBTTagList bedTagList = compound.func_150295_c("beds", 10);
        for (int i = 0; i < bedTagList.func_74745_c(); ++i) {
            NBTTagCompound bedCompound = bedTagList.func_150305_b(i);
            BlockPos bedPos = NBTUtil.func_186861_c((NBTTagCompound)bedCompound);
            if (this.bedList.contains(bedPos)) continue;
            this.bedList.add(bedPos);
        }
    }

    @Override
    public void onWakeUp() {
        World world = this.getColony().getWorld();
        if (world == null) {
            return;
        }
        for (BlockPos pos : this.bedList) {
            IBlockState state = world.func_180495_p(pos);
            if (!((state = state.func_177230_c().getExtendedState(state, (IBlockAccess)world, pos)).func_177230_c() instanceof BlockBed) || !((Boolean)state.func_177229_b((IProperty)BlockBed.field_176471_b)).booleanValue() || !((BlockBed.EnumPartType)state.func_177229_b((IProperty)BlockBed.field_176472_a)).equals((Object)BlockBed.EnumPartType.HEAD)) continue;
            world.func_180501_a(pos, state.func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return CITIZEN;
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        if (this.hasAssignedCitizen()) {
            int[] residentIds = new int[this.getAssignedCitizen().size()];
            for (int i = 0; i < this.getAssignedCitizen().size(); ++i) {
                residentIds[i] = this.getAssignedCitizen().get(i).getId();
            }
            compound.func_74783_a("residents", residentIds);
        }
        if (!this.bedList.isEmpty()) {
            NBTTagList bedTagList = new NBTTagList();
            for (BlockPos pos : this.bedList) {
                bedTagList.func_74742_a((NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
            }
            compound.func_74782_a("beds", (NBTBase)bedTagList);
        }
    }

    @Override
    public void registerBlockPosition(@NotNull IBlockState blockState, @NotNull BlockPos pos, @NotNull World world) {
        super.registerBlockPosition(blockState, pos, world);
        BlockPos registrationPosition = pos;
        if (blockState.func_177230_c() instanceof BlockBed) {
            if (blockState.func_177229_b((IProperty)BlockBed.field_176472_a) == BlockBed.EnumPartType.FOOT) {
                registrationPosition = registrationPosition.func_177972_a((EnumFacing)blockState.func_177229_b((IProperty)BlockBed.field_185512_D));
            }
            if (!this.bedList.contains(registrationPosition)) {
                this.bedList.add(registrationPosition);
            }
        }
    }

    @Override
    public void onDestroyed() {
        super.onDestroyed();
        this.getAssignedCitizen().stream().filter(Objects::nonNull).forEach(citizen -> citizen.setHomeBuilding(null));
    }

    @Override
    public void removeCitizen(@NotNull CitizenData citizen) {
        if (this.isCitizenAssigned(citizen)) {
            super.removeCitizen(citizen);
            citizen.setHomeBuilding(null);
            this.femalePresent = false;
            this.malePresent = false;
            for (CitizenData citizenData : this.getAssignedCitizen()) {
                if (citizenData.isFemale()) {
                    this.femalePresent = true;
                } else {
                    this.malePresent = true;
                }
                if (!this.femalePresent || !this.malePresent) continue;
                return;
            }
        }
    }

    @Override
    public void secondsWorldTick(@NotNull TickEvent.WorldTickEvent event) {
        if (this.childCreationTimer > this.childCreationInterval) {
            this.childCreationTimer = 0;
            this.trySpawnChild();
        }
        ++this.childCreationTimer;
    }

    @Override
    public void onWorldTick(@NotNull TickEvent.WorldTickEvent event) {
        if (!Colony.shallUpdate(event.world, 20)) {
            return;
        }
        if (this.getAssignedCitizen().size() < this.getMaxInhabitants() && this.getColony() != null && !this.getColony().isManualHousing()) {
            this.addHomelessCitizens();
        }
    }

    public void trySpawnChild() {
        if (this.colony.canMoveIn() && this.femalePresent && this.malePresent && this.colony.getCitizenManager().getCurrentCitizenCount() < this.colony.getCitizenManager().getMaxCitizens()) {
            CitizenData mom = null;
            CitizenData dad = null;
            for (CitizenData data : this.getAssignedCitizen()) {
                if (data.isFemale() && !data.isChild()) {
                    mom = data;
                } else if (!data.isChild()) {
                    dad = data;
                }
                if (mom == null || dad == null) continue;
                break;
            }
            if (mom == null || dad == null) {
                return;
            }
            CitizenData newCitizen = this.colony.getCitizenManager().createAndRegisterNewCitizenData();
            Random rand = new Random();
            int str = (mom.getStrength() + dad.getStrength()) / 2 + rand.nextInt(3) - rand.nextInt(3);
            int cha = (mom.getCharisma() + dad.getCharisma()) / 2 + rand.nextInt(3) - rand.nextInt(3);
            int dex = (mom.getDexterity() + dad.getDexterity()) / 2 + rand.nextInt(3) - rand.nextInt(3);
            int end = (mom.getEndurance() + dad.getEndurance()) / 2 + rand.nextInt(3) - rand.nextInt(3);
            int intelligence = (mom.getIntelligence() + dad.getIntelligence()) / 2 + rand.nextInt(3) - rand.nextInt(3);
            newCitizen.setIsChild(true);
            newCitizen.setStrength(str);
            newCitizen.setCharisma(cha);
            newCitizen.setDexterity(dex);
            newCitizen.setEndurance(end);
            newCitizen.setIntelligence(intelligence);
            if (this.assignCitizen(newCitizen)) {
                if (rand.nextInt(2) == 1) {
                    this.inheritLastName(newCitizen, mom.getName());
                } else {
                    this.inheritLastName(newCitizen, dad.getName());
                }
            } else {
                block1: for (AbstractBuilding build : this.colony.getBuildingManager().getBuildings().values()) {
                    if (!(build instanceof BuildingHome) || !build.assignCitizen(newCitizen)) continue;
                    for (CitizenData data : build.getAssignedCitizen()) {
                        if (data.getId() == newCitizen.getId()) continue;
                        this.inheritLastName(newCitizen, data.getName());
                        break block1;
                    }
                }
            }
            LanguageHandler.sendPlayersMessage(this.colony.getMessageEntityPlayers(), "com.minecolonies.coremod.progress.newChild", new Object[0]);
            this.colony.getCitizenManager().spawnOrCreateCitizen(newCitizen, this.colony.getWorld(), this.getLocation());
        }
    }

    private void inheritLastName(@NotNull CitizenData child, String parentName) {
        if (parentName == null || parentName.split(" ").length < 2 || child.getName().split(" ").length < 2) {
            return;
        }
        String[] newName = child.getName().split(" ");
        String[] lastName = parentName.split(" ");
        newName[newName.length - 1] = lastName[lastName.length - 1];
        String combinedName = "";
        for (String namePart : newName) {
            combinedName = combinedName + namePart + " ";
        }
        child.setName(combinedName.trim());
    }

    @Override
    public int getMaxInhabitants() {
        return this.getBuildingLevel();
    }

    private void addHomelessCitizens() {
        for (CitizenData citizen : this.getColony().getCitizenManager().getCitizens()) {
            if (this.isFull()) break;
            if (this.femalePresent && citizen.isFemale() || this.malePresent && !citizen.isFemale()) continue;
            this.moveCitizenToHut(citizen);
        }
        for (CitizenData citizen : this.getColony().getCitizenManager().getCitizens()) {
            if (this.isFull()) break;
            this.moveCitizenToHut(citizen);
        }
    }

    private void moveCitizenToHut(CitizenData citizen) {
        if (citizen.getHomeBuilding() instanceof BuildingHome && citizen.getHomeBuilding().getBuildingLevel() < this.getBuildingLevel()) {
            citizen.getHomeBuilding().removeCitizen(citizen);
        }
        if (citizen.getHomeBuilding() == null) {
            this.assignCitizen(citizen);
        }
    }

    @Override
    public boolean assignCitizen(CitizenData citizen) {
        if (!super.assignCitizen(citizen)) {
            return false;
        }
        if (citizen.isFemale()) {
            this.femalePresent = true;
        } else {
            this.malePresent = true;
        }
        citizen.setHomeBuilding(this);
        return true;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        if (newLevel == 1) {
            this.getColony().getStatsManager().triggerAchievement(ModAchievements.achievementBuildingColonist);
        }
        if (newLevel >= this.getMaxBuildingLevel()) {
            this.getColony().getStatsManager().triggerAchievement(ModAchievements.achievementUpgradeColonistMax);
        }
        for (Optional<EntityCitizen> entityCitizen : this.getAssignedEntities()) {
            if (!entityCitizen.isPresent() || entityCitizen.get().getCitizenJobHandler().getColonyJob() != null) continue;
            entityCitizen.get().getCitizenJobHandler().setModelDependingOnJob(null);
        }
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeInt(this.getAssignedCitizen().size());
        for (CitizenData citizen : this.getAssignedCitizen()) {
            buf.writeInt(citizen.getId());
        }
    }

    @Override
    public void setBuildingLevel(int level) {
        super.setBuildingLevel(level);
        this.getColony().getCitizenManager().calculateMaxCitizens();
    }

    @NotNull
    public List<BlockPos> getBedList() {
        return new ArrayList<BlockPos>(this.bedList);
    }

    public int getCitizenCreationInterval() {
        return this.childCreationInterval;
    }

    public void setCitizenCreationInterval(int childCreationInterval) {
        this.childCreationTimer = childCreationInterval;
    }

    public static class View
    extends AbstractBuildingView {
        @NotNull
        private final List<Integer> residents = new ArrayList<Integer>();

        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @NotNull
        public List<Integer> getResidents() {
            return Collections.unmodifiableList(this.residents);
        }

        public void removeResident(int index) {
            this.residents.remove(index);
        }

        public void addResident(int id) {
            this.residents.add(id);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutCitizen(this);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
            int numResidents = buf.readInt();
            for (int i = 0; i < numResidents; ++i) {
                this.residents.add(buf.readInt());
            }
        }
    }
}

