/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.client.gui.WindowHutWorkerPlaceholder;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobCombatTraining;
import com.minecolonies.coremod.entity.EntityCitizen;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHay;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BuildingCombatAcademy
extends AbstractBuildingWorker {
    private static final String SCHEMATIC_NAME = "CombatAcademy";
    private static final String DESC = "CombatAcademy";
    private final List<BlockPos> fightingPos = new ArrayList<BlockPos>();
    private final BiMap<Integer, Integer> trainingPartners = HashBiMap.create();

    public BuildingCombatAcademy(@NotNull Colony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public AbstractJob createJob(CitizenData citizen) {
        return new JobCombatTraining(citizen);
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        if (block == Blocks.field_150423_aK && world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockHay) {
            this.fightingPos.add(pos.func_177977_b());
        }
        super.registerBlockPosition(block, pos, world);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.fightingPos.clear();
        NBTTagList targetTagList = compound.func_150295_c("combatTarget", 10);
        this.fightingPos.addAll(NBTUtils.streamCompound(targetTagList).map(targetCompound -> BlockPosUtil.readFromNBT(targetCompound, "target")).collect(Collectors.toList()));
        NBTTagList partnersTagList = compound.func_150295_c("combatPartner", 10);
        this.trainingPartners.putAll(NBTUtils.streamCompound(partnersTagList).collect(Collectors.toMap(targetCompound -> targetCompound.func_74762_e("combatPartner1"), targetCompound -> targetCompound.func_74762_e("combatPartner2"))));
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagList targetTagList = this.fightingPos.stream().map(target -> BlockPosUtil.writeToNBT(new NBTTagCompound(), "target", target)).collect(NBTUtils.toNBTTagList());
        compound.func_74782_a("combatTarget", (NBTBase)targetTagList);
        NBTTagList partnersTagList = this.trainingPartners.entrySet().stream().map(BuildingCombatAcademy::writePartnerTupleToNBT).collect(NBTUtils.toNBTTagList());
        compound.func_74782_a("combatPartner", (NBTBase)partnersTagList);
    }

    private static NBTTagCompound writePartnerTupleToNBT(Map.Entry<Integer, Integer> tuple) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("combatPartner1", tuple.getKey().intValue());
        compound.func_74768_a("combatPartner2", tuple.getValue().intValue());
        return compound;
    }

    @Override
    public String getSchematicName() {
        return "CombatAcademy";
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public String getJobName() {
        return "melee";
    }

    @Override
    public int getMaxInhabitants() {
        return this.getBuildingLevel();
    }

    public BlockPos getRandomCombatTarget(Random random) {
        if (!this.fightingPos.isEmpty()) {
            return this.fightingPos.get(random.nextInt(this.fightingPos.size()));
        }
        return null;
    }

    public EntityCitizen getRandomCombatPartner(EntityCitizen citizen) {
        CitizenData citizenData = citizen.getCitizenData();
        if (citizenData != null) {
            CitizenData partner = this.getAssignedCitizen().stream().filter(data -> data.getId() != citizenData.getId()).filter(data -> !this.trainingPartners.containsKey((Object)data.getId())).filter(data -> !this.trainingPartners.containsValue((Object)data.getId())).findFirst().orElse(null);
            if (partner != null) {
                this.trainingPartners.put((Object)citizenData.getId(), (Object)partner.getId());
                return partner.getCitizenEntity().orElse(null);
            }
            return null;
        }
        return null;
    }

    public EntityCitizen getCombatPartner(EntityCitizen citizen) {
        CitizenData data = citizen.getCitizenData();
        if (data != null) {
            int citizenId;
            if (this.trainingPartners.containsKey((Object)data.getId())) {
                citizenId = (Integer)this.trainingPartners.get((Object)data.getId());
            } else if (this.trainingPartners.containsValue((Object)data.getId())) {
                citizenId = (Integer)this.trainingPartners.inverse().get((Object)data.getId());
            } else {
                return null;
            }
            CitizenData citizenData = this.getAssignedCitizen().stream().filter(cit -> cit.getId() != data.getId()).filter(cit -> cit.getId() == citizenId).findFirst().orElse(null);
            if (citizenData != null) {
                return citizenData.getCitizenEntity().orElse(null);
            }
        }
        return null;
    }

    public boolean hasCombatPartner(EntityCitizen citizen) {
        return this.getCombatPartner(citizen) != null;
    }

    public void resetPartner(EntityCitizen worker) {
        CitizenData data = worker.getCitizenData();
        if (data != null) {
            if (this.trainingPartners.containsKey((Object)data.getId())) {
                this.trainingPartners.remove((Object)data.getId());
            } else if (this.trainingPartners.containsValue((Object)data.getId())) {
                this.trainingPartners.inverse().remove((Object)data.getId());
            }
        }
    }

    public static class View
    extends AbstractBuildingWorker.View {
        public View(ColonyView c, @NotNull BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutWorkerPlaceholder<View>(this, "CombatAcademy");
        }

        @Override
        public boolean hasEnoughWorkers() {
            return this.getWorkerId().size() >= this.getBuildingLevel();
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getPrimarySkill() {
            return AbstractBuildingWorker.Skill.STRENGTH;
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getSecondarySkill() {
            return AbstractBuildingWorker.Skill.DEXTERITY;
        }
    }
}

