/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.client.gui.WindowHutBaker;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.AbstractFilterableListBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractFilterableListsView;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobBaker;
import com.minecolonies.coremod.entity.ai.citizen.baker.BakerRecipes;
import com.minecolonies.coremod.entity.ai.citizen.baker.BakingProduct;
import com.minecolonies.coremod.entity.ai.citizen.baker.ProductState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;

public class BuildingBaker
extends AbstractFilterableListBuilding {
    private static final String BAKER = "Baker";
    private static final int BAKER_HUT_MAX_LEVEL = 5;
    private static final String TAG_TASKS = "tasks";
    private static final String TAG_STATE = "state";
    private static final String TAG_PRODUCTS = "products";
    private static final String TAG_FURNACE_POS = "furnacePos";
    private static final String TAG_RECIPE_POS = "recipePos";
    private static final String TAG_FURNACES = "furnaces";
    private static final int WAIT_TICKS = 320;
    private static final int WHEAT_TO_KEEP = 128;
    private final Map<BlockPos, BakingProduct> furnaces = new HashMap<BlockPos, BakingProduct>();
    private final Map<ProductState, List<BakingProduct>> tasks = new EnumMap<ProductState, List<BakingProduct>>(ProductState.class);

    public BuildingBaker(Colony c, BlockPos l) {
        super(c, l);
        for (IRecipeStorage storage : BakerRecipes.getRecipes()) {
            for (ItemStack stack : storage.getInput()) {
                this.keepX.put(arg_0 -> ((ItemStack)stack).func_77969_a(arg_0), new Tuple((Object)128, (Object)true));
            }
        }
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return BAKER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        super.registerBlockPosition(block, pos, world);
        if (block instanceof BlockFurnace && !this.furnaces.containsKey(pos)) {
            this.addToFurnaces(pos);
        }
        this.markDirty();
    }

    public void addToFurnaces(BlockPos pos) {
        this.furnaces.put(pos, null);
    }

    @Override
    @NotNull
    public AbstractJob createJob(CitizenData citizen) {
        return new JobBaker(citizen);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        this.tasks.clear();
        super.readFromNBT(compound);
        NBTTagList taskTagList = compound.func_150295_c(TAG_TASKS, 10);
        for (int i = 0; i < taskTagList.func_74745_c(); ++i) {
            NBTTagCompound taskCompound = taskTagList.func_150305_b(i);
            ProductState state = ProductState.values()[taskCompound.func_74762_e(TAG_STATE)];
            ArrayList<BakingProduct> bakingProducts = new ArrayList<BakingProduct>();
            NBTTagList productTagList = taskCompound.func_150295_c(TAG_PRODUCTS, 10);
            for (int j = 0; j < productTagList.func_74745_c(); ++j) {
                NBTTagCompound productCompound = taskTagList.func_150305_b(i);
                BakingProduct bakingProduct = BakingProduct.createFromNBT(productCompound);
                bakingProducts.add(bakingProduct);
            }
            this.tasks.put(state, bakingProducts);
        }
        NBTTagList furnaceTagList = compound.func_150295_c(TAG_FURNACES, 10);
        for (int i = 0; i < furnaceTagList.func_74745_c(); ++i) {
            NBTTagCompound furnaceCompound = furnaceTagList.func_150305_b(i);
            BlockPos pos = BlockPosUtil.readFromNBT(furnaceCompound, TAG_FURNACE_POS);
            BakingProduct bakingProduct = BakingProduct.createFromNBT(furnaceCompound);
            this.furnaces.put(pos, bakingProduct);
        }
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagList tasksTagList = new NBTTagList();
        for (Map.Entry<ProductState, List<BakingProduct>> entry : this.tasks.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74768_a(TAG_STATE, ((ProductState)((Object)entry.getKey())).ordinal());
            NBTTagList productsTaskList = new NBTTagList();
            for (BakingProduct bakingProduct : (List)entry.getValue()) {
                NBTTagCompound productCompound = new NBTTagCompound();
                bakingProduct.writeToNBT(productCompound);
            }
            nBTTagCompound.func_74782_a(TAG_PRODUCTS, (NBTBase)productsTaskList);
            tasksTagList.func_74742_a((NBTBase)nBTTagCompound);
        }
        compound.func_74782_a(TAG_TASKS, (NBTBase)tasksTagList);
        NBTTagList furnacesTagList = new NBTTagList();
        for (Map.Entry entry : this.furnaces.entrySet()) {
            NBTTagCompound furnaceCompound = new NBTTagCompound();
            BlockPosUtil.writeToNBT(furnaceCompound, TAG_FURNACE_POS, (BlockPos)entry.getKey());
            if (entry.getValue() != null) {
                ((BakingProduct)entry.getValue()).writeToNBT(furnaceCompound);
            }
            furnacesTagList.func_74742_a((NBTBase)furnaceCompound);
        }
        compound.func_74782_a(TAG_FURNACES, (NBTBase)furnacesTagList);
        NBTTagList recipesTagList = new NBTTagList();
    }

    @Override
    @NotNull
    public String getJobName() {
        return BAKER;
    }

    @Override
    public void onWorldTick(@NotNull TickEvent.WorldTickEvent event) {
        super.onWorldTick(event);
        if (!Colony.shallUpdate(event.world, 320)) {
            return;
        }
        this.checkFurnaces();
    }

    private void checkFurnaces() {
        World worldObj = this.getColony().getWorld();
        if (worldObj == null) {
            return;
        }
        ArrayList<Map.Entry<BlockPos, BakingProduct>> copyOfList = new ArrayList<Map.Entry<BlockPos, BakingProduct>>(this.getFurnacesWithProduct().entrySet());
        for (Map.Entry entry : copyOfList) {
            if (!worldObj.func_175667_e((BlockPos)entry.getKey())) {
                return;
            }
            IBlockState furnace = worldObj.func_180495_p((BlockPos)entry.getKey());
            if (!(furnace.func_177230_c() instanceof BlockFurnace)) {
                if (worldObj.func_175625_s((BlockPos)entry.getKey()) instanceof TileEntityFurnace) {
                    return;
                }
                Log.getLogger().warn(this.getColony().getName() + " Removed furnace at: " + entry.getKey() + " because it went missing!");
                this.removeFromFurnaces((BlockPos)entry.getKey());
                continue;
            }
            BakingProduct bakingProduct = (BakingProduct)entry.getValue();
            if (bakingProduct != null && bakingProduct.getState() == ProductState.BAKING) {
                bakingProduct.increaseBakingProgress();
                worldObj.func_175656_a((BlockPos)entry.getKey(), Blocks.field_150470_am.func_176223_P().func_177226_a((IProperty)BlockFurnace.field_176447_a, furnace.func_177229_b((IProperty)BlockFurnace.field_176447_a)));
                continue;
            }
            worldObj.func_175656_a((BlockPos)entry.getKey(), Blocks.field_150460_al.func_176223_P().func_177226_a((IProperty)BlockFurnace.field_176447_a, furnace.func_177229_b((IProperty)BlockFurnace.field_176447_a)));
        }
    }

    public Map<BlockPos, BakingProduct> getFurnacesWithProduct() {
        return Collections.unmodifiableMap(this.furnaces);
    }

    public void removeFromFurnaces(BlockPos pos) {
        this.furnaces.remove(pos);
    }

    public void clearFurnaces() {
        this.furnaces.clear();
    }

    public void removeProductFromFurnace(BlockPos pos) {
        this.furnaces.replace(pos, null);
    }

    public List<BlockPos> getFurnaces() {
        return new ArrayList<BlockPos>(this.furnaces.keySet());
    }

    public Map<ProductState, List<BakingProduct>> getTasks() {
        return Collections.unmodifiableMap(new HashMap<ProductState, List<BakingProduct>>(this.tasks));
    }

    public void addToTasks(ProductState state, BakingProduct bakingProduct) {
        if (this.tasks.containsKey((Object)state)) {
            this.tasks.get((Object)state).add(bakingProduct);
        } else {
            ArrayList<BakingProduct> bakingProducts = new ArrayList<BakingProduct>();
            bakingProducts.add(bakingProduct);
            this.tasks.put(state, bakingProducts);
        }
        this.markDirty();
    }

    public void removeFromTasks(ProductState state, BakingProduct bakingProduct) {
        if (this.tasks.containsKey((Object)state)) {
            this.tasks.get((Object)state).remove(bakingProduct);
            if (this.tasks.get((Object)state).isEmpty()) {
                this.tasks.remove((Object)state);
            }
            this.markDirty();
        }
    }

    public void putInFurnace(BlockPos currentFurnace, BakingProduct bakingProduct) {
        this.furnaces.replace(currentFurnace, bakingProduct);
    }

    @Override
    public boolean canCraftComplexRecipes() {
        return true;
    }

    public static class View
    extends AbstractFilterableListsView {
        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutBaker(this);
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getPrimarySkill() {
            return AbstractBuildingWorker.Skill.INTELLIGENCE;
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getSecondarySkill() {
            return AbstractBuildingWorker.Skill.DEXTERITY;
        }
    }
}

