/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.blockout.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.HiringMode;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.requestsystem.resolvers.BuildingRequestResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PrivateWorkerCraftingProductionResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PrivateWorkerCraftingRequestResolver;
import com.minecolonies.coremod.network.messages.BuildingHiringModeMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuildingWorker
extends AbstractBuilding {
    public static final int WOOD_HUT_LEVEL = 0;
    protected final List<IToken> recipes = new ArrayList<IToken>();
    private HiringMode hiringMode = HiringMode.DEFAULT;

    public AbstractBuildingWorker(@NotNull Colony c, BlockPos l) {
        super(c, l);
    }

    @NotNull
    public abstract AbstractJob createJob(CitizenData var1);

    public boolean isItemStackInRequest(@Nullable ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        for (CitizenData data : this.getAssignedCitizen()) {
            for (IRequest request : this.getOpenRequests(data)) {
                for (ItemStack deliveryStack : request.getDeliveries()) {
                    if (!deliveryStack.func_185136_b(stack)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void setHiringMode(HiringMode hiringMode) {
        this.hiringMode = hiringMode;
        this.markDirty();
    }

    public HiringMode getHiringMode() {
        return this.hiringMode;
    }

    @Override
    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>> toKeep = new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>(super.getRequiredItemsAndAmount());
        toKeep.put(ItemStackUtils.CAN_EAT, (Tuple<Integer, Boolean>)new Tuple((Object)(this.getBuildingLevel() * 2), (Object)true));
        return toKeep;
    }

    @Nullable
    public IRecipeStorage getFirstRecipe(ItemStack stack) {
        for (IToken token : this.recipes) {
            IRecipeStorage storage = (IRecipeStorage)ColonyManager.getRecipeManager().getRecipes().get((Object)token);
            if (storage == null || !storage.getPrimaryOutput().func_77969_a(stack)) continue;
            return storage;
        }
        return null;
    }

    @Nullable
    public IRecipeStorage getFirstRecipe(Predicate<ItemStack> stackPredicate) {
        for (IToken token : this.recipes) {
            IRecipeStorage storage = (IRecipeStorage)ColonyManager.getRecipeManager().getRecipes().get((Object)token);
            if (storage == null || !stackPredicate.test(storage.getPrimaryOutput())) continue;
            return storage;
        }
        return null;
    }

    public IRecipeStorage getFirstFullFillableRecipe(ItemStack tempStack) {
        for (IToken token : this.recipes) {
            List<IItemHandler> handlers;
            IRecipeStorage storage = (IRecipeStorage)ColonyManager.getRecipeManager().getRecipes().get((Object)token);
            if (storage == null || !storage.getPrimaryOutput().func_77969_a(tempStack) || !storage.canFullFillRecipe((handlers = this.getHandlers()).toArray(new IItemHandler[handlers.size()]))) continue;
            return storage;
        }
        return null;
    }

    public IRecipeStorage getFirstFullFillableRecipe(Predicate<ItemStack> stackPredicate) {
        for (IToken token : this.recipes) {
            List<IItemHandler> handlers;
            IRecipeStorage storage = (IRecipeStorage)ColonyManager.getRecipeManager().getRecipes().get((Object)token);
            if (storage == null || !stackPredicate.test(storage.getPrimaryOutput()) || !storage.canFullFillRecipe((handlers = this.getHandlers()).toArray(new IItemHandler[handlers.size()]))) continue;
            return storage;
        }
        return null;
    }

    public boolean fullFillRecipe(IRecipeStorage storage) {
        List<IItemHandler> handlers = this.getHandlers();
        return storage.fullfillRecipe(handlers);
    }

    public void switchIndex(int i, int j) {
        if (i < this.recipes.size() && j < this.recipes.size() && i >= 0 && j >= 0) {
            IToken storage = this.recipes.get(i);
            this.recipes.set(i, this.recipes.get(j));
            this.recipes.set(j, storage);
        }
    }

    public boolean canRecipeBeAdded(IToken ignored) {
        return AbstractBuildingWorker.canBuildingCanLearnMoreRecipes(this.getBuildingLevel(), this.getRecipes().size());
    }

    public List<IToken> getRecipes() {
        return new ArrayList<IToken>(this.recipes);
    }

    public List<IItemHandler> getHandlers() {
        Colony colony = this.getColony();
        if (this.getAssignedEntities().isEmpty() || colony == null || colony.getWorld() == null) {
            return Collections.emptyList();
        }
        ArrayList<IItemHandler> handlers = new ArrayList<IItemHandler>();
        for (CitizenData workerEntity : this.getAssignedCitizen()) {
            handlers.add((IItemHandler)new InvWrapper((IInventory)workerEntity.getInventory()));
        }
        handlers.add((IItemHandler)new InvWrapper((IInventory)this.getTileEntity()));
        for (BlockPos pos : this.getAdditionalCountainers()) {
            TileEntity entity = colony.getWorld().func_175625_s(pos);
            if (entity == null) continue;
            handlers.addAll(InventoryUtils.getItemHandlersFromProvider((ICapabilityProvider)entity));
        }
        return handlers;
    }

    @Override
    public boolean assignCitizen(CitizenData citizen) {
        if (!super.assignCitizen(citizen)) {
            Log.getLogger().warn("Unable to assign citizen:" + citizen.getName() + " to building:" + this.getSchematicName() + " jobname:" + this.getJobName());
            return false;
        }
        if (citizen != null) {
            citizen.setWorkBuilding(this);
            this.colony.getProgressManager().progressEmploy(this.colony.getCitizenManager().getCitizens().stream().filter(citizenData -> citizenData.getJob() != null).collect(Collectors.toList()).size());
        }
        return true;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (compound.func_74764_b("worker")) {
            try {
                NBTTagList workersTagList = compound.func_150295_c("worker", 10);
                for (int i = 0; i < workersTagList.func_74745_c(); ++i) {
                    CitizenData data = workersTagList.func_150305_b(i).func_74764_b("id") ? this.getColony().getCitizenManager().getCitizen(workersTagList.func_150305_b(i).func_74762_e("id")) : (workersTagList.func_150305_b(i).func_74764_b("workerId") ? this.getColony().getCitizenManager().getCitizen(workersTagList.func_150305_b(i).func_74762_e("workerId")) : null);
                    if (data == null) continue;
                    this.assignCitizen(data);
                }
            }
            catch (Exception e) {
                MineColonies.getLogger().warn("Warning: Updating data structures:", (Throwable)e);
                CitizenData worker = this.getColony().getCitizenManager().getCitizen(compound.func_74762_e("worker"));
                this.assignCitizen(worker);
            }
        }
        this.hiringMode = HiringMode.values()[compound.func_74762_e("buildingHiringMode")];
        this.recipes.clear();
        NBTTagList recipesTags = compound.func_150295_c("recipes", 10);
        this.recipes.addAll(NBTUtils.streamCompound(recipesTags).map(recipeCompound -> (IToken)StandardFactoryController.getInstance().deserialize((NBTTagCompound)recipeCompound)).collect(Collectors.toList()));
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagList workersTagList = new NBTTagList();
        for (CitizenData data : this.getAssignedCitizen()) {
            if (data == null) continue;
            NBTTagCompound idCompound = new NBTTagCompound();
            idCompound.func_74768_a("workerId", data.getId());
            workersTagList.func_74742_a((NBTBase)idCompound);
        }
        compound.func_74782_a("worker", (NBTBase)workersTagList);
        compound.func_74768_a("buildingHiringMode", this.hiringMode.ordinal());
        NBTTagList recipesTagList = this.recipes.stream().map(iToken -> StandardFactoryController.getInstance().serialize(iToken)).collect(NBTUtils.toNBTTagList());
        compound.func_74782_a("recipes", (NBTBase)recipesTagList);
    }

    @Override
    public void onWakeUp() {
    }

    public boolean addRecipe(IToken token) {
        if (this.canRecipeBeAdded(token)) {
            this.recipes.add(token);
            this.markDirty();
            return true;
        }
        return false;
    }

    public void removeRecipe(IToken token) {
        this.recipes.remove(token);
        this.markDirty();
    }

    @Override
    public void onWorldTick(@NotNull TickEvent.WorldTickEvent event) {
        CitizenData joblessCitizen;
        super.onWorldTick(event);
        if (!Colony.shallUpdate(event.world, 20)) {
            return;
        }
        if (!this.isFull() && (this.getBuildingLevel() > 0 && this.isBuilt() || this instanceof BuildingBuilder) && (this.hiringMode == HiringMode.DEFAULT && !this.getColony().isManualHiring() || this.hiringMode == HiringMode.AUTO) && (joblessCitizen = this.getColony().getCitizenManager().getJoblessCitizen()) != null) {
            this.assignCitizen(joblessCitizen);
        }
    }

    @Override
    public void removeCitizen(CitizenData citizen) {
        if (this.isCitizenAssigned(citizen)) {
            super.removeCitizen(citizen);
            citizen.setWorkBuilding(null);
            this.cancelAllRequestsOfCitizen(citizen);
        }
    }

    @NotNull
    public abstract String getJobName();

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeInt(this.getAssignedCitizen().size());
        for (CitizenData data : this.getAssignedCitizen()) {
            buf.writeInt(data == null ? 0 : data.getId());
        }
        ArrayList<IRecipeStorage> storages = new ArrayList<IRecipeStorage>();
        for (IToken token : new ArrayList<IToken>(this.recipes)) {
            IRecipeStorage storage = (IRecipeStorage)ColonyManager.getRecipeManager().getRecipes().get((Object)token);
            if (storage == null) {
                this.removeRecipe(token);
                continue;
            }
            storages.add(storage);
        }
        buf.writeInt(storages.size());
        for (IRecipeStorage storage : storages) {
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)StandardFactoryController.getInstance().serialize(storage));
        }
        buf.writeBoolean(this.canCraftComplexRecipes());
        buf.writeInt(this.hiringMode.ordinal());
    }

    public int getMaxToolLevel() {
        if (this.getBuildingLevel() >= this.getMaxBuildingLevel()) {
            return 32;
        }
        if (this.getBuildingLevel() <= 0) {
            return 0;
        }
        return this.getBuildingLevel() - 0;
    }

    public boolean canWorkDuringTheRain() {
        return this.getBuildingLevel() >= 5;
    }

    @Override
    public ImmutableCollection<IRequestResolver<?>> createResolvers() {
        return ImmutableList.of((Object)new BuildingRequestResolver(this.getRequester().getRequesterLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)), (Object)new PrivateWorkerCraftingRequestResolver(this.getRequester().getRequesterLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)), (Object)new PrivateWorkerCraftingProductionResolver(this.getRequester().getRequesterLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
    }

    public boolean canCraftComplexRecipes() {
        return false;
    }

    public static boolean canBuildingCanLearnMoreRecipes(int buildingLevel, int learnedRecipes) {
        return Math.pow(2.0, buildingLevel) >= (double)(learnedRecipes + 1);
    }

    public static class View
    extends AbstractBuildingView {
        private final List<Integer> workerIDs = new ArrayList<Integer>();
        private final List<IRecipeStorage> recipes = new ArrayList<IRecipeStorage>();
        private boolean canCraftComplexRecipes;
        private HiringMode hiringMode;

        public View(ColonyView c, @NotNull BlockPos l) {
            super(c, l);
        }

        public List<Integer> getWorkerId() {
            return new ArrayList<Integer>(this.workerIDs);
        }

        public void addWorkerId(int workerId) {
            this.workerIDs.add(workerId);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
            int size = buf.readInt();
            this.workerIDs.clear();
            for (int i = 0; i < size; ++i) {
                this.workerIDs.add(buf.readInt());
            }
            this.recipes.clear();
            int recipesSize = buf.readInt();
            for (int i = 0; i < recipesSize; ++i) {
                IRecipeStorage storage = (IRecipeStorage)StandardFactoryController.getInstance().deserialize(ByteBufUtils.readTag((ByteBuf)buf));
                if (storage == null) continue;
                this.recipes.add(storage);
            }
            this.canCraftComplexRecipes = buf.readBoolean();
            this.hiringMode = HiringMode.values()[buf.readInt()];
        }

        public List<IRecipeStorage> getRecipes() {
            return new ArrayList<IRecipeStorage>(this.recipes);
        }

        public void removeRecipe(int i) {
            if (i < this.recipes.size() && i >= 0) {
                this.recipes.remove(i);
            }
        }

        public void switchIndex(int i, int j) {
            if (i < this.recipes.size() && j < this.recipes.size() && i >= 0 && j >= 0) {
                IRecipeStorage storage = this.recipes.get(i);
                this.recipes.set(i, this.recipes.get(j));
                this.recipes.set(j, storage);
            }
        }

        @NotNull
        public Skill getPrimarySkill() {
            return Skill.PLACEHOLDER;
        }

        @NotNull
        public Skill getSecondarySkill() {
            return Skill.PLACEHOLDER;
        }

        public void removeWorkerId(int id) {
            for (int i = 0; i < this.workerIDs.size(); ++i) {
                int workerId = this.workerIDs.get(i);
                if (workerId != id) continue;
                this.workerIDs.remove(i);
            }
        }

        public boolean hasEnoughWorkers() {
            return !this.workerIDs.isEmpty();
        }

        public boolean canCraftComplexRecipes() {
            return this.canCraftComplexRecipes;
        }

        public boolean canRecipeBeAdded() {
            return AbstractBuildingWorker.canBuildingCanLearnMoreRecipes(this.getBuildingLevel(), this.getRecipes().size());
        }

        public HiringMode getHiringMode() {
            return this.hiringMode;
        }

        public void setHiringMode(HiringMode hiringMode) {
            this.hiringMode = hiringMode;
            MineColonies.getNetwork().sendToServer((IMessage)new BuildingHiringModeMessage(this, hiringMode));
        }
    }

    public static enum Skill {
        STRENGTH,
        ENDURANCE,
        CHARISMA,
        INTELLIGENCE,
        DEXTERITY,
        PLACEHOLDER;

    }
}

