/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ButtonHandler;
import com.minecolonies.blockout.controls.TextField;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import org.jetbrains.annotations.NotNull;

public class WindowHutNameEntry
extends Window
implements ButtonHandler {
    private static final int MAX_NAME_LENGTH = 15;
    private static final String HUT_NAME_RESOURCE_SUFFIX = ":gui/windowhutnameentry.xml";
    private final AbstractBuildingView building;

    public WindowHutNameEntry(AbstractBuildingView b) {
        super("minecolonies:gui/windowhutnameentry.xml");
        this.building = b;
    }

    @Override
    public void onOpened() {
        this.findPaneOfTypeByID("name", TextField.class).setText(this.building.getCustomName());
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        if (button.getID().equals("done")) {
            String name = this.findPaneOfTypeByID("name", TextField.class).getText();
            if (name.length() > 15) {
                name = name.substring(0, 15);
                LanguageHandler.sendPlayerMessage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, "com.minecolonies.coremod.gui.name.tooLong", name);
            }
            this.building.setCustomName(name);
        } else if (!button.getID().equals("cancel")) {
            return;
        }
        if (this.building != null) {
            this.building.openGui(false);
        }
    }
}

