/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.views.View;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractHutFilterableLists;
import com.minecolonies.coremod.client.gui.ViewFilterableList;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingComposter;
import com.minecolonies.coremod.items.ModItems;
import com.minecolonies.coremod.network.messages.ComposterRetrievalMessage;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class WindowHutComposter
extends AbstractHutFilterableLists {
    private static final String BUTTON_TOGGLE_RETRIEVE_DIRT = "retrieveDirt";
    private static final String PAGE_ITEMS_VIEW = "compostables";
    private static final String RESOURCE_STRING = ":gui/windowhutcomposter.xml";
    private final BuildingComposter.View ownBuilding;

    public WindowHutComposter(BuildingComposter.View building) {
        super(building, "minecolonies:gui/windowhutcomposter.xml", new Tuple[0]);
        ViewFilterableList window = new ViewFilterableList(this.findPaneOfTypeByID(PAGE_ITEMS_VIEW, View.class), this, building, LanguageHandler.format("com.minecolonies.gui.workerHuts.composter.compostables", new Object[0]), PAGE_ITEMS_VIEW, false);
        this.views.put(PAGE_ITEMS_VIEW, window);
        this.ownBuilding = building;
        this.setupRetrieveDirtButton(this.findPaneOfTypeByID(BUTTON_TOGGLE_RETRIEVE_DIRT, Button.class));
        this.registerButton(BUTTON_TOGGLE_RETRIEVE_DIRT, this::switchReplant);
    }

    @Override
    public List<? extends ItemStorage> getBlockList(Predicate<ItemStack> filterPredicate, String id) {
        return ColonyManager.getCompatibilityManager().getCopyOfCompostableItems().stream().filter(storage -> filterPredicate.test(storage.getItemStack())).collect(Collectors.toList());
    }

    private void setupRetrieveDirtButton(Button button) {
        if (this.ownBuilding.retrieveDirtFromCompostBin) {
            button.setLabel(LanguageHandler.format(Blocks.field_150346_d.func_149732_F(), new Object[0]));
        } else {
            button.setLabel(LanguageHandler.format(ModItems.compost.func_77653_i(new ItemStack(ModItems.compost)), new Object[0]));
        }
    }

    private void switchReplant(Button retrieve) {
        BuildingComposter.View composter = this.ownBuilding;
        composter.retrieveDirtFromCompostBin = !composter.retrieveDirtFromCompostBin;
        this.setupRetrieveDirtButton(retrieve);
        MineColonies.getNetwork().sendToServer((IMessage)new ComposterRetrievalMessage(composter, composter.retrieveDirtFromCompostBin));
    }

    @Override
    public String getBuildingName() {
        return "com.minecolonies.coremod.gui.workerHuts.composter";
    }
}

