/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.blocks;

import com.minecolonies.coremod.blocks.AbstractBlockMinecoloniesHorizontal;
import com.minecolonies.coremod.blocks.ModBlocks;
import com.minecolonies.coremod.blocks.types.BarrelType;
import com.minecolonies.coremod.creativetab.ModCreativeTabs;
import com.minecolonies.coremod.tileentities.TileEntityBarrel;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemColored;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;

public class BlockBarrel
extends AbstractBlockMinecoloniesHorizontal<BlockBarrel>
implements ITileEntityProvider {
    public static final PropertyEnum<BarrelType> VARIANT = PropertyEnum.func_177709_a((String)"variant", BarrelType.class);
    private static final float BLOCK_HARDNESS = 5.0f;
    private static final String BLOCK_NAME = "barrel_block";
    private static final float RESISTANCE = 1.0f;
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.5, 1.0);

    public BlockBarrel() {
        super(Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(VARIANT, (Comparable)((Object)BarrelType.ZERO)));
        this.initBlock();
    }

    @Override
    public void registerItemBlock(IForgeRegistry<Item> registry) {
        registry.register(new ItemColored((Block)this, true).setRegistryName(this.getRegistryName()));
    }

    private void initBlock() {
        this.setRegistryName("minecolonies".toLowerCase() + ":" + BLOCK_NAME);
        this.func_149663_c(String.format("%s.%s", "minecolonies".toLowerCase(), BLOCK_NAME));
        this.func_149647_a(ModCreativeTabs.MINECOLONIES);
        this.func_149711_c(5.0f);
        this.func_149752_b(1.0f);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null) {
            if (!worldIn.field_72995_K) {
                ((TileEntityBarrel)te).updateTick(worldIn, pos, state, rand);
            }
            ((TileEntityBarrel)te).updateBlock(worldIn, state);
        }
    }

    @NotNull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, VARIANT});
    }

    public TileEntity createTileEntity(@NotNull World world, @NotNull IBlockState state) {
        return new TileEntityBarrel();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack = playerIn.field_71071_by.func_70448_g();
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityBarrel && !worldIn.field_72995_K) {
            ((TileEntityBarrel)te).useBarrel(worldIn, playerIn, itemstack, state, pos);
            ((TileEntityBarrel)te).updateBlock(worldIn, state);
        }
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_180651_a(IBlockState state) {
        return ((BarrelType)((Object)this.func_176223_P().func_177229_b(VARIANT))).getMetadata();
    }

    protected ItemStack func_180643_i(@NotNull IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, ((BarrelType)((Object)state.func_177229_b(VARIANT))).getMetadata());
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    @NotNull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return BOUNDING_BOX;
    }

    @Deprecated
    @NotNull
    public IBlockState func_185499_a(@NotNull IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Deprecated
    @NotNull
    public IBlockState func_185471_a(@NotNull IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @NotNull
    public IBlockState getStateForPlacement(@NotNull World world, @NotNull BlockPos pos, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @NotNull EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    @Deprecated
    public IBlockState func_176221_a(@NotNull IBlockState state, @NotNull IBlockAccess worldIn, @NotNull BlockPos pos) {
        TileEntity entity = worldIn.func_175625_s(pos);
        if (!(entity instanceof TileEntityBarrel)) {
            return super.func_176221_a(state, worldIn, pos);
        }
        return BlockBarrel.changeStateOverFullness((TileEntityBarrel)entity, worldIn, state, pos);
    }

    public static IBlockState changeStateOverFullness(TileEntityBarrel entity, IBlockAccess worldIn, IBlockState blockState, BlockPos pos) {
        TileEntityBarrel te = entity;
        BarrelType type = BarrelType.byMetadata((int)Math.round((double)te.getItems() / 12.8));
        if (type.equals((Object)BarrelType.ZERO) && te.getItems() > 0) {
            type = BarrelType.TWENTY;
        } else if (te.getItems() == 64) {
            type = BarrelType.WORKING;
        }
        if (te.isDone()) {
            type = BarrelType.DONE;
        }
        return blockState.func_177226_a(VARIANT, (Comparable)((Object)type)).func_177226_a((IProperty)FACING, blockState.func_177229_b((IProperty)FACING));
    }

    @Nullable
    public TileEntity func_149915_a(World world, int i) {
        return new TileEntityBarrel();
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c().getClass() != BlockAir.class && worldIn.func_180495_p(pos.func_177977_b()).func_177230_c().getClass() != BlockBarrel.class;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (worldIn.func_175623_d(pos.func_177977_b()) || worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == ModBlocks.blockBarrel) {
            this.func_176226_b(worldIn, pos, this.func_176223_P(), 0);
            worldIn.func_175698_g(pos);
        }
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }
}

