/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.compatibility;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.compatibility.ICompatibilityManager;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.BlockStateStorage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.NBTUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockRedstoneOre;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Tuple;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.NotNull;

public class CompatibilityManager
implements ICompatibilityManager {
    private final Map<BlockStateStorage, ItemStorage> leavesToSaplingMap = new HashMap<BlockStateStorage, ItemStorage>();
    private final List<ItemStorage> saplings = new ArrayList<ItemStorage>();
    private final List<IProperty> leafCompareWithoutProperties = ImmutableList.of((Object)checkDecay, (Object)decayable, (Object)DYN_PROP_HYDRO);
    private static final PropertyBool checkDecay = PropertyBool.func_177716_a((String)"check_decay");
    private static final PropertyBool decayable = PropertyBool.func_177716_a((String)"decayable");
    public static final PropertyInteger DYN_PROP_HYDRO = PropertyInteger.func_177719_a((String)"hydro", (int)1, (int)4);
    private final Set<Block> oreBlocks = new HashSet<Block>();
    private final Set<ItemStorage> smeltableOres = new HashSet<ItemStorage>();
    private final Set<ItemStorage> compostableItems = new HashSet<ItemStorage>();
    private final Set<ItemStorage> fuel = new HashSet<ItemStorage>();
    private final Set<ItemStorage> food = new HashSet<ItemStorage>();
    private final List<ItemStorage> luckyOres = new ArrayList<ItemStorage>();
    private final Map<ItemStorage, ItemStorage> crusherModes = new HashMap<ItemStorage, ItemStorage>();
    private final List<Tuple<ItemStorage, Double>> sifterMeshes = new ArrayList<Tuple<ItemStorage, Double>>();
    private final List<ItemStorage> sievableBlocks = new ArrayList<ItemStorage>();
    private final Map<ItemStorage, Map<ItemStorage, List<ItemStorage>>> sieveResult = new HashMap<ItemStorage, Map<ItemStorage, List<ItemStorage>>>();
    private boolean discoveredAlready = false;
    private static final Random random = new Random();
    private static ImmutableList<ItemStack> allBlocks = ImmutableList.builder().build();

    @Override
    public List<Tuple<ItemStorage, Double>> getMeshes() {
        return new ArrayList<Tuple<ItemStorage, Double>>(this.sifterMeshes);
    }

    @Override
    public ArrayList<ItemStorage> getSievableBlock() {
        return new ArrayList<ItemStorage>(this.sievableBlocks);
    }

    @Override
    public ItemStack getRandomSieveResultForMeshAndBlock(ItemStorage mesh, ItemStorage block) {
        if (this.sieveResult.containsKey(mesh) && this.sieveResult.get(mesh).containsKey(block)) {
            List<ItemStorage> drops = this.sieveResult.get(mesh).get(block);
            Collections.shuffle(drops);
            return drops.get(0).getItemStack();
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void discover() {
        this.discoverBlockList();
        this.discoverSaplings();
        this.discoverOres();
        Log.getLogger().info("Finished discovering oreBlocks");
        this.discoverCompostableItems();
        this.discoverLuckyOres();
        this.discoverCrusherModes();
        this.discoverSifting();
        this.discoverFood();
        this.discoverFuel();
        this.discoveredAlready = true;
    }

    private void discoverBlockList() {
        allBlocks = ImmutableList.copyOf((Collection)StreamSupport.stream(Spliterators.spliteratorUnknownSize(Item.field_150901_e.iterator(), 16), false).flatMap(item -> {
            NonNullList stacks = NonNullList.func_191196_a();
            try {
                item.func_150895_a(CreativeTabs.field_78027_g, stacks);
            }
            catch (Exception ex) {
                Log.getLogger().warn("Failed to get sub items from: " + item.getRegistryName(), (Throwable)ex);
            }
            return stacks.stream();
        }).collect(Collectors.toList()));
    }

    @Override
    public List<ItemStack> getBlockList() {
        return allBlocks;
    }

    @Override
    public boolean isCompost(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        for (String string : Configurations.gameplay.listOfCompostableItems) {
            if (itemStack.func_77973_b().getRegistryName().toString().equals(string)) {
                return true;
            }
            for (int id : OreDictionary.getOreIDs((ItemStack)itemStack)) {
                if (!OreDictionary.getOreName((int)id).equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isLuckyBlock(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        for (String string : Configurations.gameplay.luckyBlocks) {
            if (itemStack.func_77973_b().getRegistryName().toString().equals(string)) {
                return true;
            }
            for (int id : OreDictionary.getOreIDs((ItemStack)itemStack)) {
                if (!OreDictionary.getOreName((int)id).equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemStack getSaplingForLeaf(IBlockState block) {
        BlockStateStorage tempLeaf = new BlockStateStorage(block, this.leafCompareWithoutProperties, true);
        if (this.leavesToSaplingMap.containsKey(tempLeaf)) {
            return this.leavesToSaplingMap.get(tempLeaf).getItemStack();
        }
        return null;
    }

    @Override
    public List<ItemStorage> getCopyOfSaplings() {
        return new ArrayList<ItemStorage>(this.saplings);
    }

    @Override
    public Set<ItemStorage> getFuel() {
        return this.fuel;
    }

    @Override
    public Set<ItemStorage> getFood() {
        return this.food;
    }

    @Override
    public Set<ItemStorage> getSmeltableOres() {
        return this.smeltableOres;
    }

    @Override
    public List<ItemStorage> getCopyOfCompostableItems() {
        return ImmutableList.copyOf(this.compostableItems);
    }

    @Override
    public boolean isOre(IBlockState block) {
        if (block.func_177230_c() instanceof BlockOre || block.func_177230_c() instanceof BlockRedstoneOre) {
            return true;
        }
        return this.oreBlocks.contains(block.func_177230_c());
    }

    @Override
    public boolean isOre(@NotNull ItemStack stack) {
        int[] ids;
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return false;
        }
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
            if (!OreDictionary.getOreName((int)id).contains("ore")) continue;
            return !FurnaceRecipes.func_77602_a().func_151395_a(stack).func_190926_b();
        }
        return false;
    }

    @Override
    public boolean isMineableOre(@NotNull ItemStack stack) {
        int[] ids;
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return false;
        }
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
            if (!OreDictionary.getOreName((int)id).contains("ore")) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<ItemStorage, ItemStorage> getCrusherModes() {
        return ImmutableMap.builder().putAll(this.crusherModes).build();
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        NBTTagList saplingsLeavesTagList = this.leavesToSaplingMap.entrySet().stream().filter(entry -> entry.getKey() != null).map(entry -> CompatibilityManager.writeLeafSaplingEntryToNBT(((BlockStateStorage)entry.getKey()).getState(), (ItemStorage)entry.getValue())).collect(NBTUtils.toNBTTagList());
        compound.func_74782_a("tagSapLeaves", (NBTBase)saplingsLeavesTagList);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        NBTUtils.streamCompound(compound.func_150295_c("tagSapLeaves", 10)).map(CompatibilityManager::readLeafSaplingEntryFromNBT).filter(key -> !this.leavesToSaplingMap.containsKey(key.func_76341_a()) && !this.leavesToSaplingMap.containsValue(key.func_76340_b())).forEach(key -> this.leavesToSaplingMap.put(new BlockStateStorage((IBlockState)key.func_76341_a(), this.leafCompareWithoutProperties, true), (ItemStorage)key.func_76340_b()));
    }

    @Override
    public void connectLeafToSapling(IBlockState leaf, ItemStack stack) {
        BlockStateStorage store = new BlockStateStorage(leaf, this.leafCompareWithoutProperties, true);
        if (!this.leavesToSaplingMap.containsKey(store)) {
            this.leavesToSaplingMap.put(store, new ItemStorage(stack, false, true));
        }
    }

    @Override
    public boolean isDiscoveredAlready() {
        return this.discoveredAlready;
    }

    @Override
    public ItemStack getRandomLuckyOre() {
        if (random.nextInt(100) <= Configurations.gameplay.luckyBlockChance) {
            Collections.shuffle(this.luckyOres);
            return this.luckyOres.get(0).getItemStack().func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    private void discoverOres() {
        if (this.smeltableOres.isEmpty()) {
            this.smeltableOres.addAll((Collection<ItemStorage>)ImmutableList.copyOf((Collection)allBlocks.stream().filter(this::isOre).map(ItemStorage::new).collect(Collectors.toList())));
        }
        if (this.oreBlocks.isEmpty()) {
            this.oreBlocks.addAll((Collection<Block>)ImmutableList.copyOf((Collection)allBlocks.stream().filter(this::isMineableOre).filter(stack -> ItemStackUtils.isEmpty(stack) == false && stack.func_77973_b() instanceof ItemBlock).map(stack -> ((ItemBlock)stack.func_77973_b()).func_179223_d()).collect(Collectors.toList())));
            for (String oreString : Configurations.gameplay.extraOres) {
                Block block = Block.func_149684_b((String)oreString);
                if (block == null || this.oreBlocks.contains(block)) continue;
                this.oreBlocks.add(block);
            }
        }
        Log.getLogger().info("Finished discovering Ores");
    }

    private void discoverSaplings() {
        for (ItemStack saps : OreDictionary.getOres((String)"treeSapling")) {
            if (saps.func_77981_g()) {
                for (CreativeTabs tabs : CreativeTabs.field_78032_a) {
                    NonNullList list = NonNullList.func_191196_a();
                    saps.func_77973_b().func_150895_a(tabs, list);
                    for (ItemStack stack : list) {
                        if (ItemStackUtils.isEmpty(stack).booleanValue() || this.leavesToSaplingMap.containsValue(new ItemStorage(stack, false, true)) || this.saplings.contains(new ItemStorage(stack, false, true))) continue;
                        this.saplings.add(new ItemStorage(stack, false, true));
                    }
                }
                continue;
            }
            if (!Compatibility.isDynamicTreeSapling(saps) || ItemStackUtils.isEmpty(saps).booleanValue() || this.leavesToSaplingMap.containsValue(new ItemStorage(saps, false, true)) || this.saplings.contains(new ItemStorage(saps, false, true))) continue;
            this.saplings.add(new ItemStorage(saps, false, true));
        }
        Log.getLogger().info("Finished discovering saplings");
    }

    private void discoverCompostableItems() {
        if (this.compostableItems.isEmpty()) {
            this.compostableItems.addAll((Collection<ItemStorage>)ImmutableList.copyOf((Collection)allBlocks.stream().filter(this::isCompost).map(ItemStorage::new).collect(Collectors.toList())));
        }
        Log.getLogger().info("Finished discovering compostables");
    }

    private void discoverFuel() {
        if (this.fuel.isEmpty()) {
            this.fuel.addAll((Collection<ItemStorage>)ImmutableList.copyOf((Collection)allBlocks.stream().filter(TileEntityFurnace::func_145954_b).map(ItemStorage::new).collect(Collectors.toList())));
        }
        Log.getLogger().info("Finished discovering fuel");
    }

    private void discoverFood() {
        if (this.food.isEmpty()) {
            this.food.addAll((Collection<ItemStorage>)ImmutableList.copyOf((Collection)allBlocks.stream().filter(ItemStackUtils.ISFOOD.or(ItemStackUtils.ISCOOKABLE)).map(ItemStorage::new).collect(Collectors.toList())));
        }
        Log.getLogger().info("Finished discovering food");
    }

    private void discoverLuckyOres() {
        if (this.luckyOres.isEmpty()) {
            for (String ore : Configurations.gameplay.luckyOres) {
                Item item;
                String[] split = ore.split("!");
                if (split.length < 2) {
                    Log.getLogger().warn("Wrong configured ore: " + ore);
                    continue;
                }
                int meta = 0;
                if (split.length == 3) {
                    try {
                        meta = Integer.parseInt(split[1]);
                    }
                    catch (NumberFormatException ex) {
                        Log.getLogger().warn("Ore has invalid metadata: " + ore);
                    }
                }
                if ((item = Item.func_111206_d((String)split[0])) == null || item == Items.field_190931_a) {
                    Log.getLogger().warn("Invalid lucky block: " + ore);
                    continue;
                }
                ItemStack stack = new ItemStack(item, 1, meta);
                try {
                    int rarity = Integer.parseInt(split[split.length - 1]);
                    for (int i = 0; i < rarity; ++i) {
                        this.luckyOres.add(new ItemStorage(stack));
                    }
                }
                catch (NumberFormatException ex) {
                    Log.getLogger().warn("Ore has invalid rarity: " + ore);
                }
            }
        }
        Log.getLogger().info("Finished discovering lucky oreBlocks");
    }

    /*
     * WARNING - void declaration
     */
    private void discoverSifting() {
        void var3_7;
        String string;
        void var3_5;
        String[] stringArray = Configurations.gameplay.sifterMeshes;
        int n = stringArray.length;
        boolean bl = false;
        while (var3_5 < n) {
            string = stringArray[var3_5];
            String[] mesh = string.split(",");
            if (mesh.length != 2) {
                Log.getLogger().warn("Couldn't parse the mesh: " + string);
            } else {
                try {
                    double probability = Double.parseDouble(mesh[1]);
                    String[] item = mesh[0].split(":");
                    String itemName = item[0] + ":" + item[1];
                    Item theItem = Item.func_111206_d((String)itemName);
                    if (theItem == null) {
                        Log.getLogger().warn("Couldn't find item for mesh: " + string);
                    } else {
                        ItemStack stack = new ItemStack(theItem, 1, item.length > 2 ? Integer.parseInt(item[2]) : 0);
                        this.sifterMeshes.add((Tuple<ItemStorage, Double>)new Tuple((Object)new ItemStorage(stack), (Object)probability));
                    }
                }
                catch (NumberFormatException ex) {
                    Log.getLogger().warn("Couldn't retrieve probability for mesh: " + string, (Throwable)ex);
                }
            }
            ++var3_5;
        }
        stringArray = Configurations.gameplay.siftableBlocks;
        n = stringArray.length;
        boolean bl2 = false;
        while (var3_7 < n) {
            string = stringArray[var3_7];
            try {
                String[] item = string.split(":");
                String itemName = item[0] + ":" + item[1];
                Item theItem = Item.func_111206_d((String)itemName);
                if (theItem == null) {
                    Log.getLogger().warn("Couldn't find item for siftable block: " + string);
                } else {
                    ItemStack stack = new ItemStack(theItem, 1, item.length > 2 ? Integer.parseInt(item[2]) : 0);
                    this.sievableBlocks.add(new ItemStorage(stack));
                }
            }
            catch (NumberFormatException ex) {
                Log.getLogger().warn("Couldn't retrieve the metadata for siftable block: " + string, (Throwable)ex);
            }
            ++var3_7;
        }
        HashMap tempDrops = new HashMap();
        for (String string2 : Configurations.gameplay.sifterDrops) {
            String[] drop = string2.split(",");
            if (drop.length != 4) {
                Log.getLogger().warn("Required Parameters: keyBlock, keyMesh, item, probability, not met in: " + string2);
                continue;
            }
            try {
                int block = Integer.parseInt(drop[0]);
                if (this.sievableBlocks.size() < block) {
                    Log.getLogger().warn("Trying to add siftresult for not configured block.");
                    continue;
                }
                ItemStorage blockStorage = this.sievableBlocks.get(block);
                int mesh = Integer.parseInt(drop[1]);
                if (this.sifterMeshes.size() < mesh) {
                    Log.getLogger().warn("Trying to add siftresult for not configured mesh.");
                    continue;
                }
                ItemStorage meshStorage = (ItemStorage)this.sifterMeshes.get(mesh).func_76341_a();
                String[] item = drop[2].split(":");
                String itemName = item[0] + ":" + item[1];
                Item theItem = Item.func_111206_d((String)itemName);
                if (theItem == null) {
                    Log.getLogger().warn("Couldn't find item for siftable block: " + string2);
                    continue;
                }
                ItemStack stack = new ItemStack(theItem, 1, item.length > 2 ? Integer.parseInt(item[2]) : 0);
                double probability = Double.parseDouble(drop[3]);
                Map map = tempDrops.containsKey(meshStorage) ? (Map)tempDrops.get(meshStorage) : new HashMap();
                Map drops = map.containsKey(blockStorage) ? (Map)map.get(blockStorage) : new HashMap();
                drops.put(new ItemStorage(stack), probability);
                map.put(blockStorage, drops);
                tempDrops.put(meshStorage, map);
            }
            catch (NumberFormatException ex) {
                Log.getLogger().warn("Couldn't retrieve block or mesh for drop: " + string2, (Throwable)ex);
            }
        }
        for (Map.Entry entry : tempDrops.entrySet()) {
            for (Map.Entry blockEntry : ((Map)entry.getValue()).entrySet()) {
                ArrayList<ItemStorage> theDrops = new ArrayList<ItemStorage>();
                double probabilitySum = 0.0;
                for (Map.Entry drops : ((Map)blockEntry.getValue()).entrySet()) {
                    ItemStorage storage = (ItemStorage)drops.getKey();
                    double probability = (Double)drops.getValue();
                    probabilitySum += probability;
                    int i = 0;
                    while ((double)i < probability) {
                        theDrops.add(storage);
                        ++i;
                    }
                }
                ItemStorage airStorage = new ItemStorage(ItemStack.field_190927_a);
                int i = 0;
                while ((double)i < 100.0 - probabilitySum) {
                    theDrops.add(airStorage);
                    ++i;
                }
                Map<Object, List<ItemStorage>> map = this.sieveResult.containsKey(entry.getKey()) ? this.sieveResult.get(entry.getKey()) : new HashMap();
                map.put(blockEntry.getKey(), theDrops);
                this.sieveResult.put((ItemStorage)entry.getKey(), (Map<ItemStorage, List<ItemStorage>>)map);
            }
        }
        Log.getLogger().info("Finished initiating sifter config");
    }

    private void discoverCrusherModes() {
        for (String string : Configurations.gameplay.crusherProduction) {
            String[] split = string.split("!");
            if (split.length != 2) {
                Log.getLogger().warn("Invalid crusher mode setting: " + string);
                continue;
            }
            String[] firstItem = split[0].split(":");
            String[] secondItem = split[1].split(":");
            Item item1 = Item.func_111206_d((String)(firstItem[0] + ":" + firstItem[1]));
            Item item2 = Item.func_111206_d((String)(secondItem[0] + ":" + secondItem[1]));
            try {
                int meta2;
                int meta1 = firstItem.length > 2 ? Integer.parseInt(firstItem[2]) : 0;
                int n = meta2 = secondItem.length > 2 ? Integer.parseInt(secondItem[2]) : 0;
                if (item1 == null || item2 == null) {
                    Log.getLogger().warn("Invalid crusher mode setting: " + string);
                    continue;
                }
                ItemStorage storage1 = new ItemStorage(new ItemStack(item1, 2, meta1));
                ItemStorage storage2 = new ItemStorage(new ItemStack(item2, 1, meta2));
                this.crusherModes.put(storage1, storage2);
            }
            catch (NumberFormatException ex) {
                Log.getLogger().warn("Error getting metaData", (Throwable)ex);
            }
        }
    }

    private static NBTTagCompound writeLeafSaplingEntryToNBT(IBlockState state, ItemStorage storage) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTUtil.func_190009_a((NBTTagCompound)compound, (IBlockState)state);
        storage.getItemStack().func_77955_b(compound);
        return compound;
    }

    private static Tuple<IBlockState, ItemStorage> readLeafSaplingEntryFromNBT(NBTTagCompound compound) {
        return new Tuple((Object)NBTUtil.func_190008_d((NBTTagCompound)compound), (Object)new ItemStorage(new ItemStack(compound), false, true));
    }
}

