/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.requestable;

import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.IToolType;
import com.minecolonies.api.util.constant.ToolType;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public class Tool
implements IDeliverable {
    private static final String NBT_TYPE = "Type";
    private static final String NBT_MIN_LEVEL = "MinLevel";
    private static final String NBT_MAX_LEVEL = "MaxLevel";
    private static final String NBT_RESULT = "Result";
    @NotNull
    private final IToolType toolClass;
    @NotNull
    private final Integer minLevel;
    @NotNull
    private final Integer maxLevel;
    @NotNull
    private ItemStack result = ItemStackUtils.EMPTY;

    public Tool(@NotNull IToolType toolClass, @NotNull Integer minLevel, @NotNull Integer maxLevel) {
        this(toolClass, minLevel, maxLevel, ItemStackUtils.EMPTY);
    }

    public Tool(@NotNull IToolType toolClass, @NotNull Integer minLevel, @NotNull Integer maxLevel, @NotNull ItemStack result) {
        this.toolClass = toolClass;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
        this.result = result;
    }

    @NotNull
    public static NBTTagCompound serialize(IFactoryController controller, Tool tool) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a(NBT_TYPE, tool.getToolClass().getName());
        compound.func_74768_a(NBT_MIN_LEVEL, tool.getMinLevel().intValue());
        compound.func_74768_a(NBT_MAX_LEVEL, tool.getMaxLevel().intValue());
        compound.func_74782_a(NBT_RESULT, (NBTBase)tool.getResult().serializeNBT());
        return compound;
    }

    @NotNull
    public IToolType getToolClass() {
        return this.toolClass;
    }

    @NotNull
    public Integer getMinLevel() {
        return this.minLevel;
    }

    @NotNull
    public Integer getMaxLevel() {
        return this.maxLevel;
    }

    @Override
    @NotNull
    public ItemStack getResult() {
        return this.result;
    }

    @NotNull
    public static Tool deserialize(IFactoryController controller, NBTTagCompound nbt) {
        IToolType type = ToolType.getToolType(nbt.func_74779_i(NBT_TYPE));
        Integer minLevel = nbt.func_74762_e(NBT_MIN_LEVEL);
        Integer maxLevel = nbt.func_74762_e(NBT_MAX_LEVEL);
        ItemStack result = new ItemStack(nbt.func_74775_l(NBT_RESULT));
        return new Tool(type, minLevel, maxLevel, result);
    }

    @Override
    public boolean matches(@NotNull ItemStack stack) {
        boolean toolTypeResult;
        boolean bl = toolTypeResult = ItemStackUtils.isEmpty(stack) == false && stack.func_190916_E() >= 1 && this.getToolClasses(stack).stream().filter(s -> this.getToolClass().getName().equalsIgnoreCase((String)s)).map(ToolType::getToolType).filter(t -> t != ToolType.NONE).anyMatch(t -> ItemStackUtils.hasToolLevel(stack, t, this.getMinLevel(), this.getMaxLevel()));
        if (!toolTypeResult) {
            return stack.func_77973_b() instanceof ItemHoe && this.toolClass.equals(ToolType.HOE) || stack.func_77973_b() instanceof ItemShield && this.toolClass.equals(ToolType.SHIELD);
        }
        return toolTypeResult;
    }

    private Set<String> getToolClasses(ItemStack stack) {
        HashSet<String> set = new HashSet<String>();
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return set;
        }
        set.addAll(stack.func_77973_b().getToolClasses(stack));
        if (stack.func_77973_b() instanceof ItemBow) {
            set.add("bow");
        } else if (stack.func_77973_b() instanceof ItemSword || Compatibility.isTinkersWeapon(stack)) {
            set.add("weapon");
        } else if (stack.func_77973_b() instanceof ItemHoe) {
            set.add("hoe");
        } else if (stack.func_77973_b() instanceof ItemFishingRod) {
            set.add("rod");
        } else if (stack.func_77973_b() instanceof ItemShears) {
            set.add("shears");
        } else if (stack.func_77973_b() instanceof ItemShield) {
            set.add("shield");
        } else if (stack.func_77973_b() instanceof ItemArmor) {
            ItemArmor armor = (ItemArmor)stack.func_77973_b();
            if (armor.field_77881_a == EntityEquipmentSlot.CHEST) {
                set.add("chestplate");
            } else if (armor.field_77881_a == EntityEquipmentSlot.FEET) {
                set.add("boots");
            } else if (armor.field_77881_a == EntityEquipmentSlot.HEAD) {
                set.add("helmet");
            } else if (armor.field_77881_a == EntityEquipmentSlot.LEGS) {
                set.add("leggings");
            }
        }
        return set;
    }

    public boolean isArmor() {
        return this.toolClass == ToolType.HELMET || this.toolClass == ToolType.LEGGINGS || this.toolClass == ToolType.CHESTPLATE || this.toolClass == ToolType.BOOTS;
    }

    @Override
    public int getCount() {
        return 1;
    }

    @Override
    public void setResult(@NotNull ItemStack result) {
        this.result = result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tool)) {
            return false;
        }
        Tool tool = (Tool)o;
        if (!this.getToolClass().equals(tool.getToolClass())) {
            return false;
        }
        if (!this.getMinLevel().equals(tool.getMinLevel())) {
            return false;
        }
        if (!this.getMaxLevel().equals(tool.getMaxLevel())) {
            return false;
        }
        return ItemStackUtils.compareItemStacksIgnoreStackSize(this.getResult(), tool.getResult());
    }

    public int hashCode() {
        int result1 = this.getToolClass().hashCode();
        result1 = 31 * result1 + this.getMinLevel().hashCode();
        result1 = 31 * result1 + this.getMaxLevel().hashCode();
        result1 = 31 * result1 + this.getResult().hashCode();
        return result1;
    }
}

