/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.request;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.manager.AssigningStrategy;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IRequest<R extends IRequestable> {
    default public AssigningStrategy getStrategy() {
        return AssigningStrategy.PRIORITY_BASED;
    }

    public <T extends IToken> T getToken();

    @NotNull
    public TypeToken<? extends R> getRequestType();

    @NotNull
    public RequestState getState();

    public void setState(@NotNull IRequestManager var1, @NotNull RequestState var2);

    @NotNull
    public IRequester getRequester();

    @NotNull
    public R getRequest();

    @Nullable
    public R getResult();

    public void setResult(@NotNull R var1);

    public boolean hasResult();

    @Nullable
    public <T extends IToken> T getParent();

    public <T extends IToken> void setParent(@Nullable T var1);

    public boolean hasParent();

    public <T extends IToken> void addChild(@NotNull T var1);

    public <T extends IToken> void addChildren(T ... var1);

    public <T extends IToken> void addChildren(@NotNull Collection<T> var1);

    public <T extends IToken> void removeChild(@NotNull T var1);

    public <T extends IToken> void removeChildren(T ... var1);

    public <T extends IToken> void removeChildren(@NotNull Collection<T> var1);

    public boolean hasChildren();

    @NotNull
    public ImmutableCollection<IToken> getChildren();

    public void childStateUpdated(@NotNull IRequestManager var1, @NotNull IToken var2);

    public boolean canBeDelivered();

    @NotNull
    public ImmutableList<ItemStack> getDeliveries();

    public void overrideCurrentDeliveries(@NotNull ImmutableList<ItemStack> var1);

    public void addDelivery(@NotNull ItemStack var1);

    @NotNull
    public ITextComponent getShortDisplayString();

    @NotNull
    public ITextComponent getLongDisplayString();

    @NotNull
    public List<ItemStack> getDisplayStacks();

    @NotNull
    public ResourceLocation getDisplayIcon();

    @NotNull
    public <T> Optional<T> getRequestOfType(Class<T> var1);
}

