/*
 * Decompiled with CFR 0.152.
 */
package openmods.model.eval;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.property.IUnlistedProperty;

public class EvalModelState {
    public static final IUnlistedProperty<EvalModelState> PROPERTY = new IUnlistedProperty<EvalModelState>(){

        public String valueToString(EvalModelState value) {
            return value.args.toString();
        }

        public boolean isValid(EvalModelState value) {
            return true;
        }

        public Class<EvalModelState> getType() {
            return EvalModelState.class;
        }

        public String getName() {
            return "eval_args";
        }
    };
    public static final EvalModelState EMPTY = new EvalModelState();
    private final Map<String, Float> args;
    private final boolean shortLived;

    private EvalModelState(Map<String, Float> args, boolean quickCache) {
        this.args = ImmutableMap.copyOf(args);
        this.shortLived = quickCache;
    }

    private EvalModelState() {
        this((Map<String, Float>)ImmutableMap.of(), false);
    }

    public static EvalModelState create() {
        return EMPTY;
    }

    public static EvalModelState create(Map<String, Float> args) {
        return EvalModelState.create(args, false);
    }

    public static EvalModelState create(Map<String, Float> args, boolean shortLived) {
        return new EvalModelState(args, false);
    }

    public EvalModelState withArg(String name, float value) {
        HashMap copy = Maps.newHashMap(this.args);
        copy.put(name, Float.valueOf(value));
        return new EvalModelState(copy, this.shortLived);
    }

    public EvalModelState withArg(String name, float value, boolean isRapidChanging) {
        HashMap copy = Maps.newHashMap(this.args);
        copy.put(name, Float.valueOf(value));
        return new EvalModelState(copy, this.shortLived || isRapidChanging);
    }

    public EvalModelState markShortLived() {
        return new EvalModelState(this.args, true);
    }

    Map<String, Float> getArgs() {
        return this.args;
    }

    boolean isShortLived() {
        return this.shortLived;
    }
}

