/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import openmods.gui.component.BaseComponent;
import org.lwjgl.opengl.GL11;

public class GuiComponentItemStack
extends BaseComponent {
    @Nonnull
    private final ItemStack stack;
    private boolean drawTooltip;
    private final float scale;
    private final int size;
    private final List<String> displayName;

    public GuiComponentItemStack(int x, int y, @Nonnull ItemStack stack, boolean drawTooltip, float scale) {
        super(x, y);
        this.stack = stack;
        this.drawTooltip = drawTooltip;
        this.scale = scale;
        this.size = MathHelper.func_76141_d((float)(16.0f * scale));
        this.displayName = ImmutableList.of((Object)stack.func_82833_r());
    }

    @Override
    public int getWidth() {
        return this.size;
    }

    @Override
    public int getHeight() {
        return this.size;
    }

    @Override
    public void render(int offsetX, int offsetY, int mouseX, int mouseY) {
        if (this.scale != 1.0f) {
            GL11.glPushMatrix();
            GL11.glScalef((float)this.scale, (float)this.scale, (float)1.0f);
        }
        this.drawItemStack(this.stack, (int)((float)(this.x + offsetX) / this.scale), (int)((float)(this.y + offsetY) / this.scale), "");
        if (this.scale != 1.0f) {
            GL11.glPopMatrix();
        }
    }

    @Override
    public void renderOverlay(int offsetX, int offsetY, int mouseX, int mouseY) {
        if (this.drawTooltip && this.isMouseOver(mouseX, mouseY)) {
            this.drawHoveringText(this.displayName, offsetX + mouseX, offsetY + mouseY);
        }
    }
}

