/*
 * Decompiled with CFR 0.152.
 */
package mod.flatcoloredblocks.commands;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import mod.flatcoloredblocks.FlatColoredBlocks;
import mod.flatcoloredblocks.block.BlockFlatColored;
import mod.flatcoloredblocks.block.ConversionHSV2RGB;
import mod.flatcoloredblocks.block.ItemBlockFlatColored;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class ExportFCBlockList
extends CommandBase {
    public String func_71517_b() {
        return "flatcoloredblock_export_list";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender sender) {
        return "flatcoloredblocks.commands.export_list.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        File configPath = FlatColoredBlocks.instance.config.getFilePath();
        String path = configPath.getParentFile().getAbsolutePath() + File.separator + "flatcoloredblocks.csv";
        try {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            BlockFlatColored.getAllShades(list);
            FileWriter writer = new FileWriter(path);
            writer.write("Shade Number,Name,HEX,Red,Blue,Green,Hue,Saturation,Value,Opacity,Light Value\n");
            for (ItemStack is : list) {
                Item it = is.func_77973_b();
                if (!(it instanceof ItemBlockFlatColored)) continue;
                IBlockState state = ((ItemBlockFlatColored)it).getStateFromStack(is);
                BlockFlatColored blk = ((ItemBlockFlatColored)it).getColoredBlock();
                int hsv = blk.hsvFromState(state);
                int rgb = ConversionHSV2RGB.toRGB(hsv);
                int h = hsv >> 16 & 0xFF;
                int s = hsv >> 8 & 0xFF;
                int v = hsv & 0xFF;
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                StringBuilder line = new StringBuilder();
                line.append(blk.getShadeNumber(state));
                line.append(",\"");
                line.append(is.func_82833_r().replace("\"", "\"\""));
                line.append("\",");
                line.append("#").append(ItemBlockFlatColored.hexPad(Integer.toString(r, 16))).append(ItemBlockFlatColored.hexPad(Integer.toString(g, 16))).append(ItemBlockFlatColored.hexPad(Integer.toString(b, 16)));
                line.append(",");
                line.append(r);
                line.append(",");
                line.append(g);
                line.append(",");
                line.append(b);
                line.append(",");
                line.append(360 * h / 255);
                line.append(",");
                line.append(100 * s / 255);
                line.append(",");
                line.append(100 * v / 255);
                line.append(",");
                line.append(blk.opacity);
                line.append(",");
                line.append(blk.field_149784_t);
                line.append("\n");
                writer.write(line.toString());
            }
            writer.close();
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("flatcoloredblocks.commands.export_list.savedfile", new Object[]{path}));
        }
        catch (IOException e) {
            throw new CommandException("flatcoloredblocks.commands.export_list.unabletosave", new Object[]{path});
        }
    }
}

