/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.util;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.config.ConfigHandler;
import com.chaosthedude.naturescompass.util.SearchResult;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.ChunkGeneratorSettings;

public class BiomeUtils {
    public static List<Biome> getAllowedBiomes() {
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        for (Biome biome : Biome.field_185377_q) {
            if (biome == null || BiomeUtils.biomeIsBlacklisted(biome)) continue;
            biomes.add(biome);
        }
        return biomes;
    }

    public static SearchResult searchForBiome(World world, ItemStack stack, Biome biome, BlockPos startPos) {
        if (stack.func_190926_b() || stack.func_77973_b() != NaturesCompass.naturesCompass) {
            return null;
        }
        int sampleSpace = ConfigHandler.sampleSpaceModifier * BiomeUtils.getBiomeSize(world);
        int maxDistance = ConfigHandler.distanceModifier * BiomeUtils.getBiomeSize(world);
        if (maxDistance <= 0 || sampleSpace <= 0) {
            return new SearchResult(0, 0, maxDistance, 0, false);
        }
        BiomeProvider biomeProvider = world.func_72959_q();
        int direction = -1;
        int samples = 0;
        int nextLength = sampleSpace;
        int x = startPos.func_177958_n();
        int z = startPos.func_177952_p();
        while (nextLength / 2 <= maxDistance && samples <= ConfigHandler.maxSamples) {
            int fixedDirection = direction == -1 ? -1 : direction % 4;
            for (int i = 0; i < nextLength; i += sampleSpace) {
                if (fixedDirection == 0) {
                    x += sampleSpace;
                } else if (fixedDirection == 1) {
                    z -= sampleSpace;
                } else if (fixedDirection == 2) {
                    x -= sampleSpace;
                } else if (fixedDirection == 3) {
                    z += sampleSpace;
                }
                Biome[] biomes = biomeProvider.func_76931_a(null, x, z, 1, 1, false);
                if (biomes[0] == biome) {
                    return new SearchResult(x, z, nextLength / 2, samples, true);
                }
                ++samples;
            }
            if (direction >= 0) {
                nextLength += sampleSpace;
            }
            ++direction;
        }
        return new SearchResult(0, 0, nextLength / 2, samples, false);
    }

    public static int getBiomeSize(World world) {
        String settings = world.func_72912_H().func_82571_y();
        return ChunkGeneratorSettings.Factory.func_177865_a((String)settings).func_177864_b().field_177780_G;
    }

    public static int getDistanceToBiome(EntityPlayer player, int x, int z) {
        return (int)player.func_70011_f((double)x, player.field_70163_u, (double)z);
    }

    public static String getBiomeName(Biome biome) {
        if (biome != null && biome.func_185359_l() != null) {
            if (ConfigHandler.fixBiomeNames) {
                String original = biome.func_185359_l();
                String fixed = "";
                char pre = ' ';
                for (int i = 0; i < original.length(); ++i) {
                    char c = original.charAt(i);
                    if (Character.isUpperCase(c) && Character.isLowerCase(pre) && Character.isAlphabetic(pre)) {
                        fixed = fixed + " ";
                    }
                    fixed = fixed + String.valueOf(c);
                    pre = c;
                }
                return fixed;
            }
            return biome.func_185359_l();
        }
        return "";
    }

    public static String getBiomeName(int biomeID) {
        return BiomeUtils.getBiomeName(Biome.func_185357_a((int)biomeID));
    }

    public static boolean biomeIsBlacklisted(Biome biome) {
        List<String> biomeBlacklist = ConfigHandler.getBiomeBlacklist();
        return biomeBlacklist.contains(String.valueOf(Biome.func_185362_a((Biome)biome))) || biomeBlacklist.contains(BiomeUtils.getBiomeName(biome)) || biomeBlacklist.contains(biome.func_185359_l());
    }
}

