/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.world;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fml.common.IWorldGenerator;
import vazkii.quark.world.feature.NetherFossils;

public class NetherFossilGenerator
implements IWorldGenerator {
    private static final ResourceLocation STRUCTURE_SPINE_01 = new ResourceLocation("fossils/fossil_spine_01");
    private static final ResourceLocation STRUCTURE_SPINE_02 = new ResourceLocation("fossils/fossil_spine_02");
    private static final ResourceLocation STRUCTURE_SPINE_03 = new ResourceLocation("fossils/fossil_spine_03");
    private static final ResourceLocation STRUCTURE_SPINE_04 = new ResourceLocation("fossils/fossil_spine_04");
    private static final ResourceLocation STRUCTURE_SKULL_01 = new ResourceLocation("fossils/fossil_skull_01");
    private static final ResourceLocation STRUCTURE_SKULL_02 = new ResourceLocation("fossils/fossil_skull_02");
    private static final ResourceLocation STRUCTURE_SKULL_03 = new ResourceLocation("fossils/fossil_skull_03");
    private static final ResourceLocation STRUCTURE_SKULL_04 = new ResourceLocation("fossils/fossil_skull_04");
    private static final ResourceLocation[] FOSSILS = new ResourceLocation[]{STRUCTURE_SPINE_01, STRUCTURE_SPINE_02, STRUCTURE_SPINE_03, STRUCTURE_SPINE_04, STRUCTURE_SKULL_01, STRUCTURE_SKULL_02, STRUCTURE_SKULL_03, STRUCTURE_SKULL_04};

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.func_177495_o() && random.nextInt(NetherFossils.chance) == 0) {
            IBlockState stateAt;
            int x = chunkX * 16 + random.nextInt(16) + 8;
            int z = chunkZ * 16 + random.nextInt(16) + 8;
            int y = 40;
            BlockPos pos = new BlockPos(x, y, z);
            do {
                stateAt = world.func_180495_p(pos);
                pos = pos.func_177977_b();
            } while (stateAt.func_177230_c().isAir(stateAt, (IBlockAccess)world, pos) && pos.func_177956_o() > 0);
            if (stateAt.func_177230_c() == Blocks.field_150353_l) {
                this.generateFossil(world, random, pos.func_177981_b(random.nextInt(2)));
            }
        }
    }

    private void generateFossil(World world, Random random, BlockPos pos) {
        MinecraftServer minecraftserver = world.func_73046_m();
        Rotation[] rotations = Rotation.values();
        Rotation rotation = rotations[random.nextInt(rotations.length)];
        int i = random.nextInt(FOSSILS.length);
        TemplateManager templatemanager = world.func_72860_G().func_186340_h();
        Template template = templatemanager.func_186237_a(minecraftserver, FOSSILS[i]);
        ChunkPos chunkpos = new ChunkPos(pos);
        StructureBoundingBox structureboundingbox = new StructureBoundingBox(chunkpos.func_180334_c(), 0, chunkpos.func_180333_d(), chunkpos.func_180332_e(), 256, chunkpos.func_180330_f());
        PlacementSettings placementsettings = new PlacementSettings().func_186220_a(rotation).func_186223_a(structureboundingbox).func_189950_a(random);
        BlockPos basePos = template.func_189961_a(pos, Mirror.NONE, rotation);
        placementsettings.func_189946_a(1.0f);
        template.func_189962_a(world, basePos, placementsettings, 20);
    }
}

