/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.vanity.client.emotes;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.quark.vanity.client.emotes.CustomEmoteDescriptor;
import vazkii.quark.vanity.client.emotes.EmoteBase;
import vazkii.quark.vanity.client.emotes.EmoteDescriptor;
import vazkii.quark.vanity.client.emotes.ModelAccessor;
import vazkii.quark.vanity.client.emotes.TemplateSourcedEmote;

@SideOnly(value=Side.CLIENT)
public final class EmoteHandler {
    public static final String CUSTOM_EMOTE_NAMESPACE = "quark_custom";
    public static final String CUSTOM_PREFIX = "custom:";
    public static final Map<String, EmoteDescriptor> emoteMap = new LinkedHashMap<String, EmoteDescriptor>();
    private static final Map<String, EmoteBase> playerEmotes = new HashMap<String, EmoteBase>();
    private static int count;

    public static void addEmote(String name, Class<? extends EmoteBase> clazz) {
        EmoteDescriptor desc = new EmoteDescriptor(clazz, name, name, count++);
        emoteMap.put(name, desc);
    }

    public static void addEmote(String name) {
        EmoteHandler.addEmote(name, TemplateSourcedEmote.class);
    }

    public static void addCustomEmote(String name) {
        String reg = CUSTOM_PREFIX + name;
        CustomEmoteDescriptor desc = new CustomEmoteDescriptor(name, reg, count++);
        emoteMap.put(reg, desc);
    }

    public static void putEmote(AbstractClientPlayer player, String emoteName, int tier) {
        if (emoteMap.containsKey(emoteName)) {
            EmoteHandler.putEmote(player, emoteMap.get(emoteName), tier);
        }
    }

    public static void putEmote(AbstractClientPlayer player, EmoteDescriptor desc, int tier) {
        String name = player.func_70005_c_();
        if (desc == null) {
            return;
        }
        if (desc.getTier() > tier) {
            return;
        }
        ModelBiped model = EmoteHandler.getPlayerModel(player);
        ModelBiped armorModel = EmoteHandler.getPlayerArmorModel(player);
        ModelBiped armorLegModel = EmoteHandler.getPlayerArmorLegModel(player);
        if (model != null && armorModel != null && armorLegModel != null) {
            EmoteBase emote = desc.instantiate((EntityPlayer)player, model, armorModel, armorLegModel);
            emote.startAllTimelines();
            playerEmotes.put(name, emote);
        }
    }

    public static void updateEmotes(Entity e) {
        if (e instanceof AbstractClientPlayer) {
            EmoteBase emote;
            boolean done;
            AbstractClientPlayer player = (AbstractClientPlayer)e;
            String name = player.func_70005_c_();
            EmoteHandler.resetPlayer(player);
            if (playerEmotes.containsKey(name) && !(done = (emote = playerEmotes.get(name)).isDone())) {
                emote.update();
            }
        }
    }

    public static void preRender(EntityPlayer player) {
        EmoteBase emote = EmoteHandler.getPlayerEmote(player);
        if (emote != null) {
            GlStateManager.func_179094_E();
            emote.rotateAndOffset();
        }
    }

    public static void postRender(EntityPlayer player) {
        EmoteBase emote = EmoteHandler.getPlayerEmote(player);
        if (emote != null) {
            GlStateManager.func_179121_F();
        }
    }

    public static void onRenderTick(Minecraft mc) {
        WorldClient world = mc.field_71441_e;
        if (world == null) {
            return;
        }
        for (EntityPlayer player : world.field_73010_i) {
            EmoteHandler.updatePlayerStatus(player);
        }
    }

    private static void updatePlayerStatus(EntityPlayer e) {
        if (e instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)e;
            String name = player.func_70005_c_();
            if (playerEmotes.containsKey(name)) {
                EmoteBase emote = playerEmotes.get(name);
                boolean done = emote.isDone();
                if (done) {
                    playerEmotes.remove(name);
                    EmoteHandler.resetPlayer(player);
                } else {
                    emote.update();
                }
            } else {
                EmoteHandler.resetPlayer(player);
            }
        }
    }

    public static EmoteBase getPlayerEmote(EntityPlayer player) {
        return playerEmotes.get(player.func_70005_c_());
    }

    private static RenderPlayer getRenderPlayer(AbstractClientPlayer player) {
        Minecraft mc = Minecraft.func_71410_x();
        RenderManager manager = mc.func_175598_ae();
        return (RenderPlayer)manager.getSkinMap().get(player.func_175154_l());
    }

    private static ModelBiped getPlayerModel(AbstractClientPlayer player) {
        RenderPlayer render = EmoteHandler.getRenderPlayer(player);
        if (render != null) {
            return render.func_177087_b();
        }
        return null;
    }

    private static ModelBiped getPlayerArmorModel(AbstractClientPlayer player) {
        RenderPlayer render = EmoteHandler.getRenderPlayer(player);
        if (render == null) {
            return null;
        }
        List list = (List)ObfuscationReflectionHelper.getPrivateValue(RenderLivingBase.class, (Object)render, (String)"field_177097_h");
        for (Object aList : list) {
            if (!(aList instanceof LayerBipedArmor)) continue;
            return (ModelBiped)ObfuscationReflectionHelper.getPrivateValue(LayerArmorBase.class, (Object)((LayerArmorBase)aList), (String)"field_177186_d");
        }
        return null;
    }

    private static ModelBiped getPlayerArmorLegModel(AbstractClientPlayer player) {
        RenderPlayer render = EmoteHandler.getRenderPlayer(player);
        if (render == null) {
            return null;
        }
        List list = (List)ObfuscationReflectionHelper.getPrivateValue(RenderLivingBase.class, (Object)render, (String)"field_177097_h");
        for (Object aList : list) {
            if (!(aList instanceof LayerBipedArmor)) continue;
            return (ModelBiped)ObfuscationReflectionHelper.getPrivateValue(LayerArmorBase.class, (Object)((LayerArmorBase)aList), (String)"field_177189_c");
        }
        return null;
    }

    private static void resetPlayer(AbstractClientPlayer player) {
        EmoteHandler.resetModel(EmoteHandler.getPlayerModel(player));
        EmoteHandler.resetModel(EmoteHandler.getPlayerArmorModel(player));
        EmoteHandler.resetModel(EmoteHandler.getPlayerArmorLegModel(player));
    }

    private static void resetModel(ModelBiped model) {
        if (model != null) {
            EmoteHandler.resetPart(model.field_78116_c);
            EmoteHandler.resetPart(model.field_178720_f);
            EmoteHandler.resetPart(model.field_78115_e);
            EmoteHandler.resetPart(model.field_178724_i);
            EmoteHandler.resetPart(model.field_178723_h);
            EmoteHandler.resetPart(model.field_178722_k);
            EmoteHandler.resetPart(model.field_178721_j);
            if (model instanceof ModelPlayer) {
                ModelPlayer playerModel = (ModelPlayer)model;
                EmoteHandler.resetPart(playerModel.field_178730_v);
                EmoteHandler.resetPart(playerModel.field_178734_a);
                EmoteHandler.resetPart(playerModel.field_178732_b);
                EmoteHandler.resetPart(playerModel.field_178733_c);
                EmoteHandler.resetPart(playerModel.field_178731_d);
                EmoteHandler.resetPart(ModelAccessor.getEarsModel(playerModel));
            }
            ModelAccessor.INSTANCE.resetModel(model);
        }
    }

    private static void resetPart(ModelRenderer part) {
        if (part != null) {
            part.field_82907_q = 0.0f;
            part.field_82908_p = 0.0f;
            part.field_82906_o = 0.0f;
            part.field_78808_h = 0.0f;
        }
    }
}

