/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.feature;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.ShapedOreRecipe;
import vazkii.arl.recipe.MultiRecipe;
import vazkii.arl.recipe.RecipeHandler;
import vazkii.quark.base.module.Feature;
import vazkii.quark.tweaks.feature.StairsMakeMore;

public class SlabsToBlocks
extends Feature {
    public static final Map<IBlockState, ItemStack> slabs = new HashMap<IBlockState, ItemStack>();
    public static int originalSize;
    private MultiRecipe multiRecipe;

    @Override
    public void setupConfig() {
        originalSize = this.loadPropInt("Vanilla stack size", "The stack size for the vanilla slab recipe, used for automatically detecting slab recipes", 6);
    }

    @Override
    public void postPreInit() {
        this.multiRecipe = new MultiRecipe(new ResourceLocation("quark", "slabs_to_blocks"));
    }

    @Override
    public void postInit() {
        ArrayList recipeList = new ArrayList(CraftingManager.field_193380_a.func_148742_b());
        for (ResourceLocation res : recipeList) {
            ItemStack outStack;
            Item outputItem;
            Block outputBlock;
            IRecipe recipe = (IRecipe)CraftingManager.field_193380_a.func_82594_a((Object)res);
            if (!(recipe instanceof ShapedRecipes) && !(recipe instanceof ShapedOreRecipe)) continue;
            NonNullList recipeItems = recipe instanceof ShapedRecipes ? ((ShapedRecipes)recipe).field_77574_d : recipe.func_192400_c();
            ItemStack output = recipe.func_77571_b();
            if (output.func_190926_b() || output.func_190916_E() != originalSize || !((outputBlock = Block.func_149634_a((Item)(outputItem = output.func_77973_b()))) instanceof BlockSlab) || (outStack = StairsMakeMore.findResult((NonNullList<Ingredient>)recipeItems, 3)).func_190926_b()) continue;
            ItemStack outCopy = outStack.func_77946_l();
            if (outCopy.func_77952_i() == Short.MAX_VALUE) {
                outCopy.func_77964_b(0);
            }
            ItemStack in = output.func_77946_l();
            in.func_190920_e(1);
            if (in.func_77973_b() instanceof ItemBlock && outCopy.func_77973_b() instanceof ItemBlock) {
                Block block = Block.func_149634_a((Item)outCopy.func_77973_b());
                slabs.put(block.func_176203_a(outCopy.func_77952_i()), in);
            }
            RecipeHandler.addShapedRecipe((MultiRecipe)this.multiRecipe, (ItemStack)outCopy, (Object[])new Object[]{"SS", Character.valueOf('S'), in});
        }
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

