/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.feature;

import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.quark.base.Quark;
import vazkii.quark.base.module.Feature;
import vazkii.quark.tweaks.base.BlockStack;
import vazkii.quark.tweaks.feature.HoeSickle;

public class RightClickHarvest
extends Feature {
    public static boolean hoeHarvest;
    public static boolean emptyHandHarvest;
    public static boolean harvestingCostsDurability;
    public static boolean doHarvestingSearch;
    public static String[] harvestableBlocks;
    public static Map<BlockStack, BlockStack> crops;
    private static boolean hasInit;
    private static Method getSeed;

    @Override
    public void setupConfig() {
        hoeHarvest = this.loadPropBool("Hoe Harvest", "Can hoes harvest crops with right click?", true);
        emptyHandHarvest = this.loadPropBool("Empty Hand Harvest", "Can players harvest crops with empty hand clicks?", true);
        harvestingCostsDurability = this.loadPropBool("Harvesting Costs Durability", "Does harvesting crops with a hoe cost durability?", false);
        doHarvestingSearch = this.loadPropBool("Add Harvestable Crops", "Should Quark look for (nonvanilla) crops, and handle them?", true);
        harvestableBlocks = this.loadPropStringList("Harvestable Crops", "Which crops can be harvested?\nFormat is: \"initial[,final]\", i.e. \"minecraft:wheat:7\" or \"minecraft:cocoa:11,minecraft:cocoa:3\"", new String[]{"minecraft:wheat:7", "minecraft:carrots:7", "minecraft:potatoes:7", "minecraft:beetroots:3", "minecraft:nether_wart:3", "minecraft:cocoa:11,minecraft:cocoa:3", "minecraft:cocoa:10,minecraft:cocoa:2", "minecraft:cocoa:9,minecraft:cocoa:1", "minecraft:cocoa:8,minecraft:cocoa:0"});
        if (hasInit) {
            this.fillCropList();
        }
    }

    @Override
    public void init() {
        hasInit = true;
        this.fillCropList();
    }

    private void fillCropList() {
        crops.clear();
        if (doHarvestingSearch) {
            ForgeRegistries.BLOCKS.getValuesCollection().stream().filter(b -> !RightClickHarvest.isVanilla((IForgeRegistryEntry)b) && b instanceof BlockCrops).forEach(b -> crops.put(new BlockStack((Block)b, ((BlockCrops)b).func_185526_g()), new BlockStack((Block)b)));
        }
        for (String harvestKey : harvestableBlocks) {
            String[] split = harvestKey.split(",", 2);
            BlockStack initial = BlockStack.fromString(split[0]);
            BlockStack result = split.length > 1 ? BlockStack.fromString(split[1]) : new BlockStack(initial.getBlock());
            crops.put(initial, result);
        }
    }

    private static void replant(World world, BlockPos pos, BlockStack inWorld, EntityPlayer player) {
        ItemStack mainHand = player.func_184614_ca();
        boolean isHoe = !mainHand.func_190926_b() && mainHand.func_77973_b() instanceof ItemHoe;
        BlockStack newBlock = crops.get(inWorld);
        NonNullList drops = NonNullList.func_191196_a();
        int fortune = HoeSickle.canFortuneApply(Enchantments.field_185308_t, mainHand) && isHoe ? EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)mainHand) : 0;
        inWorld.getBlock().getDrops(drops, (IBlockAccess)world, pos, inWorld.getState(), fortune);
        for (ItemStack stack : drops) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IPlantable) && (stack.func_77973_b() != Items.field_151100_aR || stack.func_77960_j() != EnumDyeColor.BROWN.func_176767_b())) continue;
            stack.func_190918_g(1);
            break;
        }
        ForgeEventFactory.fireBlockHarvesting((List)drops, (World)world, (BlockPos)pos, (IBlockState)inWorld.getState(), (int)fortune, (float)1.0f, (boolean)false, (EntityPlayer)player);
        boolean seedNotNull = true;
        if (inWorld.getBlock() instanceof BlockCrops) {
            try {
                Item seed;
                if (getSeed == null) {
                    getSeed = ObfuscationReflectionHelper.findMethod(BlockCrops.class, (String)"func_149866_i", Item.class, (Class[])new Class[0]);
                }
                seedNotNull = (seed = (Item)getSeed.invoke((Object)inWorld.getBlock(), new Object[0])) != null && seed != Items.field_190931_a;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                Quark.LOG.error("Failed to reflect BlockCrops", (Throwable)e);
            }
        }
        if (seedNotNull) {
            if (!world.field_72995_K) {
                world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)newBlock.getState()));
                world.func_175656_a(pos, newBlock.getState());
                for (ItemStack stack : drops) {
                    EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
                    entityItem.func_174867_a(10);
                    world.func_72838_d((Entity)entityItem);
                }
            }
        } else {
            Quark.LOG.warn("Crop definition {},{} does not work! Couldn't find a seed definition.", (Object)inWorld, (Object)newBlock);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onCropClick(PlayerInteractEvent.RightClickBlock event) {
        boolean isHoe;
        if (event.getHand() != EnumHand.MAIN_HAND) {
            return;
        }
        ItemStack mainHand = event.getEntityPlayer().func_184614_ca();
        boolean bl = isHoe = !mainHand.func_190926_b() && mainHand.func_77973_b() instanceof ItemHoe;
        if (!emptyHandHarvest && !isHoe) {
            return;
        }
        int range = HoeSickle.getRange(mainHand);
        int harvests = 0;
        for (int x = 1 - range; x < range; ++x) {
            for (int z = 1 - range; z < range; ++z) {
                BlockPos pos = event.getPos().func_177982_a(x, 0, z);
                BlockStack worldBlock = BlockStack.getStackFromPos(event.getWorld(), pos);
                if (!crops.containsKey(worldBlock)) continue;
                RightClickHarvest.replant(event.getWorld(), pos, worldBlock, event.getEntityPlayer());
                ++harvests;
            }
        }
        if (harvests > 0) {
            if (harvestingCostsDurability && isHoe && !event.getWorld().field_72995_K) {
                mainHand.func_77972_a(harvests, (EntityLivingBase)event.getEntityPlayer());
            }
            event.getEntityPlayer().func_184609_a(EnumHand.MAIN_HAND);
            event.setCanceled(true);
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public String[] getIncompatibleMods() {
        return new String[]{"harvest"};
    }

    static {
        crops = Maps.newHashMap();
    }
}

