/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.tile;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.oddities.feature.MatrixEnchanting;
import vazkii.quark.oddities.inventory.ContainerMatrixEnchanting;
import vazkii.quark.oddities.inventory.EnchantmentMatrix;
import vazkii.quark.oddities.tile.TileMatrixEnchanterBase;

public class TileMatrixEnchanter
extends TileMatrixEnchanterBase {
    public static final int OPER_ADD = 0;
    public static final int OPER_PLACE = 1;
    public static final int OPER_REMOVE = 2;
    public static final int OPER_ROTATE = 3;
    public static final int OPER_MERGE = 4;
    public static final String TAG_STACK_MATRIX = "quark:enchantingMatrix";
    private static final String TAG_MATRIX = "matrix";
    private static final String TAG_MATRIX_UUID_LESS = "uuidLess";
    private static final String TAG_MATRIX_UUID_MOST = "uuidMost";
    private static final String TAG_CHARGE = "charge";
    public EnchantmentMatrix matrix;
    private boolean matrixDirty = false;
    private UUID matrixId;
    public int bookshelfPower;
    public int enchantability;
    public int charge;

    @Override
    public void func_73660_a() {
        ItemStack lapis;
        super.func_73660_a();
        ItemStack item = this.func_70301_a(0);
        if (item.func_190926_b()) {
            this.matrix = null;
            this.matrixDirty = true;
        } else {
            this.loadMatrix(item);
            if (this.field_145850_b.func_82737_E() % 20L == 0L || this.matrixDirty) {
                this.updateEnchantPower();
            }
        }
        if (this.charge <= 0 && !this.field_145850_b.field_72995_K && !(lapis = this.func_70301_a(1)).func_190926_b()) {
            lapis.func_190918_g(1);
            this.charge += MatrixEnchanting.chargePerLapis;
            this.sync();
        }
        if (this.matrixDirty) {
            this.makeOutput();
            this.matrixDirty = false;
        }
    }

    public void onOperation(EntityPlayer player, int operation, int arg0, int arg1, int arg2) {
        if (this.matrix == null) {
            return;
        }
        switch (operation) {
            case 0: {
                this.apply(m -> this.generateAndPay((EnchantmentMatrix)m, player));
                break;
            }
            case 1: {
                this.apply(m -> m.place(arg0, arg1, arg2));
                break;
            }
            case 2: {
                this.apply(m -> m.remove(arg0));
                break;
            }
            case 3: {
                this.apply(m -> m.rotate(arg0));
                break;
            }
            case 4: {
                this.apply(m -> m.merge(arg0, arg1));
            }
        }
    }

    private void apply(Predicate<EnchantmentMatrix> oper) {
        if (oper.test(this.matrix)) {
            ItemStack item = this.func_70301_a(0);
            this.commitMatrix(item);
        }
    }

    private boolean generateAndPay(EnchantmentMatrix matrix, EntityPlayer player) {
        if (matrix.canGeneratePiece(this.bookshelfPower, this.enchantability) && matrix.validateXp(player, this.bookshelfPower)) {
            boolean creative = player.func_184812_l_();
            int cost = matrix.getNewPiecePrice();
            if ((this.charge > 0 || creative) && matrix.generatePiece(this.bookshelfPower)) {
                if (!creative) {
                    player.func_82242_a(-cost);
                }
                this.charge = Math.max(this.charge - 1, 0);
            }
        }
        return true;
    }

    private void makeOutput() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.func_70299_a(2, ItemStack.field_190927_a);
        ItemStack in = this.func_70301_a(0);
        if (!in.func_190926_b() && this.matrix != null && !this.matrix.placedPieces.isEmpty()) {
            ItemStack out = in.func_77946_l();
            boolean book = false;
            if (out.func_77973_b() == Items.field_151122_aG) {
                out = new ItemStack(Items.field_151134_bR);
                book = true;
            }
            HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
            Iterator<Object> iterator = this.matrix.placedPieces.iterator();
            while (iterator.hasNext()) {
                int n = iterator.next();
                EnchantmentMatrix.Piece p = this.matrix.pieces.get(n);
                if (p == null || p.enchant == null) continue;
                for (Enchantment o : enchantments.keySet()) {
                    if (o != p.enchant && p.enchant.func_191560_c(o) && o.func_191560_c(p.enchant)) continue;
                    return;
                }
                enchantments.put(p.enchant, p.level);
            }
            if (book) {
                for (Map.Entry entry : enchantments.entrySet()) {
                    ItemEnchantedBook.func_92115_a((ItemStack)out, (EnchantmentData)new EnchantmentData((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue()));
                }
            } else {
                EnchantmentHelper.func_82782_a(enchantments, (ItemStack)out);
                ItemNBTHelper.getNBT((ItemStack)out).func_82580_o(TAG_STACK_MATRIX);
            }
            this.func_70299_a(2, out);
        }
    }

    private void loadMatrix(ItemStack stack) {
        if (this.matrix == null || this.matrix.target != stack) {
            if (this.matrix != null) {
                this.matrixDirty = true;
            }
            this.matrix = null;
            if (stack.func_77956_u()) {
                NBTTagCompound cmp;
                this.matrix = new EnchantmentMatrix(stack, this.field_145850_b.field_73012_v);
                this.matrixDirty = true;
                this.makeUUID();
                if (ItemNBTHelper.verifyExistence((ItemStack)stack, (String)TAG_STACK_MATRIX) && (cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)TAG_STACK_MATRIX, (boolean)true)) != null) {
                    this.matrix.readFromNBT(cmp);
                }
            }
        }
    }

    private void commitMatrix(ItemStack stack) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        NBTTagCompound cmp = new NBTTagCompound();
        this.matrix.writeToNBT(cmp);
        ItemNBTHelper.setCompound((ItemStack)stack, (String)TAG_STACK_MATRIX, (NBTTagCompound)cmp);
        this.matrixDirty = true;
        this.makeUUID();
        this.sync();
    }

    private void makeUUID() {
        if (!this.field_145850_b.field_72995_K) {
            this.matrixId = UUID.randomUUID();
        }
    }

    private void updateEnchantPower() {
        ItemStack item = this.func_70301_a(0);
        if (item.func_190926_b()) {
            return;
        }
        this.enchantability = item.func_77973_b().getItemEnchantability(item);
        float power = 0.0f;
        for (int j = -1; j <= 1; ++j) {
            for (int k = -1; k <= 1; ++k) {
                if (j == 0 && k == 0 || !this.field_145850_b.func_175623_d(this.field_174879_c.func_177982_a(k, 0, j)) || !this.field_145850_b.func_175623_d(this.field_174879_c.func_177982_a(k, 1, j))) continue;
                power += ForgeHooks.getEnchantPower((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177982_a(k * 2, 0, j * 2));
                power += ForgeHooks.getEnchantPower((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177982_a(k * 2, 1, j * 2));
                if (k == 0 || j == 0) continue;
                power += ForgeHooks.getEnchantPower((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177982_a(k * 2, 0, j));
                power += ForgeHooks.getEnchantPower((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177982_a(k * 2, 1, j));
                power += ForgeHooks.getEnchantPower((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177982_a(k, 0, j * 2));
                power += ForgeHooks.getEnchantPower((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177982_a(k, 1, j * 2));
            }
        }
        this.bookshelfPower = Math.min((int)power, MatrixEnchanting.maxBookshelves);
    }

    public void writeSharedNBT(NBTTagCompound cmp) {
        super.writeSharedNBT(cmp);
        NBTTagCompound matrixCmp = new NBTTagCompound();
        if (this.matrix != null) {
            this.matrix.writeToNBT(matrixCmp);
            cmp.func_74782_a(TAG_MATRIX, (NBTBase)matrixCmp);
            if (this.matrixId != null) {
                cmp.func_74772_a(TAG_MATRIX_UUID_LESS, this.matrixId.getLeastSignificantBits());
                cmp.func_74772_a(TAG_MATRIX_UUID_MOST, this.matrixId.getMostSignificantBits());
            }
        }
        cmp.func_74768_a(TAG_CHARGE, this.charge);
    }

    public void readSharedNBT(NBTTagCompound cmp) {
        super.readSharedNBT(cmp);
        if (cmp.func_74764_b(TAG_MATRIX)) {
            long least = cmp.func_74763_f(TAG_MATRIX_UUID_LESS);
            long most = cmp.func_74763_f(TAG_MATRIX_UUID_MOST);
            UUID newId = new UUID(most, least);
            if (!newId.equals(this.matrixId)) {
                NBTTagCompound matrixCmp = cmp.func_74775_l(TAG_MATRIX);
                this.matrixId = newId;
                this.matrix = new EnchantmentMatrix(this.func_70301_a(0), new Random());
                this.matrix.readFromNBT(matrixCmp);
            }
        } else {
            this.matrix = null;
        }
        this.charge = cmp.func_74762_e(TAG_CHARGE);
    }

    @Nonnull
    public Container func_174876_a(@Nonnull InventoryPlayer playerInventory, @Nonnull EntityPlayer playerIn) {
        return new ContainerMatrixEnchanting(playerInventory, this);
    }
}

