/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.management.feature;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import vazkii.arl.network.NetworkHandler;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.network.message.MessageDeleteItem;
import vazkii.quark.management.client.gui.GuiButtonTrash;
import vazkii.quark.management.feature.FavoriteItems;

public class DeleteItems
extends Feature {
    public static boolean keyboardDown = false;
    public static boolean mouseDown = false;
    @SideOnly(value=Side.CLIENT)
    public static GuiButtonTrash trash;
    public static boolean trashButton;
    public static boolean playerInvOnly;
    public static boolean needsShift;
    public static int trashButtonX;
    public static int trashButtonY;

    @Override
    public void setupConfig() {
        trashButton = this.loadPropBool("Enable Trash Button", "", true);
        playerInvOnly = this.loadPropBool("Trash Button only on Player Inventory", "", false);
        trashButtonX = this.loadPropInt("Trash Button X", "", 3);
        trashButtonY = this.loadPropInt("Trash Button Y", "", -25);
        needsShift = this.loadPropBool("Trash Button Needs Shift", "", true);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void initGui(GuiScreenEvent.InitGuiEvent.Post event) {
        trash = null;
        if (event.getGui() instanceof GuiContainer && trashButton) {
            GuiContainer guiInv = (GuiContainer)event.getGui();
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            boolean isPlayerInv = guiInv instanceof GuiInventory;
            boolean creative = player.func_184812_l_();
            if (creative || !isPlayerInv && playerInvOnly) {
                return;
            }
            int guiWidth = guiInv.getXSize();
            int guiHeight = guiInv.getYSize();
            trash = new GuiButtonTrash((GuiScreen)guiInv, 82424, guiWidth + trashButtonX, guiHeight + trashButtonY, needsShift);
            event.getButtonList().add(trash);
            this.updateTrashPos(guiInv);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void mouseEvent(GuiScreenEvent.MouseInputEvent.Pre event) {
        boolean oldMouseDown = mouseDown;
        mouseDown = Mouse.isButtonDown((int)0);
        Minecraft mc = Minecraft.func_71410_x();
        GuiScreen current = Minecraft.func_71410_x().field_71462_r;
        if (mouseDown != oldMouseDown && current instanceof GuiContainer && trash != null && DeleteItems.trash.ready) {
            NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageDeleteItem(-1));
            event.setCanceled(true);
            mc.field_71439_g.field_71071_by.func_70437_b(ItemStack.field_190927_a);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void keyboardEvent(GuiScreenEvent.KeyboardInputEvent.Post event) {
        IInventory inv;
        GuiContainer gui;
        Slot slot;
        boolean down = Keyboard.isKeyDown((int)211);
        if (GuiScreen.func_146271_m() && down && !keyboardDown && event.getGui() instanceof GuiContainer && (slot = (gui = (GuiContainer)event.getGui()).getSlotUnderMouse()) != null && (inv = slot.field_75224_c) instanceof InventoryPlayer) {
            int index = slot.getSlotIndex();
            if (Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d && index >= 36) {
                index -= 36;
            }
            if (index < ((InventoryPlayer)inv).field_70462_a.size()) {
                NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageDeleteItem(index));
            }
        }
        keyboardDown = down;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void update(TickEvent.ClientTickEvent event) {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui instanceof GuiContainer && trash != null) {
            GuiContainer inv = (GuiContainer)gui;
            this.updateTrashPos(inv);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateTrashPos(GuiContainer inv) {
        if (trash != null) {
            DeleteItems.trash.field_146128_h = inv.getGuiLeft() + DeleteItems.trash.shiftX;
            DeleteItems.trash.field_146129_i = inv.getGuiTop() + DeleteItems.trash.shiftY;
        }
    }

    public static void deleteItem(EntityPlayer player, int slot) {
        ItemStack stack;
        if (slot > player.field_71071_by.field_70462_a.size()) {
            return;
        }
        ItemStack itemStack = stack = slot == -1 ? player.field_71071_by.func_70445_o() : player.field_71071_by.func_70301_a(slot);
        if (!DeleteItems.canItemBeDeleted(stack)) {
            return;
        }
        if (slot == -1) {
            player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
        } else {
            player.field_71071_by.func_70299_a(slot, ItemStack.field_190927_a);
        }
    }

    public static boolean canItemBeDeleted(ItemStack stack) {
        return ModuleLoader.isFeatureEnabled(DeleteItems.class) && !stack.func_190926_b() && !FavoriteItems.isItemFavorited(stack);
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }

    @Override
    public String getFeatureIngameConfigName() {
        return "Delete Items";
    }

    @Nullable
    public static GuiButtonTrash getTrash() {
        return trash;
    }
}

