/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.management.feature;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.network.NetworkHandler;
import vazkii.quark.base.Quark;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.network.message.MessageRequestPassengerChest;
import vazkii.quark.decoration.item.ItemChestBlock;
import vazkii.quark.management.client.render.RenderChestPassenger;
import vazkii.quark.management.entity.EntityChestPassenger;

public class ChestsInBoats
extends Feature {
    @Override
    public void preInit(FMLPreInitializationEvent event) {
        String name = "quark:chest_passenger";
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(name), EntityChestPassenger.class, (String)name, (int)13, (Object)Quark.instance, (int)64, (int)128, (boolean)false);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInitClient() {
        RenderingRegistry.registerEntityRenderingHandler(EntityChestPassenger.class, RenderChestPassenger.factory());
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity target = event.getTarget();
        EntityPlayer player = event.getEntityPlayer();
        if (target instanceof EntityBoat && target.func_184188_bt().isEmpty()) {
            EnumHand hand = EnumHand.MAIN_HAND;
            ItemStack stack = player.func_184614_ca();
            if (!this.isChest(stack)) {
                stack = player.func_184592_cb();
                hand = EnumHand.OFF_HAND;
            }
            if (this.isChest(stack)) {
                World world = event.getWorld();
                EntityChestPassenger passenger = new EntityChestPassenger(world, stack);
                passenger.func_70107_b(target.field_70165_t, target.field_70163_u, target.field_70161_v);
                passenger.field_70177_z = target.field_70177_z;
                if (!event.getWorld().field_72995_K) {
                    if (!player.func_184812_l_()) {
                        stack.func_190918_g(1);
                    }
                    world.func_72838_d((Entity)passenger);
                    passenger.func_184220_m(target);
                }
                player.func_184609_a(hand);
                event.setCancellationResult(EnumActionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    @SideOnly(value=Side.CLIENT)
    public void onOpenGUI(GuiOpenEvent event) {
        Entity riding;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && event.getGui() instanceof GuiInventory && player.func_184218_aH() && (riding = player.func_184187_bx()) instanceof EntityBoat) {
            List passengers = riding.func_184188_bt();
            for (Entity passenger : passengers) {
                if (!(passenger instanceof EntityChestPassenger)) continue;
                NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageRequestPassengerChest());
                event.setCanceled(true);
                return;
            }
        }
    }

    private boolean isChest(ItemStack stack) {
        return stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae) || stack.func_77973_b() instanceof ItemChestBlock;
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

