/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.client.feature;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTippedArrow;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.lib.LibMisc;
import vazkii.quark.base.module.Feature;

public class VisualStatDisplay
extends Feature {
    public static final ImmutableSet<String> VALID_ATTRIBUTES = ImmutableSet.of((Object)"generic.attackDamage", (Object)"generic.attackSpeed", (Object)"generic.reachDistance", (Object)"generic.armor", (Object)"generic.armorToughness", (Object)"generic.knockbackResistance", (Object[])new String[]{"generic.maxHealth", "generic.movementSpeed", "generic.luck"});
    private static final ImmutableSet<String> MULTIPLIER_ATTRIBUTES = ImmutableSet.of((Object)"generic.movementSpeed");
    private static final ImmutableSet<String> POTION_MULTIPLIER_ATTRIBUTES = ImmutableSet.of((Object)"generic.attackSpeed");
    private static final ImmutableSet<String> PERCENT_ATTRIBUTES = ImmutableSet.of((Object)"generic.knockbackResistance", (Object)"generic.luck");
    private static final UUID DUMMY_UUID = new UUID(0L, 0L);
    private static final AttributeModifier DUMMY_MODIFIER = new AttributeModifier(DUMMY_UUID, "NO-OP", 0.0, 0);
    private static final ImmutableSet<String> ATTRIBUTE_FORMATS = ImmutableSet.of((Object)"plus", (Object)"take", (Object)"equals");

    private String format(String attribute, double value, EntityEquipmentSlot slot) {
        if (PERCENT_ATTRIBUTES.contains((Object)attribute)) {
            return (value > 0.0 ? "+" : "") + ItemStack.field_111284_a.format(value * 100.0) + "%";
        }
        if (MULTIPLIER_ATTRIBUTES.contains((Object)attribute) || slot == null && POTION_MULTIPLIER_ATTRIBUTES.contains((Object)attribute)) {
            return ItemStack.field_111284_a.format(value / this.baseValue(attribute)) + "x";
        }
        return ItemStack.field_111284_a.format(value);
    }

    private double baseValue(String attribute) {
        switch (attribute) {
            case "generic.movementSpeed": {
                return 0.1;
            }
            case "generic.attackSpeed": {
                return 4.0;
            }
        }
        return 1.0;
    }

    private int renderPosition(String attribute) {
        switch (attribute) {
            case "generic.attackDamage": {
                return 238;
            }
            case "generic.attackSpeed": {
                return 247;
            }
            case "generic.reachDistance": {
                return 193;
            }
            case "generic.armor": {
                return 229;
            }
            case "generic.armorToughness": {
                return 220;
            }
            case "generic.knockbackResistance": {
                return 175;
            }
            case "generic.maxHealth": {
                return 211;
            }
            case "generic.movementSpeed": {
                return 184;
            }
            case "generic.luck": {
                return 202;
            }
        }
        return 211;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void makeTooltip(ItemTooltipEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack stack = event.getItemStack();
        if (!GuiScreen.func_146272_n() && this.canStripAttributes(stack)) {
            List tooltip = event.getToolTip();
            HashMap attributeTooltips = Maps.newHashMap();
            boolean onlyInvalid = true;
            Multimap<String, AttributeModifier> baseCheck = null;
            boolean allAreSame = true;
            EntityEquipmentSlot[] slots = EntityEquipmentSlot.values();
            for (EntityEquipmentSlot slot : slots = Arrays.copyOf(slots, slots.length + 1)) {
                Multimap<String, AttributeModifier> slotAttributes = VisualStatDisplay.getModifiers(stack, slot);
                if (baseCheck == null) {
                    baseCheck = slotAttributes;
                } else if (allAreSame && !slotAttributes.equals(baseCheck)) {
                    allAreSame = false;
                }
                if (!slotAttributes.isEmpty()) {
                    String slotDesc = I18n.func_135052_a((String)(slot == null ? TextFormatting.DARK_PURPLE + I18n.func_135052_a((String)"potion.whenDrank", (Object[])new Object[0]) : "item.modifiers." + slot.func_188450_d()), (Object[])new Object[0]);
                    int index = tooltip.indexOf(slotDesc) - 1;
                    if (index < 0) continue;
                    tooltip.remove(index);
                    tooltip.remove(index);
                }
                onlyInvalid = this.extractAttributeValues(event, stack, tooltip, attributeTooltips, onlyInvalid, slot, slotAttributes);
            }
            EntityEquipmentSlot primarySlot = EntityLiving.func_184640_d((ItemStack)stack);
            boolean showSlots = !allAreSame && (onlyInvalid || attributeTooltips.size() == 1 && attributeTooltips.containsKey(primarySlot));
            for (int i = 0; i < slots.length; ++i) {
                EntityEquipmentSlot slot;
                slot = slots[slots.length - (i + 1)];
                if (!attributeTooltips.containsKey(slot)) continue;
                int len = mc.field_71466_p.func_78256_a(((StringBuilder)attributeTooltips.get(slot)).toString()) + 32;
                if (showSlots) {
                    len += 20;
                }
                int space = mc.field_71466_p.func_78263_a(' ');
                StringBuilder spaces = new StringBuilder();
                for (int j = 0; j < len / space; ++j) {
                    spaces.append(' ');
                }
                tooltip.add(1, spaces.toString());
                if (allAreSame) break;
            }
        }
    }

    public static Multimap<String, AttributeModifier> getModifiers(ItemStack stack, EntityEquipmentSlot slot) {
        if (slot == null) {
            List potions = PotionUtils.func_185189_a((ItemStack)stack);
            HashMultimap out = HashMultimap.create();
            for (PotionEffect potioneffect : potions) {
                Potion potion = potioneffect.func_188419_a();
                Map map = potion.func_111186_k();
                for (IAttribute attribute : map.keySet()) {
                    AttributeModifier baseModifier = (AttributeModifier)map.get(attribute);
                    AttributeModifier amplified = new AttributeModifier(baseModifier.func_111166_b(), potion.func_111183_a(potioneffect.func_76458_c(), baseModifier), baseModifier.func_111169_c());
                    out.put((Object)attribute.func_111108_a(), (Object)amplified);
                }
            }
            return out;
        }
        Multimap out = stack.func_111283_C(slot);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            if (EnchantmentHelper.func_152377_a((ItemStack)stack, (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED) > 0.0f) {
                out.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)DUMMY_MODIFIER);
            }
            if (out.containsKey((Object)SharedMonsterAttributes.field_111264_e.func_111108_a()) && !out.containsKey((Object)SharedMonsterAttributes.field_188790_f.func_111108_a())) {
                out.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)DUMMY_MODIFIER);
            } else if (out.containsKey((Object)SharedMonsterAttributes.field_188790_f.func_111108_a()) && !out.containsKey((Object)SharedMonsterAttributes.field_111264_e.func_111108_a())) {
                out.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)DUMMY_MODIFIER);
            }
        }
        return out;
    }

    public boolean extractAttributeValues(ItemTooltipEvent event, ItemStack stack, List<String> tooltip, Map<EntityEquipmentSlot, StringBuilder> attributeTooltips, boolean onlyInvalid, EntityEquipmentSlot slot, Multimap<String, AttributeModifier> slotAttributes) {
        boolean anyInvalid = false;
        block0: for (String s : slotAttributes.keys()) {
            if (VALID_ATTRIBUTES.contains((Object)s)) {
                onlyInvalid = false;
                double attributeValue = this.getAttribute(event.getEntityPlayer(), slot, stack, slotAttributes, s);
                if (attributeValue != 0.0) {
                    if (!attributeTooltips.containsKey(slot)) {
                        attributeTooltips.put(slot, new StringBuilder());
                    }
                    attributeTooltips.get(slot).append(this.format(s, attributeValue, slot));
                }
            } else if (!anyInvalid) {
                anyInvalid = true;
                if (!attributeTooltips.containsKey(slot)) {
                    attributeTooltips.put(slot, new StringBuilder());
                }
                attributeTooltips.get(slot).append("[+]");
            }
            for (int i = 1; i < tooltip.size(); ++i) {
                if (!VisualStatDisplay.isAttributeLine(tooltip.get(i), s)) continue;
                tooltip.remove(i);
                continue block0;
            }
        }
        return onlyInvalid;
    }

    @SideOnly(value=Side.CLIENT)
    private static boolean isAttributeLine(String line, String attName) {
        String attNameLoc = I18n.func_135052_a((String)("attribute.name." + attName), (Object[])new Object[0]);
        line = Objects.toString(TextFormatting.func_110646_a((String)line)).trim();
        for (String att : ATTRIBUTE_FORMATS) {
            for (int mod = 0; mod < 3; ++mod) {
                String pattern = I18n.func_135052_a((String)("attribute.modifier." + att + "." + mod), (Object[])new Object[]{"\n", attNameLoc});
                String[] split = pattern.split("\n");
                if (split.length != 2 || !line.startsWith(split[0]) || !line.endsWith(split[1])) continue;
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private int renderAttribute(String attribute, EntityEquipmentSlot slot, int x, int y, ItemStack stack, Multimap<String, AttributeModifier> slotAttributes, Minecraft mc) {
        double value = this.getAttribute((EntityPlayer)mc.field_71439_g, slot, stack, slotAttributes, attribute);
        if (value != 0.0) {
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            mc.func_110434_K().func_110577_a(LibMisc.GENERAL_ICONS_RESOURCE);
            Gui.func_146110_a((int)x, (int)y, (float)this.renderPosition(attribute), (float)0.0f, (int)9, (int)9, (float)256.0f, (float)256.0f);
            String valueStr = this.format(attribute, value, slot);
            int color = value < 0.0 || valueStr.endsWith("x") && value / this.baseValue(attribute) < 1.0 ? 0xFF5555 : 0xFFFFFF;
            mc.field_71466_p.func_175063_a(valueStr, (float)(x + 12), (float)(y + 1), color);
            x += mc.field_71466_p.func_78256_a(valueStr) + 20;
        }
        return x;
    }

    private EntityEquipmentSlot getPrimarySlot(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemPotion || stack.func_77973_b() instanceof ItemTippedArrow) {
            return null;
        }
        return EntityLiving.func_184640_d((ItemStack)stack);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderTooltip(RenderTooltipEvent.PostText event) {
        ItemStack stack = event.getStack();
        if (!GuiScreen.func_146272_n() && this.canStripAttributes(stack)) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft mc = Minecraft.func_71410_x();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)mc.func_175599_af().field_77023_b);
            int baseX = event.getX();
            int y = event.getY() + 10;
            for (int i = 1; i < event.getLines().size(); ++i) {
                String s = (String)event.getLines().get(i);
                if ((s = TextFormatting.func_110646_a((String)s)) == null || !s.trim().isEmpty()) continue;
                y += 10 * (i - 1) + 1;
                break;
            }
            EntityEquipmentSlot primarySlot = this.getPrimarySlot(stack);
            boolean onlyInvalid = true;
            boolean showSlots = false;
            int attributeHash = 0;
            boolean allAreSame = true;
            EntityEquipmentSlot[] slots = EntityEquipmentSlot.values();
            block1: for (EntityEquipmentSlot slot : slots = Arrays.copyOf(slots, slots.length + 1)) {
                Multimap<String, AttributeModifier> slotAttributes = VisualStatDisplay.getModifiers(stack, slot);
                if (slot == EntityEquipmentSlot.MAINHAND) {
                    attributeHash = slotAttributes.hashCode();
                } else if (allAreSame && attributeHash != slotAttributes.hashCode()) {
                    allAreSame = false;
                }
                for (String s : slotAttributes.keys()) {
                    if (!VALID_ATTRIBUTES.contains((Object)s)) continue;
                    onlyInvalid = false;
                    if (slot == primarySlot) continue;
                    showSlots = true;
                    break block1;
                }
            }
            if (allAreSame) {
                showSlots = false;
            } else if (onlyInvalid) {
                showSlots = true;
            }
            for (EntityEquipmentSlot slot : slots) {
                int x = baseX;
                Multimap<String, AttributeModifier> slotAttributes = VisualStatDisplay.getModifiers(stack, slot);
                boolean anyToRender = false;
                for (String s : slotAttributes.keys()) {
                    double value = this.getAttribute((EntityPlayer)mc.field_71439_g, slot, stack, slotAttributes, s);
                    if (value == 0.0) continue;
                    anyToRender = true;
                    break;
                }
                if (!anyToRender) continue;
                if (showSlots) {
                    GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                    mc.func_110434_K().func_110577_a(LibMisc.GENERAL_ICONS_RESOURCE);
                    Gui.func_146110_a((int)x, (int)y, (float)(202 + (slot == null ? -1 : slot.ordinal()) * 9), (float)35.0f, (int)9, (int)9, (float)256.0f, (float)256.0f);
                    x += 20;
                }
                for (String key : VALID_ATTRIBUTES) {
                    x = this.renderAttribute(key, slot, x, y, stack, slotAttributes, mc);
                }
                for (String key : slotAttributes.keys()) {
                    if (VALID_ATTRIBUTES.contains((Object)key)) continue;
                    mc.field_71466_p.func_175063_a("[+]", (float)(x + 1), (float)(y + 1), 0xFFFF55);
                    break;
                }
                y += 10;
                if (allAreSame) break;
            }
            GlStateManager.func_179121_F();
        }
    }

    private boolean canStripAttributes(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return (ItemNBTHelper.getInt((ItemStack)stack, (String)"HideFlags", (int)0) & 2) == 0;
    }

    private double getAttribute(EntityPlayer player, EntityEquipmentSlot slot, ItemStack stack, Multimap<String, AttributeModifier> map, String key) {
        IAttributeInstance attribute;
        if (player == null) {
            return 0.0;
        }
        Collection collection = map.get((Object)key);
        if (collection.isEmpty()) {
            return 0.0;
        }
        double value = 0.0;
        if (!(PERCENT_ATTRIBUTES.contains((Object)key) || slot == null && key.equals(SharedMonsterAttributes.field_111264_e.func_111108_a()) || (attribute = player.func_110140_aT().func_111152_a(key)) == null)) {
            value = attribute.func_111125_b();
        }
        for (AttributeModifier modifier : collection) {
            if (modifier.func_111169_c() != 0) continue;
            value += modifier.func_111164_d();
        }
        double rawValue = value;
        for (AttributeModifier modifier : collection) {
            if (modifier.func_111169_c() != 1) continue;
            value += rawValue * modifier.func_111164_d();
        }
        for (AttributeModifier modifier : collection) {
            if (modifier.func_111169_c() != 2) continue;
            value += value * modifier.func_111164_d();
        }
        if (key.equals(SharedMonsterAttributes.field_111264_e.func_111108_a()) && slot == EntityEquipmentSlot.MAINHAND) {
            value += (double)EnchantmentHelper.func_152377_a((ItemStack)stack, (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED);
        }
        return value;
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }
}

